/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.common.utils.SlotReference;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;

public class CuriosCompat {
    static IKeyLockable.KeyStatus getKey(Player player, String password) {
        List found = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, i -> i.m_204117_(ModTags.KEYS) || i.m_41720_() instanceof KeyItem);
        if (found.isEmpty()) {
            return IKeyLockable.KeyStatus.NO_KEY;
        }
        for (SlotResult slot : found) {
            ItemStack stack = slot.stack();
            if (!IKeyLockable.getKeyStatus(stack, password).isCorrect()) continue;
            return IKeyLockable.KeyStatus.CORRECT_KEY;
        }
        return IKeyLockable.KeyStatus.INCORRECT_KEY;
    }

    static SlotReference getQuiver(Player player) {
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        List found = curiosHelper.findCurios((LivingEntity)player, i -> i.m_150930_((Item)ModRegistry.QUIVER_ITEM.get()));
        if (!found.isEmpty()) {
            SlotContext context = ((SlotResult)found.get(0)).slotContext();
            return new Curio(context.identifier(), context.index());
        }
        return SlotReference.EMPTY;
    }

    static {
        SlotReference.REGISTRY.register("curio", Curio.CODEC);
    }

    public record Curio(String id, int index) implements SlotReference
    {
        public static final Codec<Curio> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Curio::id), (App)Codec.INT.fieldOf("index").forGetter(Curio::index)).apply((Applicative)instance, Curio::new));

        @Override
        public ItemStack get(LivingEntity player) {
            ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
            return curiosHelper.findCurio(player, this.id, this.index).map(SlotResult::stack).orElse(ItemStack.f_41583_);
        }

        @Override
        public Codec<? extends SlotReference> getCodec() {
            return CODEC;
        }
    }
}

