/*
 * Decompiled with CFR 0.152.
 */
package cn.leomc.teamprojecte;

import cn.leomc.teamprojecte.EMCData;
import cn.leomc.teamprojecte.KnowledgeData;
import cn.leomc.teamprojecte.TPSavedData;
import cn.leomc.teamprojecte.TeamProjectE;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import moze_intel.projecte.api.ItemInfo;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;

public class TPTeam {
    private final UUID teamUUID;
    private UUID owner;
    private final List<UUID> members;
    private KnowledgeData knowledge;
    private EMCData emc;

    public TPTeam(UUID teamUUID, UUID owner) {
        this.teamUUID = teamUUID;
        this.owner = owner;
        this.members = new ArrayList<UUID>();
        this.knowledge = new KnowledgeData.Sharing();
        this.emc = new EMCData.Sharing();
    }

    public TPTeam(UUID owner) {
        this(UUID.randomUUID(), owner);
    }

    public TPTeam(CompoundTag tag, String version) {
        this.teamUUID = tag.m_128342_("uuid");
        this.owner = tag.m_128342_("owner");
        this.members = new ArrayList<UUID>();
        this.members.addAll(tag.m_128437_("members", 10).stream().map(t -> ((CompoundTag)t).m_128342_("uuid")).toList());
        switch (version) {
            case "": {
                this.knowledge = new KnowledgeData.Sharing();
                tag.m_128437_("knowledge", 10).stream().map(t -> ItemInfo.read((CompoundTag)((CompoundTag)t))).filter(Objects::nonNull).forEach(info -> this.knowledge.addKnowledge((ItemInfo)info, Util.f_137441_));
                this.emc = new EMCData.Sharing();
                this.emc.setEMC(new BigInteger(tag.m_128461_("emc")), Util.f_137441_);
                break;
            }
            case "1": {
                this.knowledge = KnowledgeData.of(tag.m_128469_("knowledge"));
                this.emc = EMCData.of(tag.m_128469_("emc"));
            }
        }
    }

    public UUID getUUID() {
        return this.teamUUID;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void addMemberWithKnowledge(TPTeam originalTeam, Player player) {
        this.markDirty();
        UUID playerUUID = TeamProjectE.getPlayerUUID(player);
        this.addMember(playerUUID);
        if (originalTeam.getOwner().equals(playerUUID)) {
            this.setEmc(this.getEmc(playerUUID).add(originalTeam.getEmc(playerUUID)), playerUUID);
            originalTeam.setEmc(BigInteger.ZERO, playerUUID);
            if (originalTeam.hasFullKnowledge(playerUUID)) {
                this.setFullKnowledge(true, playerUUID);
                originalTeam.setFullKnowledge(false, playerUUID);
            }
            originalTeam.getKnowledge(playerUUID).forEach(k -> this.addKnowledge((ItemInfo)k, playerUUID));
            originalTeam.clearKnowledge(playerUUID);
        } else {
            if (!originalTeam.isSharingEMC()) {
                this.setEmc(originalTeam.getEmc(playerUUID), playerUUID);
                originalTeam.setEmc(BigInteger.ZERO, playerUUID);
            }
            if (!originalTeam.isSharingKnowledge()) {
                if (originalTeam.hasFullKnowledge(playerUUID)) {
                    this.setFullKnowledge(true, playerUUID);
                    originalTeam.setFullKnowledge(false, playerUUID);
                }
                originalTeam.getKnowledge(playerUUID).forEach(k -> this.addKnowledge((ItemInfo)k, playerUUID));
                originalTeam.clearKnowledge(playerUUID);
            }
        }
        originalTeam.removeMember(playerUUID);
        this.sync();
    }

    public void addMember(UUID uuid) {
        this.markDirty();
        TPSavedData.getData().invalidateCache(uuid);
        this.members.add(uuid);
        this.sync();
    }

    public void removeMember(UUID uuid) {
        this.markDirty();
        TPSavedData.getData().invalidateCache(uuid);
        this.knowledge.removeMember(uuid);
        this.emc.removeMember(uuid);
        if (this.owner.equals(uuid)) {
            UUID newOwner;
            if (this.members.isEmpty()) {
                TPSavedData.getData().teams.remove(this.teamUUID);
                return;
            }
            this.owner = newOwner = this.members.get(ThreadLocalRandom.current().nextInt(this.members.size()));
            this.members.remove(newOwner);
        } else {
            this.members.remove(uuid);
        }
        this.sync(uuid);
    }

    public void transferOwner(UUID newOwner) {
        if (this.owner.equals(newOwner) || !this.members.contains(newOwner)) {
            return;
        }
        this.members.add(this.owner);
        this.owner = newOwner;
        this.members.remove(newOwner);
    }

    public List<UUID> getMembers() {
        return List.copyOf(this.members);
    }

    public List<UUID> getAll() {
        return Lists.asList((Object)this.owner, (Object[])((UUID[])this.members.toArray(UUID[]::new)));
    }

    public boolean addKnowledge(ItemInfo info, UUID player) {
        this.markDirty();
        return this.knowledge.addKnowledge(info, player);
    }

    public boolean removeKnowledge(ItemInfo info, UUID player) {
        this.markDirty();
        return this.knowledge.removeKnowledge(info, player);
    }

    public void clearKnowledge(UUID player) {
        this.markDirty();
        this.knowledge.clearKnowledge(player);
    }

    public Set<ItemInfo> getKnowledge(UUID player) {
        return this.knowledge.getKnowledge(player);
    }

    public void setEmc(BigInteger emc, UUID player) {
        this.markDirty();
        this.emc.setEMC(emc, player);
    }

    public BigInteger getEmc(UUID player) {
        return this.emc.getEMC(player);
    }

    public void setFullKnowledge(boolean fullKnowledge, UUID player) {
        this.markDirty();
        this.knowledge.setFullKnowledge(fullKnowledge, player);
    }

    public boolean hasFullKnowledge(UUID player) {
        return this.knowledge.hasFullKnowledge(player);
    }

    public boolean isSharingEMC() {
        return this.emc instanceof EMCData.Sharing;
    }

    public boolean isSharingKnowledge() {
        return this.knowledge instanceof KnowledgeData.Sharing;
    }

    public void setShareEMC(boolean share) {
        if (this.isSharingEMC() == share) {
            return;
        }
        this.emc = this.emc.convert(this.getOwner());
        this.markDirty();
        this.sync();
    }

    public void setShareKnowledge(boolean share) {
        if (this.isSharingKnowledge() == share) {
            return;
        }
        this.knowledge = this.knowledge.convert(this.getOwner());
        this.markDirty();
        this.sync();
    }

    public void markDirty() {
        TPSavedData.getData().m_77762_();
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128362_("uuid", this.teamUUID);
        tag.m_128362_("owner", this.owner);
        ListTag list = new ListTag();
        for (UUID member : this.members) {
            CompoundTag t = new CompoundTag();
            t.m_128362_("uuid", member);
            list.add((Object)t);
        }
        tag.m_128365_("members", (Tag)list);
        tag.m_128365_("knowledge", (Tag)this.knowledge.save());
        tag.m_128365_("emc", (Tag)this.emc.save());
        return tag;
    }

    public static TPTeam getOrCreateTeam(UUID uuid) {
        TPTeam team = TPTeam.getTeamByMember(uuid);
        if (team == null) {
            team = TPTeam.createTeam(uuid);
        }
        return team;
    }

    public static TPTeam createTeam(UUID uuid) {
        TPTeam team = new TPTeam(uuid);
        TPSavedData.getData().teams.put(team.getUUID(), team);
        TPSavedData.getData().m_77762_();
        return team;
    }

    public static TPTeam getTeam(UUID uuid) {
        return TPSavedData.getData().teams.get(uuid);
    }

    public static boolean isInTeam(UUID uuid) {
        return TPTeam.getTeamByMember(uuid) != null;
    }

    public static TPTeam getTeamByMember(UUID uuid) {
        UUID teamUUID = TPSavedData.getData().playerTeamCache.get(uuid);
        if (teamUUID == null) {
            for (Map.Entry<UUID, TPTeam> entry : TPSavedData.getData().teams.entrySet()) {
                if (!entry.getValue().getAll().contains(uuid)) continue;
                teamUUID = entry.getKey();
                TPSavedData.getData().playerTeamCache.put(uuid, teamUUID);
                break;
            }
        }
        if (teamUUID != null) {
            return TPSavedData.getData().teams.get(teamUUID);
        }
        return null;
    }

    public void sync() {
        TeamProjectE.getAllOnline(this.getAll()).forEach(TeamProjectE::sync);
    }

    public void sync(UUID uuid) {
        TeamProjectE.getAllOnline(List.of(uuid)).forEach(TeamProjectE::sync);
    }
}

