/*
 * Decompiled with CFR 0.152.
 */
package me.codexadrian.tempad.api.options.impl;

import java.util.ArrayList;
import java.util.List;
import me.codexadrian.tempad.api.options.TempadOption;
import me.codexadrian.tempad.api.options.TempadOptionApi;
import me.codexadrian.tempad.common.Tempad;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemOption
extends TempadOption {
    private int cost = 0;

    @Override
    public boolean canTimedoorOpen(Player player, ItemStack stack) {
        this.cost = TempadOptionApi.getFuelCost(stack);
        int available = 0;
        for (ItemStack item : this.findItemStacks(player.m_150109_())) {
            available += item.m_41613_();
        }
        return available >= this.cost;
    }

    @Override
    public void onTimedoorOpen(Player player) {
        Inventory inventory = player.m_150109_();
        for (ItemStack item : this.findItemStacks(inventory)) {
            int count = item.m_41613_();
            int remainingCost = this.cost - count;
            if (remainingCost < 0) {
                item.m_41764_(Math.abs(remainingCost));
                break;
            }
            this.cost -= item.m_41613_();
            inventory.m_36057_(item);
        }
    }

    @Override
    public void addToolTip(ItemStack stack, Level level, List<Component> components, TooltipFlag flag) {
        components.add((Component)Component.m_237115_((String)"tooltip.tempad.item_option_info"));
    }

    @Override
    public boolean isDurabilityBarVisible(ItemStack stack) {
        return false;
    }

    public List<ItemStack> findItemStacks(Inventory inventory) {
        NonNullList playerItems = inventory.f_35974_;
        NonNullList playerOffhand = inventory.f_35976_;
        List<ItemStack> items = this.findItemStacks((NonNullList<ItemStack>)playerItems);
        items.addAll(this.findItemStacks((NonNullList<ItemStack>)playerOffhand));
        return items;
    }

    public List<ItemStack> findItemStacks(NonNullList<ItemStack> itemStacks) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (ItemStack item : itemStacks) {
            if (!item.m_204117_(Tempad.TEMPAD_FUEL_TAG)) continue;
            items.add(item);
        }
        return items;
    }
}

