/*
 * Decompiled with CFR 0.152.
 */
package com.magorage.tiab.api;

import com.magorage.tiab.api.events.ITimeBottleTickEvent;
import com.magorage.tiab.api.events.ITimeBottleUseEvent;
import com.magorage.tiab.api.events.ITimeCommandEvent;

public class TiabAPIHooks {
    private final ITimeBottleTickEvent tickEvent;
    private final ITimeBottleUseEvent useEvent;
    private final ITimeCommandEvent commandEvent;

    public static Builder create() {
        return new Builder();
    }

    private TiabAPIHooks(ITimeBottleTickEvent tickEvent, ITimeBottleUseEvent useEvent, ITimeCommandEvent commandEvent) {
        this.tickEvent = tickEvent;
        this.useEvent = useEvent;
        this.commandEvent = commandEvent;
    }

    public ITimeBottleTickEvent getTickEvent() {
        return this.tickEvent;
    }

    public ITimeBottleUseEvent getUseEvent() {
        return this.useEvent;
    }

    public ITimeCommandEvent getCommandEvent() {
        return this.commandEvent;
    }

    public static class Builder {
        private ITimeBottleTickEvent tickEvent;
        private ITimeBottleUseEvent useEvent;
        private ITimeCommandEvent commandEvent;

        public Builder setCommandEvent(ITimeCommandEvent commandEvent) {
            this.commandEvent = commandEvent;
            return this;
        }

        public Builder setTickEvent(ITimeBottleTickEvent tickEvent) {
            this.tickEvent = tickEvent;
            return this;
        }

        public Builder setUseEvent(ITimeBottleUseEvent useEvent) {
            this.useEvent = useEvent;
            return this;
        }

        public TiabAPIHooks build() {
            return new TiabAPIHooks(this.tickEvent, this.useEvent, this.commandEvent);
        }
    }
}

