/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.CastingType;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfGuard
extends ItemTablet {
    public ItemTabletOfGuard() {
        super("tablet_of_guard", () -> SharedConfigTombstone.allowed_magic_items.allowTabletOfHome.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Level level, List<Component> tooltip) {
        if (this.isAncient(stack)) {
            this.addItemDesc(tooltip, "_ancient", new Object[0]);
        } else {
            this.addItemDesc(tooltip);
        }
        this.addItemUse(tooltip, !this.isEnchanted(stack) ? "1" : "2", new Object[0]);
        super.addTooltipInfo(stack, level, tooltip);
    }

    @Override
    protected boolean doEffects(ServerLevel world, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Helper.spawnSpectralWolf((Level)world, player.m_20183_(), this.isAncient(stack) ? 120000 : 12000, null);
        ModTriggers.USE_GUARD.trigger(player);
        return true;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        NBTStackHelper.setBoolean(stack, "enchant", true);
        this.setUseCount(stack, this.getUseMax());
        if (!this.isAncient(stack) && soulStrength > 1) {
            NBTStackHelper.setBoolean(stack, "ancient", true);
            return ISoulConsumer.ConsumeResult.success(2);
        }
        return ISoulConsumer.ConsumeResult.success(1);
    }

    @Override
    protected CastingType getCastingType(ItemStack stack) {
        return CastingType.SUMMONING;
    }
}

