/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool.client.gui;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.aenetvistool.ItemNetVisualizer;
import com.brandon3055.brandonscore.client.gui.modulargui.GuiElementManager;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.ModularGuiScreen;
import com.brandon3055.brandonscore.client.gui.modulargui.baseelements.GuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiBorderedRect;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiDraggable;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiLabel;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiPickColourDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiTexture;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.GuiAlign;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;

public class GuiNetVisualizer
extends ModularGuiScreen {
    private static int page = 0;
    private final EntityPlayer player;
    private final EnumHand hand;
    private ItemStack stack;
    private ItemNetVisualizer.ToolData toolData;
    private GuiBorderedRect colourContaienr;
    private GuiBorderedRect renderContaienr;

    public GuiNetVisualizer(EntityPlayer player, EnumHand hand, ItemNetVisualizer.ToolData toolData) {
        this.player = player;
        this.hand = hand;
        this.toolData = toolData;
        this.stack = player.func_184586_b(hand);
        this.xSize = 200;
        this.ySize = 204;
    }

    public void addElements(GuiElementManager manager) {
        GuiDraggable container = (GuiDraggable)new GuiDraggable().setSize(this.xSize, this.ySize);
        container.setDragBarHeight(12);
        container.addAndFireReloadCallback(draggable -> {
            GuiDraggable cfr_ignored_0 = (GuiDraggable)draggable.setPos(this.guiLeft(), this.guiTop());
        });
        manager.add((MGuiElementBase)container);
        container.addChild(GuiTexture.newVanillaGuiTexture((int)this.xSize, (int)this.ySize).setPos((MGuiElementBase)container));
        GuiLabel heading = new GuiLabel(I18n.func_135052_a((String)"gui.netvistool.title", (Object[])new Object[0])).setTextColour(0x404040).setShadow(false);
        heading.setPosAndSize(container.xPos(), container.yPos() + 4, container.xSize(), 10);
        container.addChild((MGuiElementBase)heading);
        GuiButton colourTab = new GuiButton(I18n.func_135052_a((String)"gui.netvistool.button.colour", (Object[])new Object[0]));
        colourTab.setPosAndSize(container.xPos() + 4, heading.maxYPos(), 90, 12);
        colourTab.addChild((MGuiElementBase)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)colourTab)).setYSize(colourTab.ySize() - 1)).setColours(0, -8355712));
        colourTab.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)colourTab)).setBorderColour(0).setFillColourGetter(hovering -> hovering || page == 0 ? -15724528 : -8355712));
        colourTab.setListener(() -> {
            page = 0;
        });
        this.colourContaienr = new GuiBorderedRect().setColours(-15724528, -8355712);
        this.colourContaienr.setEnabledCallback(() -> page == 0);
        this.colourContaienr.setPos(container.xPos() + 4, heading.maxYPos() + 10);
        this.colourContaienr.setSize(container.xSize() - 8, container.ySize() - (this.colourContaienr.yPos() - container.yPos()) - 4);
        container.addChild((MGuiElementBase)this.colourContaienr);
        this.addColourControls((MGuiElementBase)this.colourContaienr);
        container.addChild((MGuiElementBase)colourTab);
        GuiButton renderTab = new GuiButton(I18n.func_135052_a((String)"gui.netvistool.button.render", (Object[])new Object[0]));
        renderTab.setPosAndSize(container.maxXPos() - 94, heading.maxYPos(), 90, 12);
        renderTab.addChild((MGuiElementBase)((GuiBorderedRect)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)renderTab)).setYSize(renderTab.ySize() - 1)).setColours(0, -8355712));
        renderTab.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize((MGuiElementBase)renderTab)).setBorderColour(0).setFillColourGetter(hovering -> hovering || page == 1 ? -15724528 : -8355712));
        renderTab.setListener(() -> {
            page = 1;
        });
        this.renderContaienr = new GuiBorderedRect().setColours(-15724528, -8355712);
        this.renderContaienr.setEnabledCallback(() -> page == 1);
        this.renderContaienr.setPos(container.xPos() + 4, heading.maxYPos() + 10);
        this.renderContaienr.setSize(container.xSize() - 8, container.ySize() - (this.colourContaienr.yPos() - container.yPos()) - 4);
        container.addChild((MGuiElementBase)this.renderContaienr);
        this.addRenderControls((MGuiElementBase)this.renderContaienr);
        container.addChild((MGuiElementBase)renderTab);
    }

    private void addColourControls(MGuiElementBase container) {
        int yPos = container.yPos() + 1;
        yPos = this.addElement(yPos, container, this.createColourElement("cable_node_colour8", () -> this.toolData.cableNodeColour8, integer -> {
            this.toolData.cableNodeColour8 = integer;
        }));
        yPos = this.addElement(yPos, container, this.createColourElement("cable_node_colour32", () -> this.toolData.cableNodeColour32, integer -> {
            this.toolData.cableNodeColour32 = integer;
        }));
        yPos = this.addElement(yPos, container, this.createColourElement("machine_node_colour8", () -> this.toolData.machineNodeColour8, integer -> {
            this.toolData.machineNodeColour8 = integer;
        }));
        yPos = this.addElement(yPos, container, this.createColourElement("machine_node_colour32", () -> this.toolData.machineNodeColour32, integer -> {
            this.toolData.machineNodeColour32 = integer;
        }));
        for (int i = 0; i < this.toolData.p2pColours.length; ++i) {
            int finalI = i;
            yPos = this.addElement(yPos, container, this.createColourElement("p2p_colour_" + i, () -> this.toolData.p2pColours[finalI], integer -> {
                this.toolData.p2pColours[finalI] = integer;
            }));
        }
    }

    private void addRenderControls(MGuiElementBase container) {
        int yPos = container.yPos() + 3;
        yPos = this.addButtonElement(container, yPos, 0, "rand_p2p_colours", () -> this.toolData.randP2PColours, value -> {
            this.toolData.randP2PColours = value;
        }, false);
        yPos = this.addButtonElement(container, yPos, 1, "rand_p2p_colour_offset", () -> this.toolData.randP2PColourOffset, value -> {
            this.toolData.randP2PColourOffset = value;
        }, true) + 10;
        yPos = this.addButtonElement(container, yPos, 0, "render_p2p_no_depth", () -> this.toolData.renderP2PNoDepth, value -> {
            this.toolData.renderP2PNoDepth = value;
        }, true) + 10;
        yPos = this.addButtonElement(container, yPos, 0, "enable_cable_connections", () -> this.toolData.enableCableConnections, value -> {
            this.toolData.enableCableConnections = value;
        }, false);
        yPos = this.addButtonElement(container, yPos, 1, "enable_cable_nodes", () -> this.toolData.enableCableNodes, value -> {
            this.toolData.enableCableNodes = value;
        }, true);
        yPos = this.addButtonElement(container, yPos, 0, "enable_machine_nodes", () -> this.toolData.enableMachineNodes, value -> {
            this.toolData.enableMachineNodes = value;
        }, false);
        yPos = this.addButtonElement(container, yPos, 1, "enable_chanel_labels", () -> this.toolData.enableChanelLabels, value -> {
            this.toolData.enableChanelLabels = value;
        }, true);
        yPos = this.addButtonElement(container, yPos, 0, "enable_p2p", () -> this.toolData.enableP2P, value -> {
            this.toolData.enableP2P = value;
        }, true) + 10;
        yPos = this.addButtonElement(container, yPos, 0, "highlight_inactive_buses", () -> this.toolData.highlightInactiveBuses, value -> {
            this.toolData.highlightInactiveBuses = value;
        }, false);
        yPos = this.addButtonElement(container, yPos, 1, "small_chanel_labels", () -> this.toolData.smallChannelLabels, value -> {
            this.toolData.smallChannelLabels = value;
        }, true);
    }

    private int addElement(int yPos, MGuiElementBase container, MGuiElementBase element) {
        container.addChild(element);
        element.setPos(container.xPos() + 5, yPos);
        return yPos + element.ySize() + 2;
    }

    public MGuiElementBase createColourElement(String local, Supplier<Integer> getter, Consumer<Integer> setter) {
        GuiLabel label = (GuiLabel)new GuiLabel(I18n.func_135052_a((String)("gui.netvistool.cfg." + local), (Object[])new Object[0])).setHoverText(I18n.func_135052_a((String)("gui.netvistool.cfg." + local + ".info"), (Object[])new Object[0]));
        label.setYSize(14);
        label.setXSize((this.colourContaienr.xSize() - 6) / 3 * 2);
        label.setAlignment(GuiAlign.LEFT);
        label.setTrim(false);
        GuiButton colourButton = (GuiButton)new GuiButton().setHoverText(I18n.func_135052_a((String)("gui.netvistool.cfg." + local + ".info"), (Object[])new Object[0]));
        colourButton.setPosAndSize(label.maxXPos(), label.yPos(), label.xSize() / 2, label.ySize());
        colourButton.setVanillaButtonRender(true);
        colourButton.setInsets(3, 3, 3, 3);
        colourButton.addChild((MGuiElementBase)((GuiBorderedRect)new GuiBorderedRect().setPosAndSize(colourButton.getInsetRect())).setFillColourGetter(hovering -> (Integer)getter.get() | 0xFF000000));
        colourButton.setHoverTextDelay(10);
        colourButton.setListener(() -> {
            GuiPickColourDialog dialog = new GuiPickColourDialog((MGuiElementBase)label);
            dialog.setIncludeAlpha(false);
            dialog.setColour(((Integer)getter.get()).intValue());
            dialog.setColourChangeListener(integer -> {
                setter.accept((Integer)integer);
                this.sendConfigToServer();
            });
            dialog.showCenter((MGuiElementBase)this.colourContaienr);
        });
        label.addChild((MGuiElementBase)colourButton);
        return label;
    }

    public int addButtonElement(MGuiElementBase container, int yPos, int row, String local, Supplier<Boolean> getter, Consumer<Boolean> setter, boolean shiftDown) {
        GuiButton button = (GuiButton)new GuiButton(I18n.func_135052_a((String)("gui.netvistool.cfg." + local), (Object[])new Object[0])).setHoverText(I18n.func_135052_a((String)("gui.netvistool.cfg." + local + ".info"), (Object[])new Object[0]));
        button.setXSize((this.colourContaienr.xSize() - 4) / (row == -1 ? 1 : 2));
        button.setVanillaButtonRender(true);
        button.setToggleMode(true);
        button.setToggleStateSupplier(getter);
        button.setHoverTextDelay(10);
        button.setWrap(true);
        button.setListener(() -> {
            setter.accept(!button.getToggleState());
            this.sendConfigToServer();
        });
        int textHeight = this.field_146289_q.func_78267_b(button.getDisplayString(), button.xSize() - 6);
        button.setYSize(textHeight + 6);
        container.addChild((MGuiElementBase)button);
        button.setPos(container.xPos() + 2 + (row == -1 ? 0 : button.xSize() * row), yPos);
        return yPos + (shiftDown ? button.ySize() + 1 : 0);
    }

    private void sendConfigToServer() {
        PacketCustom packet = new PacketCustom((Object)"AE2NVChannel", 2);
        packet.writeEnum((Enum)this.hand);
        this.toolData.toBytes((MCDataOutput)packet);
        packet.compress();
        packet.sendToServer();
    }

    public void func_73876_c() {
        if (this.validate()) {
            super.func_73876_c();
        } else {
            this.field_146297_k.field_71439_g.func_71053_j();
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private boolean validate() {
        ItemStack heldStack = this.player.func_184586_b(this.hand);
        if (!ItemNetVisualizer.isValidTool(heldStack)) {
            return false;
        }
        String id = ItemNetVisualizer.getToolId(this.stack);
        if (!id.equals(this.toolData.id)) {
            return false;
        }
        ItemNetVisualizer.loadDataFromStack(heldStack, this.toolData);
        return true;
    }
}

