/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.recipe.CrystallizerRecipes;
import com.shinoow.abyssalcraft.api.recipe.Materialization;
import com.shinoow.abyssalcraft.api.recipe.MaterializerRecipes;
import com.shinoow.abyssalcraft.api.recipe.TransmutatorRecipes;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomicon;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonCategory;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonHome;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import com.shinoow.abyssalcraft.lib.NecronomiconText;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class GuiNecronomiconMachines
extends GuiNecronomicon {
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonNextPageLong;
    private ButtonNextPage buttonPreviousPage;
    private ButtonNextPage buttonPreviousPageLong;
    private GuiButton buttonDone;
    private ButtonHome buttonHome;
    private ButtonCategory info;
    private ButtonCategory transmutator;
    private ButtonCategory crystallizer;
    private ButtonCategory materializer;
    private boolean isMInfo;
    private boolean isTra;
    private boolean isCry;
    private boolean isMat;
    private GuiNecronomicon parent;

    public GuiNecronomiconMachines(int bookType, GuiNecronomicon parent) {
        super(bookType);
        this.parent = parent;
    }

    @Override
    public GuiNecronomicon withBookType(int par1) {
        if (par1 < 1) {
            this.isInvalid = true;
        }
        return super.withBookType(par1);
    }

    @Override
    public void func_73866_w_() {
        if (this.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
        }
        currentNecro = this;
        if (this.isCry && this.getBookType() == 1) {
            this.isMat = false;
            this.isCry = false;
            this.isTra = false;
            this.isMInfo = false;
            this.isInfo = false;
            this.currTurnup = 0;
        }
        if (this.isMat && this.getBookType() <= 2) {
            this.isMat = false;
            this.isCry = false;
            this.isTra = false;
            this.isMInfo = false;
            this.isInfo = false;
            this.currTurnup = 0;
        }
        if (this.isInfo) {
            this.drawButtons();
        } else {
            this.field_146292_n.clear();
            Keyboard.enableRepeatEvents((boolean)true);
            this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
            this.field_146292_n.add(this.buttonDone);
            int i = (this.field_146294_l - 255) / 2;
            int b0 = 2;
            this.buttonNextPage = new ButtonNextPage(1, i + 220, b0 + 154, true, false);
            this.field_146292_n.add(this.buttonNextPage);
            this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
            this.field_146292_n.add(this.buttonNextPageLong);
            this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
            this.field_146292_n.add(this.buttonPreviousPage);
            this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
            this.field_146292_n.add(this.buttonPreviousPageLong);
            this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
            this.field_146292_n.add(this.buttonHome);
            this.info = new ButtonCategory(6, i + 14, b0 + 24, this, NecronomiconText.LABEL_INFO, false, ACItems.necronomicon);
            this.field_146292_n.add(this.info);
            this.transmutator = new ButtonCategory(7, i + 14, b0 + 41, this, "container.abyssalcraft.transmutator", false, this.getItem(1));
            this.field_146292_n.add(this.transmutator);
            this.crystallizer = new ButtonCategory(8, i + 14, b0 + 58, this, "container.abyssalcraft.crystallizer", false, this.getItem(2));
            this.field_146292_n.add(this.crystallizer);
            this.materializer = new ButtonCategory(9, i + 14, b0 + 75, this, "container.abyssalcraft.materializer", false, this.getItem(3));
            this.field_146292_n.add(this.materializer);
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.getTurnupLimit() - 1 && this.isInfo;
        this.buttonNextPageLong.field_146125_m = this.currTurnup < this.getTurnupLimit() - 5;
        this.buttonPreviousPage.field_146125_m = true;
        this.buttonPreviousPageLong.field_146125_m = this.currTurnup > 4;
        this.buttonDone.field_146125_m = true;
        this.buttonHome.field_146125_m = true;
        this.info.field_146125_m = true;
        this.transmutator.field_146125_m = true;
        this.crystallizer.field_146125_m = true;
        this.materializer.field_146125_m = true;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.getTurnupLimit() - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currTurnup < this.getTurnupLimit() - 5) {
                    this.currTurnup += 5;
                }
            } else if (button.field_146127_k == 3) {
                if (this.currTurnup == 0 && !this.isInfo) {
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
                } else if (this.currTurnup == 0 && this.isInfo) {
                    this.isMat = false;
                    this.isCry = false;
                    this.isTra = false;
                    this.isMInfo = false;
                    this.isInfo = false;
                    this.func_73866_w_();
                    this.setTurnupLimit(2);
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 4) {
                if (this.currTurnup > 4) {
                    this.currTurnup -= 5;
                }
            } else if (button.field_146127_k == 5) {
                if (!this.isInfo) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomicon(this.getBookType()));
                } else {
                    this.currTurnup = 0;
                    this.isMat = false;
                    this.isCry = false;
                    this.isTra = false;
                    this.isMInfo = false;
                    this.isInfo = false;
                    this.func_73866_w_();
                    this.setTurnupLimit(2);
                }
            } else if (button.field_146127_k == 6) {
                this.isInfo = true;
                this.isMInfo = true;
                this.drawButtons();
            } else if (button.field_146127_k == 7 && this.getBookType() >= 1) {
                this.isInfo = true;
                this.isTra = true;
                this.drawButtons();
            } else if (button.field_146127_k == 8 && this.getBookType() >= 2) {
                this.isInfo = true;
                this.isCry = true;
                this.drawButtons();
            } else if (button.field_146127_k == 9 && this.getBookType() >= 3) {
                this.isInfo = true;
                this.isMat = true;
                this.drawButtons();
            }
            this.updateButtons();
        }
    }

    private void drawButtons() {
        this.field_146292_n.clear();
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
        this.field_146292_n.add(this.buttonNextPageLong);
        this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
        this.field_146292_n.add(this.buttonPreviousPageLong);
        this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
        this.field_146292_n.add(this.buttonHome);
    }

    @Override
    protected void drawIndexText() {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String stuff = this.localize(NecronomiconText.LABEL_INFORMATION_MACHINES);
        this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
        this.writeText(2, NecronomiconText.MACHINES_INFO);
    }

    private void setTurnups(int size) {
        this.setTurnups(size, false);
    }

    private void setTurnups(int size, boolean isMat) {
        int i = !isMat ? 2 : 1;
        this.setTurnupLimit((size + 6 * i) / (6 * i));
    }

    @Override
    protected void drawInformationText(int x, int y) {
        Map.Entry entry;
        int n;
        String stuff;
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.tooltipStack = null;
        if (this.isMInfo) {
            stuff = this.localize(NecronomiconText.LABEL_INFO);
            this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
            this.setTurnupLimit(2);
            if (this.currTurnup == 0) {
                this.writeText(1, NecronomiconText.MACHINE_INFO_1, 50);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                this.func_73729_b(k, b0, 0, 0, 256, 256);
                this.renderItem(k + 60, b0 + 28, new ItemStack(ACBlocks.transmutator_idle), x, y);
                this.writeText(2, NecronomiconText.MACHINE_INFO_2, 50);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                this.func_73729_b(k + 123, b0, 0, 0, 256, 256);
                this.renderItem(k + 183, b0 + 28, new ItemStack(ACBlocks.crystallizer_idle), x, y);
            } else if (this.currTurnup == 1) {
                this.writeText(1, NecronomiconText.MACHINE_INFO_3, 50);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                this.func_73729_b(k, b0, 0, 0, 256, 256);
                this.renderItem(k + 60, b0 + 28, new ItemStack(ACBlocks.engraver), x, y);
                this.writeText(2, NecronomiconText.MACHINE_INFO_4, 50);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.ITEM);
                this.func_73729_b(k + 123, b0, 0, 0, 256, 256);
                this.renderItem(k + 183, b0 + 28, new ItemStack(ACBlocks.materializer), x, y);
            }
        }
        if (this.isTra) {
            stuff = this.localize("container.abyssalcraft.transmutator");
            this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
            Map<ItemStack, ItemStack> trans = TransmutatorRecipes.instance().getTransmutationList();
            this.setTurnups(trans.size());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.TRANSMUTATION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
            for (n = 0; n < trans.size(); ++n) {
                entry = (Map.Entry)trans.entrySet().toArray()[n];
                this.drawTItems(entry, n, this.currTurnup * 12, this.currTurnup * 12 + 6, (this.currTurnup + 1) * 12, x, y);
            }
        }
        if (this.isCry) {
            stuff = this.localize("container.abyssalcraft.crystallizer");
            this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
            Map<ItemStack, ItemStack[]> cryst = CrystallizerRecipes.instance().getCrystallizationList();
            this.setTurnups(cryst.size());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.TRANSMUTATION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.CRYSTALLIZATION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
            for (n = 0; n < cryst.size(); ++n) {
                entry = (Map.Entry)cryst.entrySet().toArray()[n];
                this.drawCItems(entry, n, this.currTurnup * 12, this.currTurnup * 12 + 6, (this.currTurnup + 1) * 12, x, y);
            }
        }
        if (this.isMat) {
            stuff = this.localize("container.abyssalcraft.materializer");
            this.field_146289_q.func_78279_b(stuff, k + 20, b0 + 16, 116, 0xC40000);
            List<Materialization> mat = MaterializerRecipes.instance().getMaterializationList();
            this.setTurnups(mat.size(), true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.MATERIALIZATION);
            this.func_73729_b(k, b0, 0, 0, 256, 256);
            for (n = 0; n < mat.size(); ++n) {
                Materialization m = mat.get(n);
                if ((this.currTurnup + 1) * 6 <= n || n <= this.currTurnup * 6 - 1) continue;
                this.drawMItems(m, n, this.currTurnup * 6, 0, 0, x, y);
            }
        }
        this.renderTooltip(x, y);
    }

    private void drawTItems(Map.Entry<ItemStack, ItemStack> entry, int num, int low, int mid, int high, int x, int y) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(false);
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        if (num < mid && num > low - 1) {
            this.renderItem(k + 18, b0 + 28 + (num - low) * 20 + num - low, entry.getKey(), x, y);
            this.renderItem(k + 62, b0 + 28 + (num - low) * 20 + num - low, entry.getValue(), x, y);
        } else if (num > mid - 1 && num < high) {
            this.renderItem(k + 141, b0 + 28 + (num - mid) * 20 + num - mid, entry.getKey(), x, y);
            this.renderItem(k + 185, b0 + 28 + (num - mid) * 20 + num - mid, entry.getValue(), x, y);
        }
        this.field_146289_q.func_78264_a(unicode);
    }

    private void drawCItems(Map.Entry<ItemStack, ItemStack[]> entry, int num, int low, int mid, int high, int x, int y) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(false);
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        if (num < mid && num > low - 1) {
            this.renderItem(k + 18, b0 + 28 + (num - low) * 20 + num - low, entry.getKey(), x, y);
            this.renderItem(k + 62, b0 + 28 + (num - low) * 20 + num - low, entry.getValue()[0], x, y);
            this.renderItem(k + 62 + 33, b0 + 28 + (num - low) * 20 + num - low, entry.getValue()[1], x, y);
        } else if (num > mid - 1 && num < high) {
            this.renderItem(k + 141, b0 + 28 + (num - mid) * 20 + num - mid, entry.getKey(), x, y);
            this.renderItem(k + 185, b0 + 28 + (num - mid) * 20 + num - mid, entry.getValue()[0], x, y);
            this.renderItem(k + 185 + 34, b0 + 28 + (num - mid) * 20 + num - mid, entry.getValue()[1], x, y);
        }
        this.field_146289_q.func_78264_a(unicode);
    }

    private void drawMItems(Materialization mat, int num, int low, int mid, int high, int x, int y) {
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(false);
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.renderItem(k + 38, b0 + 28 + (num - low) * 20 + num - low, mat.input[0].func_77946_l(), x, y);
        if (mat.input.length >= 2) {
            this.renderItem(k + 59, b0 + 28 + (num - low) * 20 + num - low, mat.input[1].func_77946_l(), x, y);
        }
        if (mat.input.length >= 3) {
            this.renderItem(k + 59 + 21, b0 + 28 + (num - low) * 20 + num - low, mat.input[2].func_77946_l(), x, y);
        }
        if (mat.input.length >= 4) {
            this.renderItem(k + 145, b0 + 28 + (num - low) * 20 + num - low, mat.input[3].func_77946_l(), x, y);
        }
        if (mat.input.length == 5) {
            this.renderItem(k + 166, b0 + 28 + (num - low) * 20 + num - low, mat.input[4].func_77946_l(), x, y);
        }
        this.renderItem(k + 166 + 44, b0 + 28 + (num - low) * 20 + num - low, mat.output.func_77946_l(), x, y);
        this.field_146289_q.func_78264_a(unicode);
    }
}

