/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks;

import com.google.common.base.Predicate;
import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.common.blocks.BlockACBasic;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityStateTransformer;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.util.blocks.BlockUtil;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockStateTransformer
extends BlockACBasic {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool TABLET = PropertyBool.func_177716_a((String)"tablet");

    public BlockStateTransformer() {
        super(Material.field_151576_e, 2.0f, 4.0f, SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TABLET, (Comparable)Boolean.valueOf(false)));
        this.func_149663_c("statetransformer");
        this.func_149647_a(ACTabs.tabDecoration);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB((double)0.1f, 0.0, (double)0.1f, (double)0.9f, 0.75, (double)0.9f);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean b = false;
        TileEntity tile = BlockUtil.getTileEntitySafely(worldIn, pos);
        if (tile instanceof TileEntityStateTransformer) {
            b = !((TileEntityStateTransformer)tile).func_70301_a(0).func_190926_b();
        }
        return state.func_177226_a((IProperty)TABLET, (Comparable)Boolean.valueOf(b));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            IBlockState block = worldIn.func_180495_p(pos.func_177978_c());
            IBlockState block1 = worldIn.func_180495_p(pos.func_177968_d());
            IBlockState block2 = worldIn.func_180495_p(pos.func_177976_e());
            IBlockState block3 = worldIn.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_185913_b() && !block1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_185913_b() && !block.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_185913_b() && !block3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_185913_b() && !block2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityStateTransformer();
    }

    public void func_180633_a(World par1World, BlockPos pos, IBlockState state, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        par1World.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)par5EntityLivingBase.func_174811_aO().func_176734_d()), 2);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World par1World, BlockPos pos, IBlockState state, EntityPlayer par5EntityPlayer, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        if (!par1World.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)par5EntityPlayer, (Object)AbyssalCraft.instance, (int)39, (World)par1World, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180663_b(World par1World, BlockPos pos, IBlockState state) {
        TileEntityStateTransformer compressorThing = (TileEntityStateTransformer)par1World.func_175625_s(pos);
        if (compressorThing != null) {
            InventoryHelper.func_180175_a((World)par1World, (BlockPos)pos, (IInventory)compressorThing);
        }
        super.func_180663_b(par1World, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World par1World, BlockPos pos) {
        TileEntity tile = par1World.func_175625_s(pos);
        if (tile instanceof TileEntityStateTransformer) {
            TileEntityStateTransformer thing = (TileEntityStateTransformer)tile;
            if (thing.processingTime > 0) {
                return 0;
            }
            int i = 0;
            float f = 0.0f;
            for (int j = 1; j < thing.func_70302_i_(); ++j) {
                ItemStack itemstack = thing.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                f += (float)itemstack.func_190916_E() / (float)Math.min(thing.func_70297_j_(), itemstack.func_77976_d());
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= (float)thing.func_70302_i_()) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING}).add(new IProperty[]{TABLET}).build();
    }
}

