/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainer;
import com.shinoow.abyssalcraft.api.energy.IEnergyTransporter;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.common.blocks.BlockEnergyRelay;
import net.minecraft.block.properties.IProperty;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;

public class TileEntityEnergyRelay
extends TileEntity
implements IEnergyTransporter,
ITickable {
    private float energy;
    private int ticksExisted;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy = nbttagcompound.func_74760_g("PotEnergy");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74776_a("PotEnergy", this.energy);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_175730_i.remove(this);
        }
        this.ticksExisted = this.field_145850_b.field_73012_v.nextInt(100);
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        ++this.ticksExisted;
        if (this.ticksExisted % 20 == 0 && this.field_145850_b.func_180495_p(this.field_174879_c).func_177228_b().containsKey((Object)BlockEnergyRelay.FACING)) {
            PEUtils.collectNearbyPE(this, this.field_145850_b, this.field_174879_c, ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyRelay.FACING)).func_176734_d(), 5.0f);
        }
        if (this.ticksExisted % 40 == 0 && this.canTransferPE() && this.field_145850_b.func_180495_p(this.field_174879_c).func_177228_b().containsKey((Object)BlockEnergyRelay.FACING)) {
            this.transferPE((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockEnergyRelay.FACING), 10.0f);
        }
    }

    @Override
    public void transferPE(EnumFacing facing, float energy) {
        IEnergyContainer container;
        if (PEUtils.canTransfer(this.field_145850_b, this.field_174879_c, facing, 4) && (container = PEUtils.getContainer(this.field_145850_b, this.field_174879_c, facing, 4)) != null && container.canAcceptPE()) {
            container.addEnergy(this.consumeEnergy(energy));
            AbyssalCraftAPI.getInternalMethodHandler().spawnPEStream(this.field_174879_c, container.getContainerTile().func_174877_v(), this.field_145850_b.field_73011_w.getDimension());
        }
    }

    @Override
    public float getContainedEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return 500;
    }

    @Override
    public void addEnergy(float energy) {
        this.energy += energy;
        if (this.energy > (float)this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    @Override
    public float consumeEnergy(float energy) {
        if (energy < this.energy) {
            this.energy -= energy;
            return energy;
        }
        float ret = this.energy;
        this.energy = 0.0f;
        return ret;
    }

    @Override
    public boolean canAcceptPE() {
        return this.getContainedEnergy() < (float)this.getMaxEnergy();
    }

    @Override
    public boolean canTransferPE() {
        return this.getContainedEnergy() > 0.0f;
    }

    @Override
    public TileEntity getContainerTile() {
        return this;
    }
}

