/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.handlers;

import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.biome.IDarklandsBiome;
import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.entity.IAntiEntity;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.api.event.ACEvents;
import com.shinoow.abyssalcraft.api.event.FuelBurnTimeEvent;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.item.ItemUpgradeKit;
import com.shinoow.abyssalcraft.api.recipe.UpgradeKitRecipes;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconSummonRitual;
import com.shinoow.abyssalcraft.common.enchantments.EnchantmentWeaponInfusion;
import com.shinoow.abyssalcraft.common.entity.EntityChagaroth;
import com.shinoow.abyssalcraft.common.entity.EntityDragonBoss;
import com.shinoow.abyssalcraft.common.entity.EntityJzahar;
import com.shinoow.abyssalcraft.common.entity.EntitySacthoth;
import com.shinoow.abyssalcraft.common.entity.anti.EntityAntiPlayer;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonAnimal;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonChicken;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonCow;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonPig;
import com.shinoow.abyssalcraft.common.entity.demon.EntityDemonSheep;
import com.shinoow.abyssalcraft.common.entity.demon.EntityEvilAnimal;
import com.shinoow.abyssalcraft.common.entity.demon.EntityEvilSheep;
import com.shinoow.abyssalcraft.common.items.ItemCrystalBag;
import com.shinoow.abyssalcraft.common.items.ItemNecronomicon;
import com.shinoow.abyssalcraft.common.world.data.NecromancyWorldSavedData;
import com.shinoow.abyssalcraft.init.BlockHandler;
import com.shinoow.abyssalcraft.init.InitHandler;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.util.Scheduler;
import com.shinoow.abyssalcraft.lib.util.SpecialTextUtil;
import com.shinoow.abyssalcraft.lib.world.TeleporterDarkRealm;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class AbyssalCraftEventHooks {
    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Pre event) {
        Chunk chunk = event.getWorld().func_72964_e(event.getChunkX(), event.getChunkZ());
        for (ExtendedBlockStorage storage : chunk.func_76587_i()) {
            if (storage == null || storage.func_76662_d() < 60) continue;
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (chunk.func_177411_a(new BlockPos(x, y, z), event.getWorld().func_72959_q()) != ACBiomes.darklands_mountains || storage.func_177485_a(x, y, z).func_177230_c() != Blocks.field_150348_b) continue;
                        storage.func_177484_a(x, y, z, ACBlocks.stone.func_176223_P());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void armorStuff(LivingHurtEvent event) {
        if (!event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b()) {
            ItemStack slot = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
            if (slot.func_77973_b() == ACItems.dreaded_abyssalnite_chestplate && event.getSource().func_76346_g() != null && event.getEntityLiving().field_70170_p.field_73012_v.nextBoolean()) {
                event.getSource().func_76346_g().func_70015_d(5);
            }
            if (slot.func_77973_b() == ACItems.plated_coralium_chestplate && event.getSource().func_76346_g() != null && event.getEntityLiving().field_70170_p.field_73012_v.nextBoolean()) {
                event.getSource().func_76346_g().func_70097_a(this.getSource(event.getEntityLiving()), 1.0f);
            }
        }
        if (!(event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_190926_b())) {
            ItemStack head = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD);
            ItemStack chest = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack legs = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS);
            ItemStack feet = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET);
            if (head.func_77973_b() == ACItems.dreadium_samurai_helmet && chest.func_77973_b() == ACItems.dreadium_samurai_chestplate && legs.func_77973_b() == ACItems.dreadium_samurai_leggings && feet.func_77973_b() == ACItems.dreadium_samurai_boots && event.getSource() == AbyssalCraftAPI.dread) {
                event.setAmount(event.getAmount() * 0.5f);
            }
            if (head.func_77973_b() == ACItems.ethaxium_helmet && chest.func_77973_b() == ACItems.ethaxium_chestplate && legs.func_77973_b() == ACItems.ethaxium_leggings && feet.func_77973_b() == ACItems.ethaxium_boots && event.getSource() == AbyssalCraftAPI.acid) {
                event.setAmount(0.0f);
            }
        }
    }

    private DamageSource getSource(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            return DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)entity));
        }
        return DamageSource.func_76358_a((EntityLivingBase)entity);
    }

    @SubscribeEvent
    public void damageStuff(LivingAttackEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (EntityUtil.isEntityCoralium(entity) || EntityUtil.isEntityDread(entity) || entity instanceof IAntiEntity || entity.func_70668_bt() == AbyssalCraftAPI.SHADOW) {
            DamageSource source = event.getSource();
            if (EntityUtil.isEntityDread(entity) && (source.func_76346_g() instanceof EntityLivingBase && EntityUtil.isDreadPlagueCarrier((EntityLivingBase)source.func_76346_g()) || source == AbyssalCraftAPI.dread)) {
                event.setCanceled(true);
            }
            if (!(entity instanceof EntityPlayer) && EntityUtil.isEntityCoralium(entity) && (source.func_76346_g() instanceof EntityLivingBase && EntityUtil.isCoraliumPlagueCarrier((EntityLivingBase)source.func_76346_g()) || source == AbyssalCraftAPI.coralium)) {
                event.setCanceled(true);
            }
            if (entity instanceof IAntiEntity && (source.func_76346_g() instanceof IAntiEntity || source == AbyssalCraftAPI.antimatter)) {
                event.setCanceled(true);
            }
            if (entity.func_70668_bt() == AbyssalCraftAPI.SHADOW && (source.func_76346_g() instanceof EntityLivingBase && ((EntityLivingBase)source.func_76346_g()).func_70668_bt() == AbyssalCraftAPI.SHADOW || source == AbyssalCraftAPI.shadow)) {
                event.setCanceled(true);
            }
            if (entity instanceof IOmotholEntity && (source.func_76346_g() instanceof IOmotholEntity || source == AbyssalCraftAPI.dread || source == AbyssalCraftAPI.coralium || source == AbyssalCraftAPI.antimatter || source == AbyssalCraftAPI.acid)) {
                event.setCanceled(true);
            }
            if (entity instanceof EntityPlayer && EntityUtil.isEntityCoralium(entity) && source == AbyssalCraftAPI.coralium) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void darkRealm(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            WorldServer worldServer = (WorldServer)event.getEntityLiving().field_70170_p;
            EntityPlayerMP player = (EntityPlayerMP)event.getEntityLiving();
            if (player.field_71093_bK == ACLib.omothol_id && player.field_70163_u <= 0.0) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 80, 255));
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 20));
                player.field_71133_b.func_184103_al().transferPlayerToDimension(player, ACLib.dark_realm_id, (Teleporter)new TeleporterDarkRealm(worldServer));
            }
        }
        if (event.getEntityLiving().field_71093_bK == ACLib.dark_realm_id && !(event.getEntityLiving() instanceof EntityPlayer) && event.getEntityLiving().func_70668_bt() != AbyssalCraftAPI.SHADOW) {
            Random rand = new Random();
            if (ACConfig.particleEntity) {
                event.getEntityLiving().field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, event.getEntityLiving().field_70165_t + (rand.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, event.getEntityLiving().field_70163_u + rand.nextDouble() * (double)event.getEntityLiving().field_70131_O, event.getEntityLiving().field_70161_v + (rand.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SubscribeEvent
    public void onCraftingEvent(PlayerEvent.ItemCraftedEvent event) {
        for (int h = 0; h < event.craftMatrix.func_70302_i_(); ++h) {
            NBTTagCompound compound;
            if (event.craftMatrix.func_70301_a(h) == null) continue;
            ItemStack k = event.craftMatrix.func_70301_a(h);
            if (k.func_77973_b() != null && k.func_77973_b() instanceof ItemCrystalBag) {
                compound = new NBTTagCompound();
                NBTTagList items = new NBTTagList();
                if (k.func_77978_p() == null) {
                    k.func_77982_d(compound);
                }
                items = k.func_77978_p().func_150295_c("ItemInventory", 10);
                ItemStack l = event.crafting;
                if (!(l.func_77973_b() instanceof ItemCrystalBag)) continue;
                ((ItemCrystalBag)l.func_77973_b()).setInventorySize(l);
                if (l.func_77978_p() == null) {
                    l.func_77982_d(compound);
                }
                l.func_77978_p().func_74782_a("ItemInventory", (NBTBase)items);
                continue;
            }
            if (k.func_77973_b() == null || !(k.func_77973_b() instanceof ItemNecronomicon)) continue;
            compound = new NBTTagCompound();
            String owner = "";
            float energy = 0.0f;
            if (k.func_77978_p() == null) {
                k.func_77982_d(compound);
            }
            owner = k.func_77978_p().func_74779_i("owner");
            energy = k.func_77978_p().func_74760_g("PotEnergy");
            ItemStack l = event.crafting;
            if (!(l.func_77973_b() instanceof ItemNecronomicon)) continue;
            if (l.func_77978_p() == null) {
                l.func_77982_d(compound);
            }
            if (!owner.equals("")) {
                l.func_77978_p().func_74778_a("owner", owner);
            }
            if (energy == 0.0f) continue;
            l.func_77978_p().func_74776_a("PotEnergy", energy);
        }
    }

    @SubscribeEvent
    public void noTPinOmothol(EnderTeleportEvent event) {
        if (!(event.getEntityLiving() instanceof EntityJzahar) && event.getEntityLiving().field_71093_bK == ACLib.omothol_id) {
            event.getEntityLiving().func_70097_a(DamageSource.field_76379_h, event.getAttackDamage());
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 1));
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 1));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void darklandsVillages(BiomeEvent.GetVillageBlockID event) {
        if (event.getBiome() instanceof IDarklandsBiome) {
            if (event.getOriginal().func_177230_c() == Blocks.field_150364_r || event.getOriginal().func_177230_c() == Blocks.field_150363_s) {
                event.setReplacement(ACBlocks.darklands_oak_wood.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150347_e) {
                event.setReplacement(ACBlocks.cobblestone.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150344_f) {
                event.setReplacement(ACBlocks.darklands_oak_planks.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150476_ad && ACConfig.darklands_oak_stairs) {
                event.setReplacement(ACBlocks.darklands_oak_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, event.getOriginal().func_177229_b((IProperty)BlockStairs.field_176309_a)));
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150446_ar && ACConfig.darkstone_cobblestone_stairs) {
                event.setReplacement(ACBlocks.darkstone_cobblestone_stairs.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, event.getOriginal().func_177229_b((IProperty)BlockStairs.field_176309_a)));
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_180407_aO) {
                event.setReplacement(ACBlocks.darklands_oak_fence.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150333_U && ACConfig.darkstone_slab) {
                event.setReplacement(ACBlocks.darkstone_slab.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150334_T && ACConfig.darkstone_slab) {
                event.setReplacement(BlockHandler.Darkstoneslab2.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
            if (event.getOriginal().func_177230_c() == Blocks.field_150452_aw) {
                event.setReplacement(ACBlocks.darklands_oak_pressure_plate.func_176223_P());
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onRitualPerformed(ACEvents.RitualEvent.Post event) {
        if (event.getRitual() instanceof NecronomiconSummonRitual && ACConfig.showBossDialogs) {
            if (event.getRitual().getUnlocalizedName().substring(10).equals("summonSacthoth") && !event.getWorld().field_72995_K) {
                SpecialTextUtil.SacthothGroup(event.getWorld(), I18n.func_74838_a((String)"message.sacthoth.spawn.1"));
            }
            if (event.getRitual().getUnlocalizedName().substring(10).equals("summonAsorah") && !event.getWorld().field_72995_K) {
                SpecialTextUtil.AsorahGroup(event.getWorld(), I18n.func_74838_a((String)"message.asorah.spawn"));
            }
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase e;
        if (event.getEntityLiving() instanceof EntityPlayer && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (event.getSource().func_76346_g() instanceof EntityEvilSheep) {
                ((EntityEvilSheep)event.getSource().func_76346_g()).setKilledPlayer(player);
            } else if (event.getSource().func_76346_g() instanceof EntityAntiPlayer && player.func_70681_au().nextBoolean()) {
                EntityAntiPlayer antiPlayer = new EntityAntiPlayer(player.field_70170_p);
                antiPlayer.func_82149_j((Entity)player);
                antiPlayer.func_180482_a(player.field_70170_p.func_175649_E(event.getSource().func_76346_g().func_180425_c()), null);
                antiPlayer.func_96094_a(this.invert(player.func_70005_c_()));
                antiPlayer.func_110163_bv();
                player.field_70170_p.func_72838_d((Entity)antiPlayer);
                player.field_70170_p.func_180498_a((EntityPlayer)null, 1016, event.getSource().func_76346_g().func_180425_c(), 0);
            }
        } else if (event.getEntityLiving() instanceof EntityLiving && event.getEntityLiving().func_145818_k_() && event.getEntityLiving().func_184222_aU() && !event.getEntityLiving().field_70170_p.field_72995_K) {
            EntityLivingBase e2 = event.getEntityLiving();
            NecromancyWorldSavedData.get(e2.field_70170_p).storeData(e2.func_70005_c_(), e2.serializeNBT(), this.calculateSize(e2.field_70131_O));
        } else if (EntityList.func_191301_a((Entity)event.getEntityLiving()) != null && !((e = event.getEntityLiving()) instanceof EntityEvilAnimal) && !(e instanceof EntityDemonAnimal)) {
            Tuple<Integer, Float> data = InitHandler.demon_transformations.get(EntityList.func_191301_a((Entity)e));
            World world = event.getEntityLiving().field_70170_p;
            if (data != null && world.field_73012_v.nextFloat() < ((Float)data.func_76340_b()).floatValue() && !world.field_72995_K) {
                EntityLiving demon = this.getDemon((Integer)data.func_76341_a(), world);
                demon.func_82149_j((Entity)e);
                world.func_72900_e((Entity)e);
                demon.func_180482_a(world.func_175649_E(e.func_180425_c()), (IEntityLivingData)null);
                world.func_72838_d((Entity)demon);
            }
        }
    }

    private int calculateSize(float height) {
        if (height >= 1.5f) {
            return 2;
        }
        if (height >= 0.75f) {
            return 1;
        }
        return 0;
    }

    private EntityLiving getDemon(int num, World world) {
        switch (num) {
            case 0: {
                return new EntityDemonPig(world);
            }
            case 1: {
                return new EntityDemonCow(world);
            }
            case 2: {
                return new EntityDemonChicken(world);
            }
            case 3: {
                return new EntityDemonSheep(world);
            }
        }
        return new EntityDemonPig(world);
    }

    private String invert(String name) {
        String newname = "";
        int length = name.length();
        boolean[] cases = new boolean[length];
        for (int j = 0; j < length; ++j) {
            cases[j] = Character.isUpperCase(name.charAt(j));
        }
        for (int i = length - 1; i >= 0; --i) {
            char c = name.charAt(i);
            int k = length - 1 - i;
            newname = newname + (cases[k] ? Character.toUpperCase(c) : Character.toLowerCase(c));
        }
        return newname;
    }

    @SubscribeEvent
    public void upgradeKits(AnvilUpdateEvent event) {
        if (!(event.getRight().func_77973_b() instanceof ItemUpgradeKit)) {
            if (event.getRight().func_77973_b() == Items.field_151134_bR) {
                for (Enchantment ench : EnchantmentHelper.func_82781_a((ItemStack)event.getRight()).keySet()) {
                    if (!(ench instanceof EnchantmentWeaponInfusion)) continue;
                    event.setCanceled(true);
                    return;
                }
            }
            return;
        }
        if (ACConfig.upgrade_kits) {
            ItemStack stack;
            ItemStack input = event.getLeft();
            int cost = 0;
            float f = (float)(input.func_77958_k() - input.func_77952_i()) / (float)input.func_77958_k();
            if (f >= 0.0f) {
                cost = 10;
            }
            if (f >= 0.1f) {
                cost = 9;
            }
            if (f >= 0.2f) {
                cost = 8;
            }
            if (f >= 0.3f) {
                cost = 7;
            }
            if (f >= 0.4f) {
                cost = 6;
            }
            if (f >= 0.5f) {
                cost = 5;
            }
            if (f >= 0.6f) {
                cost = 4;
            }
            if (f >= 0.7f) {
                cost = 3;
            }
            if (f >= 0.8f) {
                cost = 2;
            }
            if (f >= 0.9f) {
                cost = 1;
            }
            if (!(stack = UpgradeKitRecipes.instance().getUpgrade((ItemUpgradeKit)event.getRight().func_77973_b(), input)).func_190926_b()) {
                if (StringUtils.func_151246_b((String)event.getName())) {
                    if (input.func_82837_s()) {
                        ++cost;
                        stack.func_135074_t();
                    }
                } else if (!event.getName().equals(input.func_82833_r())) {
                    ++cost;
                    stack.func_151001_c(event.getName());
                }
                Iterator iterator = EnchantmentHelper.func_82781_a((ItemStack)input).values().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    cost += i;
                }
                EnchantmentHelper.func_82782_a((Map)EnchantmentHelper.func_82781_a((ItemStack)input), (ItemStack)stack);
                stack.func_190920_e(input.func_190916_E());
                NBTTagCompound temp = input.serializeNBT();
                if (temp.func_74764_b("ForgeCaps")) {
                    NBTTagCompound temp1 = stack.serializeNBT();
                    temp1.func_74782_a("ForgeCaps", temp.func_74781_a("ForgeCaps"));
                    stack = new ItemStack(temp1);
                }
                event.setOutput(stack);
            }
            event.setMaterialCost(1);
            event.setCost(cost == 0 ? 1 : cost);
        }
    }

    @SubscribeEvent
    public void onUseHoe(UseHoeEvent event) {
        Block b = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (b == ACBlocks.dreadlands_grass || b == ACBlocks.dreadlands_dirt) {
            event.getWorld().func_184133_a(event.getEntityPlayer(), event.getPos(), SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_175656_a(event.getPos(), Blocks.field_150458_ak.func_176223_P());
            }
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void nameTags(PlayerInteractEvent.EntityInteract event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(event.getHand());
        if (stack.func_77973_b() == Items.field_151057_cb && stack.func_82837_s() && event.getTarget() instanceof IAntiEntity) {
            EntityLiving target = (EntityLiving)event.getTarget();
            target.func_96094_a(this.invert(stack.func_82833_r()));
            target.func_110163_bv();
            if (!event.getEntityPlayer().field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityDragonBoss || event.getEntityLiving() instanceof EntityChagaroth || event.getEntityLiving() instanceof EntityJzahar || event.getEntityLiving() instanceof EntitySacthoth) {
            EntityLivingBase entity = event.getEntityLiving();
            event.getDrops().add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, new ItemStack(ACItems.scroll, 1, 3)));
        }
    }

    @SubscribeEvent
    public void fuelBurnTime(FuelBurnTimeEvent event) {
        if (!ACConfig.crystal_rework) {
            ItemStack fuel = event.getItemStack();
            if (fuel.func_77973_b() == Item.func_150898_a((Block)ACBlocks.crystal_cluster) || fuel.func_77973_b() == Item.func_150898_a((Block)ACBlocks.crystal_cluster2)) {
                event.setBurnTime(12150);
            }
            if (fuel.func_77973_b() == ACItems.crystal) {
                event.setBurnTime(1350);
            }
            if (fuel.func_77973_b() == ACItems.crystal_shard) {
                event.setBurnTime(150);
            }
            if (fuel.func_77973_b() == ACItems.crystal_fragment) {
                event.setBurnTime(17);
            }
            if (APIUtils.isCrystal(fuel)) {
                event.setBurnTime(1000);
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        if (event.side == Side.SERVER && event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.START) {
            Scheduler.tick();
        }
    }
}

