/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.items;

import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.spell.IScroll;
import com.shinoow.abyssalcraft.api.spell.Spell;
import com.shinoow.abyssalcraft.api.spell.SpellEnum;
import com.shinoow.abyssalcraft.api.spell.SpellRegistry;
import com.shinoow.abyssalcraft.api.spell.SpellUtils;
import com.shinoow.abyssalcraft.lib.ACTabs;
import com.shinoow.abyssalcraft.lib.item.ItemMetadata;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemScroll
extends ItemMetadata
implements IScroll {
    public ItemScroll(String name, String ... names) {
        super(name, names);
        if (name.equals("scroll")) {
            this.func_185043_a(new ResourceLocation("inscribed"), (stack, worldIn, entityIn) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("Spell") ? 1.0f : 0.0f);
        }
    }

    public int func_77626_a(ItemStack stack) {
        Spell spell = SpellUtils.getSpell(stack);
        return spell != null ? (spell.requiresCharging() ? 50 : 0) : 0;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            SpellUtils.castChargingSpell(stack, worldIn, (EntityPlayer)entityLiving);
        }
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        SpellUtils.castInstantSpell(stack, worldIn, playerIn, handIn);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public SpellEnum.ScrollType getScrollType(ItemStack stack) {
        if (stack.func_77973_b() == ACItems.scroll) {
            switch (stack.func_77960_j()) {
                case 1: {
                    return SpellEnum.ScrollType.LESSER;
                }
                case 2: {
                    return SpellEnum.ScrollType.MODERATE;
                }
                case 3: {
                    return SpellEnum.ScrollType.GREATER;
                }
            }
        }
        if (stack.func_77973_b() == ACItems.unique_scroll) {
            return SpellEnum.ScrollType.UNIQUE;
        }
        return SpellEnum.ScrollType.BASIC;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTab, NonNullList<ItemStack> par3List) {
        super.func_150895_a(par2CreativeTab, par3List);
        if (this == ACItems.scroll && par2CreativeTab == ACTabs.tabSpells) {
            ItemStack greater_scroll = new ItemStack(ACItems.scroll, 1, 3);
            ItemStack antimatter_scroll = new ItemStack(ACItems.unique_scroll, 1, 0);
            ItemStack oblivion_scroll = new ItemStack(ACItems.unique_scroll, 1, 1);
            SpellRegistry.instance().getSpells().stream().forEach(s -> {
                par3List.add((Object)SpellRegistry.instance().inscribeSpell((Spell)s, greater_scroll.func_77946_l()));
                par3List.add((Object)SpellRegistry.instance().inscribeSpell((Spell)s, antimatter_scroll.func_77946_l()));
                par3List.add((Object)SpellRegistry.instance().inscribeSpell((Spell)s, oblivion_scroll.func_77946_l()));
            });
        }
    }
}

