/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.network.server;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class ConfiguratorMessage
extends AbstractMessage.AbstractServerMessage<ConfiguratorMessage> {
    private int mode1;
    private int mode2;
    private boolean openFilter;
    private boolean clearPath;

    public ConfiguratorMessage() {
    }

    public ConfiguratorMessage(int mode1, int mode2) {
        this.mode1 = mode1;
        this.mode2 = mode2;
        this.openFilter = false;
        this.clearPath = false;
    }

    public ConfiguratorMessage(boolean openFilter) {
        this.openFilter = openFilter;
        this.clearPath = false;
        this.mode1 = -1;
        this.mode2 = -1;
    }

    public ConfiguratorMessage(boolean clearPath, int n) {
        this.clearPath = clearPath;
        this.openFilter = false;
        this.mode1 = -1;
        this.mode2 = -1;
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.mode1 = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.mode2 = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.openFilter = buffer.readBoolean();
        this.clearPath = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.mode1, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.mode2, (int)5);
        buffer.writeBoolean(this.openFilter);
        buffer.writeBoolean(this.clearPath);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (this.clearPath) {
            ItemStack mainStack = player.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack offStack = player.func_184586_b(EnumHand.OFF_HAND);
            if (!mainStack.func_190926_b() && mainStack.func_77973_b() == ACItems.configurator) {
                if (!mainStack.func_77942_o()) {
                    mainStack.func_77982_d(new NBTTagCompound());
                }
                mainStack.func_77978_p().func_82580_o("Path");
            }
            if (!offStack.func_190926_b() && offStack.func_77973_b() == ACItems.configurator) {
                if (!offStack.func_77942_o()) {
                    offStack.func_77982_d(new NBTTagCompound());
                }
                offStack.func_77978_p().func_82580_o("Path");
            }
        } else if (this.openFilter) {
            player.openGui((Object)AbyssalCraft.instance, 41, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            ItemStack mainStack = player.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack offStack = player.func_184586_b(EnumHand.OFF_HAND);
            if (!mainStack.func_190926_b() && mainStack.func_77973_b() == ACItems.configurator && this.mode1 > -1) {
                if (!mainStack.func_77942_o()) {
                    mainStack.func_77982_d(new NBTTagCompound());
                }
                mainStack.func_77978_p().func_74768_a("Mode", this.mode1);
            }
            if (!offStack.func_190926_b() && offStack.func_77973_b() == ACItems.configurator && this.mode2 > -1) {
                if (!offStack.func_77942_o()) {
                    offStack.func_77982_d(new NBTTagCompound());
                }
                offStack.func_77978_p().func_74768_a("Mode", this.mode2);
            }
        }
    }
}

