/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.Set;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.util.ToolHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class AEOCrawlerTask {
    final World world;
    final EntityPlayer player;
    final ItemStack stack;
    final int steps;
    final BlockPos origin;
    final boolean leaves;
    final boolean force;
    final Set<BlockPos> posChecked;

    AEOCrawlerTask(World world, EntityPlayer player, ItemStack stack, BlockPos origin, int steps, boolean leaves, boolean force, Set<BlockPos> posChecked) {
        this.world = world;
        this.player = player;
        this.stack = stack;
        this.origin = origin;
        this.steps = steps;
        this.leaves = leaves;
        this.force = force;
        this.posChecked = posChecked;
    }

    void tick() {
        IBlockState originState = this.world.func_180495_p(this.origin);
        Block originBlock = originState.func_177230_c();
        if (!this.force && originBlock.isAir(originState, (IBlockAccess)this.world, this.origin)) {
            return;
        }
        ToolHelper.removeBlockWithDrops(this.player, this.stack, this.world, this.origin, null, ToolHelper.materialsAxe);
        if (this.steps == 0) {
            return;
        }
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos stepPos = this.origin.func_177972_a(dir);
            if (this.posChecked.contains(stepPos)) continue;
            IBlockState stepState = this.world.func_180495_p(stepPos);
            Block stepBlock = stepState.func_177230_c();
            boolean log = stepBlock.isWood((IBlockAccess)this.world, stepPos);
            boolean leaf = stepBlock.isLeaves(stepState, (IBlockAccess)this.world, stepPos);
            if (!log && !leaf) continue;
            int steps = this.steps - 1;
            steps = leaf ? (this.leaves ? steps : 3) : steps;
            AvaritiaEventHandler.startCrawlerTask(this.world, this.player, this.stack, stepPos, steps, leaf, false, this.posChecked);
            this.posChecked.add(stepPos);
        }
    }
}

