/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import wanion.biggercraftingtables.block.TileEntityAutoBiggerCraftingTable;
import wanion.lib.common.IGhostAcceptorContainer;
import wanion.lib.common.IShapedContainer;
import wanion.lib.common.ISlotCreator;
import wanion.lib.common.WContainer;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public abstract class ContainerAutoBiggerCraftingTable<T extends TileEntityAutoBiggerCraftingTable<?>>
extends WContainer<T>
implements IShapedContainer,
IGhostAcceptorContainer {
    private final TileEntityAutoBiggerCraftingTable<?> tileEntityAutoBiggerCraftingTable;
    private final int playerInventoryEnds;
    private final int playerInventoryStarts;
    private final int inventoryFull;
    private final int shapeEnds;
    private final int result;

    public ContainerAutoBiggerCraftingTable(@Nonnull ISlotCreator slotCreator, @Nonnull T tileEntityAutoBiggerCraftingTable) {
        super(tileEntityAutoBiggerCraftingTable);
        int inventorySize;
        this.tileEntityAutoBiggerCraftingTable = tileEntityAutoBiggerCraftingTable;
        ArrayList slotList = new ArrayList();
        slotCreator.create(slotList);
        slotList.forEach(arg_0 -> ((ContainerAutoBiggerCraftingTable)this).func_75146_a(arg_0));
        this.playerInventoryEnds = inventorySize = this.field_75151_b.size();
        this.playerInventoryStarts = inventorySize - 36;
        this.inventoryFull = (this.playerInventoryStarts - 2) / 2;
        this.shapeEnds = this.inventoryFull * 2;
        this.result = this.shapeEnds + 1;
    }

    @Nonnull
    public final ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slot) {
        ItemStack itemstack = null;
        Slot actualSlot = (Slot)this.field_75151_b.get(slot);
        if (actualSlot != null && actualSlot.func_75216_d()) {
            ItemStack itemstack1 = actualSlot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (slot >= this.playerInventoryStarts ? !this.func_75135_a(itemstack1, 0, this.inventoryFull, false) : (slot <= this.inventoryFull || slot == this.result) && !this.func_75135_a(itemstack1, this.playerInventoryStarts, this.playerInventoryEnds, true)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190916_E() == 0) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            }
            actualSlot.func_75218_e();
        }
        return itemstack != null ? itemstack : ItemStack.field_190927_a;
    }

    @Nonnull
    public final ItemStack func_184996_a(int slot, int mouseButton, @Nonnull ClickType clickType, @Nonnull EntityPlayer entityPlayer) {
        if (slot >= this.inventoryFull && slot < this.shapeEnds) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            if (clickType == ClickType.QUICK_MOVE) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else if (clickType == ClickType.PICKUP) {
                ItemStack playerStack = entityPlayer.field_71071_by.func_70445_o();
                boolean slotHasStack = actualSlot.func_75216_d();
                if (!playerStack.func_190926_b() && !slotHasStack) {
                    ItemStack newSlotStack = playerStack.func_77946_l();
                    newSlotStack.func_190920_e(1);
                    actualSlot.func_75215_d(newSlotStack);
                } else if (playerStack.func_190926_b() && slotHasStack || !playerStack.func_190926_b() && playerStack.func_77969_a(actualSlot.func_75211_c())) {
                    actualSlot.func_75215_d(ItemStack.field_190927_a);
                }
            }
            this.tileEntityAutoBiggerCraftingTable.recipeShapeChanged();
            return ItemStack.field_190927_a;
        }
        if (slot == this.shapeEnds) {
            if (((Slot)this.field_75151_b.get(slot)).func_75216_d()) {
                this.clearShape(this.tileEntityAutoBiggerCraftingTable.half, this.tileEntityAutoBiggerCraftingTable.full);
                this.tileEntityAutoBiggerCraftingTable.recipeShapeChanged();
            }
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slot, mouseButton, clickType, entityPlayer);
    }

    public final void defineShape(short key, @Nonnull ItemStack output) {
        IAdvancedRecipe advancedRecipe = this.tileEntityAutoBiggerCraftingTable.getRecipeRegistry().findRecipeByKeyAndOutput(key, output);
        if (advancedRecipe == null) {
            return;
        }
        int slotCount = this.field_75151_b.size();
        int startsIn = (slotCount - 36) / 2 - 1;
        int endsIn = slotCount - 38;
        int root = (int)Math.sqrt(endsIn - startsIn + 1);
        this.clearShape(startsIn, endsIn);
        List inputs = advancedRecipe.getInputs();
        if (advancedRecipe.isShaped()) {
            int i = 0;
            for (int y = 0; y < root; ++y) {
                for (int x = 0; x < root; ++x) {
                    ItemStack stackInput;
                    if (i >= inputs.size() || x >= advancedRecipe.getWidth() || y >= advancedRecipe.getHeight()) continue;
                    Slot slot = (Slot)this.field_75151_b.get(startsIn + (x + root * y));
                    if ((stackInput = ContainerAutoBiggerCraftingTable.getStackInput(inputs.get(i++))) == null) continue;
                    slot.func_75215_d(stackInput);
                }
            }
        } else {
            for (int i = 0; i < inputs.size() && i < root * root; ++i) {
                Slot slot = (Slot)this.field_75151_b.get(startsIn + i);
                ItemStack stackInput = ContainerAutoBiggerCraftingTable.getStackInput(inputs.get(i));
                if (stackInput == null) continue;
                slot.func_75215_d(stackInput);
            }
        }
        this.tileEntityAutoBiggerCraftingTable.recipeShapeChanged();
        this.func_75142_b();
    }

    public void clearShape() {
        int slotCount = this.field_75151_b.size();
        int startsIn = (slotCount - 36) / 2 - 1;
        int endsIn = slotCount - 38;
        this.clearShape(startsIn, endsIn);
    }

    private void clearShape(int startsIn, int endsIn) {
        for (int i = startsIn; i < endsIn; ++i) {
            ((Slot)this.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void acceptGhostStack(int slot, @Nonnull ItemStack itemStack) {
        if (slot >= this.inventoryFull && slot < this.shapeEnds) {
            Slot actualSlot = (Slot)this.field_75151_b.get(slot);
            if (itemStack.func_77969_a(actualSlot.func_75211_c())) {
                actualSlot.func_75215_d(ItemStack.field_190927_a);
            } else {
                actualSlot.func_75215_d(itemStack);
            }
            this.tileEntityAutoBiggerCraftingTable.recipeShapeChanged();
            this.func_75142_b();
        }
    }

    private static ItemStack getStackInput(Object input) {
        return input instanceof ItemStack ? ((ItemStack)input).func_77946_l() : (input instanceof List ? ((ItemStack)((List)input).get(0)).func_77946_l() : null);
    }
}

