/*
 * Decompiled with CFR 0.152.
 */
package wanion.biggercraftingtables.compat.jei.giant;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import wanion.biggercraftingtables.compat.jei.BiggerRecipeWrapper;
import wanion.lib.recipe.advanced.IAdvancedRecipe;

public final class GiantRecipeCategory
implements IRecipeCategory<BiggerRecipeWrapper> {
    private final ICraftingGridHelper craftingGridHelper;
    private final int size;
    private final IDrawable texture;
    private final String localizedName;

    public GiantRecipeCategory(IGuiHelper guiHelper) {
        this.size = 81;
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(0, 81);
        this.localizedName = I18n.func_135052_a((String)"crafting.giant", (Object[])new Object[0]);
        this.texture = guiHelper.createDrawable(new ResourceLocation("biggercraftingtables", "textures/gui/giant_recipe_jei.png"), 0, 0, 172, 198);
    }

    @Nonnull
    public String getUid() {
        return "biggerct.giant";
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public String getModName() {
        return "Bigger Crafting Tables";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.texture;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull BiggerRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeLayout.setRecipeTransferButton(159, 185);
        IGuiItemStackGroup guiItemStackGroup = recipeLayout.getItemStacks();
        guiItemStackGroup.init(this.size, false, 72, 176);
        IAdvancedRecipe advancedRecipe = recipeWrapper.advancedRecipe;
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        for (int y = 0; y < 9; ++y) {
            for (int x = 0; x < 9; ++x) {
                guiItemStackGroup.init(x + 9 * y, true, 18 * x, 18 * y);
            }
        }
        NonNullList newInputs = NonNullList.func_191197_a((int)81, Collections.emptyList());
        if (advancedRecipe.isShaped()) {
            for (int y = 0; y < advancedRecipe.getHeight(); ++y) {
                for (int x = 0; x < advancedRecipe.getWidth(); ++x) {
                    newInputs.set(x + 9 * y, inputs.get(x + advancedRecipe.getWidth() * y));
                }
            }
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStackGroup, (List)newInputs, 9, 9);
        } else {
            for (int i = 0; i < inputs.size(); ++i) {
                newInputs.set(i, inputs.get(i));
            }
            this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStackGroup, (List)newInputs, 9, 9);
            recipeLayout.setShapeless();
        }
        guiItemStackGroup.set(this.size, (List)outputs.get(0));
    }
}

