/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript.script;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.superckl.api.superscript.script.ParameterType;
import me.superckl.api.superscript.script.ParameterWrapper;
import me.superckl.api.superscript.script.ParameterWrapperStringArray;
import me.superckl.api.superscript.script.ScriptHandler;
import me.superckl.api.superscript.script.ScriptParser;
import me.superckl.api.superscript.util.CollectionHelper;
import me.superckl.api.superscript.util.WarningHelper;

public final class ParameterTypes {
    private static final Map<Class<?>, ParameterType<?>> defaultTypes = new HashMap();
    private static final Map<String, ParameterWrapper<?>> exceptionTypes = new HashMap();
    public static final ParameterType<JsonPrimitive> JSON_PRIMITIVE = new ParameterType<JsonPrimitive>(JsonPrimitive.class){

        @Override
        public JsonPrimitive tryParse(String parameter, ScriptHandler handler) {
            return new JsonPrimitive(parameter);
        }
    };
    public static final ParameterType<Byte> NON_NEG_BYTE = new ParameterType<Byte>(Byte.class){

        @Override
        public Byte tryParse(String parameter, ScriptHandler handler) throws Exception {
            Integer i = (Integer)NON_NEG_INTEGER.tryParse(parameter, handler);
            return i == null || i > 127 || i < -128 ? null : Byte.valueOf(i.byteValue());
        }
    };
    public static final ParameterType<Byte> BYTE = new ParameterType<Byte>(Byte.class){

        @Override
        public Byte tryParse(String parameter, ScriptHandler handler) throws Exception {
            Integer i = (Integer)INTEGER.tryParse(parameter, handler);
            return i == null || i > 127 || i < -128 ? null : Byte.valueOf(i.byteValue());
        }
    };
    public static final ParameterType<Float> FLOAT = new ParameterType<Float>(Float.class){

        @Override
        public Float tryParse(String parameter, ScriptHandler handler) {
            return Floats.tryParse((String)parameter);
        }
    };
    public static final ParameterType<int[]> NON_NEG_INTEGERS = new ParameterType<int[]>(int[].class){

        @Override
        public int[] tryParse(String parameter, ScriptHandler handler) throws Exception {
            int[] ints = (int[])WarningHelper.uncheckedCast(INTEGERS.tryParse(parameter, handler));
            ArrayList newInts = new ArrayList();
            Arrays.stream(ints).forEach(i -> newInts.add(i));
            Iterator it = newInts.iterator();
            while (it.hasNext()) {
                if ((Integer)it.next() >= 0) continue;
                it.remove();
            }
            return newInts.stream().mapToInt(i -> i).toArray();
        }
    };
    public static final ParameterType<Integer> NON_NEG_INTEGER = new ParameterType<Integer>(Integer.class){

        @Override
        public Integer tryParse(String parameter, ScriptHandler handler) {
            Integer i = Ints.tryParse((String)parameter);
            if (i != null && i >= 0) {
                return i;
            }
            return null;
        }
    };
    public static final ParameterType<int[]> INTEGERS = new ParameterType<int[]>(int[].class){

        @Override
        public int[] tryParse(String parameter, ScriptHandler handler) throws Exception {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            Object i = INTEGER.tryParse(parameter, handler);
            if (i == null) {
                String[] split;
                if (parameter.contains("-") && (split = parameter.split("-")).length == 2 && ScriptParser.isPositiveInteger(split[0]) && ScriptParser.isPositiveInteger(split[1])) {
                    int start = Integer.parseInt(split[0]);
                    int end = Integer.parseInt(split[1]);
                    int[] values = CollectionHelper.range(start, end);
                    CollectionHelper.addAll(ints, values);
                }
            } else {
                ints.add((Integer)i);
            }
            return ints.stream().mapToInt(j -> j).toArray();
        }
    };
    public static final ParameterType<Integer> INTEGER = new ParameterType<Integer>(Integer.class){

        @Override
        public Integer tryParse(String parameter, ScriptHandler handler) {
            return Ints.tryParse((String)parameter);
        }
    };
    public static final ParameterType<String> STRING = new ParameterType<String>(String.class){

        @Override
        public String tryParse(String parameter, ScriptHandler handler) {
            if (parameter.startsWith("\"") && parameter.endsWith("\"")) {
                return parameter.substring(1, parameter.length() - 1);
            }
            return null;
        }
    };
    public static final ParameterType<String[]> STRING_ARRAY = new ParameterType<String[]>(String[].class, (ParameterWrapper)new ParameterWrapperStringArray()){

        @Override
        public String[] tryParse(String parameter, ScriptHandler handler) throws Exception {
            String parsed = (String)STRING.tryParse(parameter, handler);
            if (parsed == null) {
                return null;
            }
            return new String[]{parsed};
        }
    };
    public static final ParameterType<Boolean> BOOLEAN = new ParameterType<Boolean>(Boolean.class){

        @Override
        public Boolean tryParse(String parameter, ScriptHandler handler) throws Exception {
            if (parameter.equals("true")) {
                return true;
            }
            if (parameter.equals("false")) {
                return false;
            }
            return null;
        }
    };
    public static final ParameterType<Object> BLANK = new ParameterType<Object>(Object.class){

        @Override
        public Object tryParse(String parameter, ScriptHandler handler) throws Exception {
            return null;
        }
    };

    public static <T, K extends T> void registerDefaultType(Class<T> clazz, ParameterType<K> type) {
        defaultTypes.put(clazz, type);
    }

    public static void registerExceptionWrapper(String key, ParameterWrapper<?> type) {
        exceptionTypes.put(key, type);
    }

    public static <T> ParameterType<? extends T> getDefaultType(Class<T> clazz) {
        return (ParameterType)WarningHelper.uncheckedCast(defaultTypes.get(clazz));
    }

    public static ParameterWrapper<?> getExceptionWrapper(String key) {
        return exceptionTypes.get(key);
    }

    static {
        ParameterTypes.registerDefaultType(Integer.class, INTEGER);
        ParameterTypes.registerDefaultType(Integer.TYPE, INTEGER);
        ParameterTypes.registerDefaultType(Float.class, FLOAT);
        ParameterTypes.registerDefaultType(Float.TYPE, FLOAT);
        ParameterTypes.registerDefaultType(Byte.class, BYTE);
        ParameterTypes.registerDefaultType(Byte.TYPE, BYTE);
        ParameterTypes.registerDefaultType(Boolean.class, BOOLEAN);
        ParameterTypes.registerDefaultType(Boolean.TYPE, BOOLEAN);
        ParameterTypes.registerDefaultType(int[].class, INTEGERS);
        ParameterTypes.registerDefaultType(String.class, STRING);
        ParameterTypes.registerDefaultType(String[].class, STRING_ARRAY);
        ParameterTypes.registerDefaultType(JsonPrimitive.class, JSON_PRIMITIVE);
        ParameterTypes.registerExceptionWrapper("nonNegInt", NON_NEG_INTEGER.getSimpleWrapper());
        ParameterTypes.registerExceptionWrapper("nonNegByte", NON_NEG_BYTE.getSimpleWrapper());
        ParameterTypes.registerExceptionWrapper("nonNegInts", NON_NEG_INTEGERS.getSimpleWrapper());
    }
}

