/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.biome;

import java.io.File;
import java.util.Arrays;
import me.superckl.biometweaker.ar.com.hjg.pngj.IImageLineFactory;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageInfo;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageLineHelper;
import me.superckl.biometweaker.ar.com.hjg.pngj.ImageLineInt;
import me.superckl.biometweaker.ar.com.hjg.pngj.PngWriter;
import me.superckl.biometweaker.client.gui.GuiGeneratingBiomeLayoutImage;
import me.superckl.biometweaker.common.world.DummyWorld;
import me.superckl.biometweaker.util.BiomeColorMappings;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.storage.WorldInfo;

public class BiomePainter {
    private final String worldName;
    private final WorldSettings worldSettings;
    private BiomeProvider bProvider;
    private final Biome[] tempArray = new Biome[1];
    private final int[] colorArray = new int[256];

    public void paintImage(int radius, ChunkPos center, File outputFile, GuiGeneratingBiomeLayoutImage gui) {
        Arrays.fill(this.colorArray, -1);
        ImageInfo iInfo = new ImageInfo(radius * 2, radius * 2, 8, false);
        IImageLineFactory<ImageLineInt> factory = ImageLineInt.getFactory(iInfo);
        PngWriter writer = new PngWriter(outputFile, iInfo);
        int[] colors = new int[iInfo.cols];
        int currentX = center.field_77276_a - iInfo.cols / 2;
        int currentY = center.field_77275_b + iInfo.rows / 2;
        for (int i = 0; i < iInfo.rows; ++i) {
            gui.setCurrentX(currentX + i);
            for (int j = 0; j < colors.length; ++j) {
                gui.setCurrentY(currentY + j);
                colors[j] = this.getColor(currentX + i, currentY + j);
            }
            ImageLineInt line = factory.createImageLine(iInfo);
            ImageLineHelper.setPixelsRGB8(line, colors);
            writer.writeRow(line);
            gui.setProgress((double)i / (double)iInfo.rows);
        }
        writer.end();
        gui.setFinished();
    }

    private int getColor(int chunkX, int chunkZ) {
        if (this.bProvider == null) {
            DummyWorld world = new DummyWorld(new WorldInfo(this.worldSettings, this.worldName));
            world.field_73011_w.func_76558_a((World)world);
            this.bProvider = world.func_72959_q();
        }
        this.tempArray[0] = null;
        int bId = Biome.func_185362_a((Biome)this.bProvider.func_76931_a(this.tempArray, (chunkX << 4) + 8, (chunkZ << 4) + 8, 1, 1, false)[0]);
        if (this.colorArray[bId] == -1) {
            LogHelper.info(bId);
            LogHelper.info(Biome.func_150568_d((int)bId));
            LogHelper.info(Biome.field_185377_q.func_177774_c((Object)Biome.func_150568_d((int)bId)));
            this.colorArray[bId] = BiomeColorMappings.getColorForBiome(((ResourceLocation)Biome.field_185377_q.func_177774_c((Object)Biome.func_150568_d((int)bId))).toString());
        }
        return this.colorArray[bId];
    }

    public BiomePainter(String worldName, WorldSettings worldSettings) {
        this.worldName = worldName;
        this.worldSettings = worldSettings;
    }
}

