/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.common.world.gen.feature;

import com.google.common.base.Predicate;
import java.util.Random;
import me.superckl.api.superscript.util.BlockEquivalencePredicate;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockVine;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenGenericTree
extends WorldGenAbstractTree {
    private final int minHeight;
    private final int heightVariation;
    private final int leafHeight;
    private final IBlockState trunkBlock;
    private final IBlockState leafBlock;
    private final IBlockState vineBlock;
    private final boolean growVines;
    private final boolean checkCanGrow;
    private final Predicate<IBlockState> soilPredicate;
    private final Predicate<IBlockState> leafPredicate;

    public WorldGenGenericTree(boolean notify, int minHeight, int heightVariation, int leafHeight, IBlockState trunkBlock, IBlockState leafBlock, IBlockState vineBlock, boolean growVines, boolean checkCanGrow, Predicate<IBlockState> soilPredicate) {
        super(notify);
        this.minHeight = minHeight;
        this.heightVariation = heightVariation;
        this.leafHeight = leafHeight;
        this.trunkBlock = trunkBlock;
        this.leafBlock = leafBlock;
        this.vineBlock = vineBlock;
        this.growVines = growVines;
        this.checkCanGrow = checkCanGrow;
        this.soilPredicate = soilPredicate;
        this.leafPredicate = new BlockEquivalencePredicate(this.leafBlock);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        int height = (this.heightVariation == 0 ? 0 : rand.nextInt(this.heightVariation)) + this.minHeight;
        boolean shouldGrow = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= world.func_72800_K()) {
            for (int y = position.func_177956_o(); y <= position.func_177956_o() + 1 + height; ++y) {
                int radius = 1;
                if (y == position.func_177956_o()) {
                    radius = 0;
                }
                if (y >= position.func_177956_o() + 1 + height - 2) {
                    radius = 2;
                }
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = position.func_177958_n() - radius; x <= position.func_177958_n() + radius && shouldGrow; ++x) {
                    for (int z = position.func_177952_p() - radius; z <= position.func_177952_p() + radius && shouldGrow; ++z) {
                        if (y >= 0 && y < world.func_72800_K()) {
                            if (this.isReplaceable(world, (BlockPos)mutableBlockPos.func_181079_c(x, y, z))) continue;
                            shouldGrow = false;
                            continue;
                        }
                        shouldGrow = false;
                    }
                }
            }
            if (!shouldGrow) {
                return false;
            }
            IBlockState block = world.func_180495_p(position.func_177977_b());
            shouldGrow = false;
            if (this.soilPredicate == null) {
                shouldGrow = this.checkCanGrow && block.func_177230_c().canSustainPlant(block, (IBlockAccess)world, position.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            } else {
                shouldGrow = this.soilPredicate.apply((Object)block);
                if (!shouldGrow) {
                    boolean bl = shouldGrow = this.checkCanGrow && block.func_177230_c().canSustainPlant(block, (IBlockAccess)world, position.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
                }
            }
            if (shouldGrow && position.func_177956_o() < world.func_72800_K() - height - 1) {
                int z;
                int y;
                if (this.checkCanGrow) {
                    block.func_177230_c().onPlantGrow(block, world, position.func_177977_b(), position);
                }
                for (y = position.func_177956_o() - (this.leafHeight - 1) + height; y <= position.func_177956_o() + height; ++y) {
                    int ly = y - (position.func_177956_o() + height);
                    int leafRadius = 1 - ly / 2;
                    for (int x = position.func_177958_n() - leafRadius; x <= position.func_177958_n() + leafRadius; ++x) {
                        int lx = x - position.func_177958_n();
                        for (z = position.func_177952_p() - leafRadius; z <= position.func_177952_p() + leafRadius; ++z) {
                            BlockPos blockpos;
                            int lz = z - position.func_177952_p();
                            if (Math.abs(lx) == leafRadius && Math.abs(lz) == leafRadius && (rand.nextInt(2) == 0 || ly == 0) || !(block = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(block, (IBlockAccess)world, blockpos) && (!this.leafBlock.func_177230_c().isLeaves(block, (IBlockAccess)world, blockpos) || !block.func_177230_c().isLeaves(block, (IBlockAccess)world, blockpos)) && !this.leafPredicate.apply((Object)block) && block.func_185904_a() != Material.field_151582_l) continue;
                            this.func_175903_a(world, blockpos, this.leafBlock);
                        }
                    }
                }
                for (y = 0; y < height; ++y) {
                    BlockPos up = position.func_177981_b(y);
                    block = world.func_180495_p(up);
                    if (!block.func_177230_c().isAir(block, (IBlockAccess)world, up) && (!this.leafBlock.func_177230_c().isLeaves(block, (IBlockAccess)world, up) || !block.func_177230_c().isLeaves(block, (IBlockAccess)world, up)) && !this.leafPredicate.apply((Object)block) && block.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(world, position.func_177981_b(y), this.trunkBlock);
                    if (!this.growVines || y <= 0) continue;
                    if (rand.nextInt(3) > 0 && world.func_175623_d(position.func_177982_a(-1, y, 0))) {
                        this.addVine(world, position.func_177982_a(-1, y, 0), BlockVine.field_176278_M);
                    }
                    if (rand.nextInt(3) > 0 && world.func_175623_d(position.func_177982_a(1, y, 0))) {
                        this.addVine(world, position.func_177982_a(1, y, 0), BlockVine.field_176280_O);
                    }
                    if (rand.nextInt(3) > 0 && world.func_175623_d(position.func_177982_a(0, y, -1))) {
                        this.addVine(world, position.func_177982_a(0, y, -1), BlockVine.field_176279_N);
                    }
                    if (rand.nextInt(3) <= 0 || !world.func_175623_d(position.func_177982_a(0, y, 1))) continue;
                    this.addVine(world, position.func_177982_a(0, y, 1), BlockVine.field_176273_b);
                }
                if (this.growVines) {
                    for (y = position.func_177956_o() - 3 + height; y <= position.func_177956_o() + height; ++y) {
                        int ly = y - (position.func_177956_o() + height);
                        int vineRadius = 2 - ly / 2;
                        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                        for (int x = position.func_177958_n() - vineRadius; x <= position.func_177958_n() + vineRadius; ++x) {
                            for (z = position.func_177952_p() - vineRadius; z <= position.func_177952_p() + vineRadius; ++z) {
                                mutableBlockPos.func_181079_c(x, y, z);
                                block = world.func_180495_p((BlockPos)mutableBlockPos);
                                if (!block.func_177230_c().isLeaves(block, (IBlockAccess)world, (BlockPos)mutableBlockPos)) continue;
                                BlockPos west = mutableBlockPos.func_177976_e();
                                BlockPos east = mutableBlockPos.func_177974_f();
                                BlockPos north = mutableBlockPos.func_177978_c();
                                BlockPos south = mutableBlockPos.func_177968_d();
                                if (rand.nextInt(4) == 0 && world.func_175623_d(west)) {
                                    this.addHangingVine(world, west, BlockVine.field_176278_M);
                                }
                                if (rand.nextInt(4) == 0 && world.func_175623_d(east)) {
                                    this.addHangingVine(world, east, BlockVine.field_176280_O);
                                }
                                if (rand.nextInt(4) == 0 && world.func_175623_d(north)) {
                                    this.addHangingVine(world, north, BlockVine.field_176279_N);
                                }
                                if (rand.nextInt(4) != 0 || !world.func_175623_d(south)) continue;
                                this.addHangingVine(world, south, BlockVine.field_176273_b);
                            }
                        }
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addVine(World worldIn, BlockPos pos, PropertyBool prop) {
        this.func_175903_a(worldIn, pos, this.vineBlock.func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(true)));
    }

    private void addHangingVine(World worldIn, BlockPos pos, PropertyBool prop) {
        this.addVine(worldIn, pos, prop);
        pos = pos.func_177977_b();
        for (int vineLength = 4; worldIn.func_175623_d(pos) && vineLength > 0; --vineLength) {
            this.addVine(worldIn, pos, prop);
            pos = pos.func_177977_b();
        }
    }
}

