/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.thermalexpansion.recipehandler;

import cofh.thermalexpansion.block.machine.TileCompactor;
import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.commoncapabilities.capability.recipehandler.TransformedRecipeHandlerAdapter;
import org.cyclops.commoncapabilities.modcompat.thermalexpansion.ThermalExpansionHelpers;

public class TileCompactorRecipeHandler
extends TransformedRecipeHandlerAdapter<CompactorManager.CompactorRecipe> {
    private final TileCompactor tile;

    public TileCompactorRecipeHandler(TileCompactor tile) {
        super(Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}), Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK}));
        this.tile = tile;
    }

    protected CompactorManager.Mode getMode() {
        try {
            return (CompactorManager.Mode)ThermalExpansionHelpers.FIELD_TILECOMPACTOR_MODE.get(this.tile);
        }
        catch (IllegalAccessException e) {
            return CompactorManager.Mode.ALL;
        }
    }

    @Override
    protected String getRecipeCacheKey() {
        return "thermalexpansion:compactor";
    }

    @Override
    protected IRecipeDefinition transformRecipe(CompactorManager.CompactorRecipe recipe) {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        inputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new IPrototypedIngredientAlternatives[]{new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, recipe.getInput(), 15)}))}));
        outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getOutput()}));
        return new RecipeDefinition(inputs, new MixedIngredients(outputs));
    }

    @Override
    protected CompactorManager.CompactorRecipe findRecipe(IMixedIngredients input) {
        return CompactorManager.getRecipe((ItemStack)input.getFirstNonEmpty(IngredientComponent.ITEMSTACK), (CompactorManager.Mode)this.getMode());
    }

    @Override
    protected Collection<CompactorManager.CompactorRecipe> getRecipesRaw() {
        return Lists.newArrayList((Object[])CompactorManager.getRecipeList((CompactorManager.Mode)this.getMode()));
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.ITEMSTACK && size == 1;
    }
}

