/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.network;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import p455w0rd.danknull.init.ModConfig;

public class PacketConfigSync
implements IMessage {
    public transient Map<String, Object> values;

    public PacketConfigSync() {
    }

    public PacketConfigSync(Map<String, Object> valuesIn) {
        this.values = valuesIn;
    }

    public void fromBytes(ByteBuf buf) {
        short len = buf.readShort();
        byte[] compressedBody = new byte[len];
        for (short i = 0; i < len; i = (short)(i + 1)) {
            compressedBody[i] = buf.readByte();
        }
        try {
            ObjectInputStream obj = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(compressedBody)));
            this.values = (Map)obj.readObject();
            obj.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteArrayOutputStream obj = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(obj);
            ObjectOutputStream objStream = new ObjectOutputStream(gzip);
            objStream.writeObject(this.values);
            objStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        buf.writeShort(obj.size());
        buf.writeBytes(obj.toByteArray());
    }

    public static class Handler
    implements IMessageHandler<PacketConfigSync, IMessage> {
        public IMessage onMessage(PacketConfigSync message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketConfigSync message, MessageContext ctx) {
            if (ctx.getClientHandler() != null) {
                ModConfig.Options.creativeBlacklist = (String)message.values.getOrDefault("CreativeBlacklist", "");
                ModConfig.Options.creativeWhitelist = (String)message.values.getOrDefault("CreativeWhitelist", "");
                ModConfig.Options.oreBlacklist = (String)message.values.getOrDefault("OreDictBlacklist", "");
                ModConfig.Options.oreWhitelist = (String)message.values.getOrDefault("OreDictWhitelist", "");
                ModConfig.Options.disableOreDictMode = (Boolean)message.values.getOrDefault("DisableOreDictMode", false);
            }
        }
    }
}

