/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.twilight;

import divinerpg.registry.DivineRPGTabs;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class BlockTwilightFlower
extends BlockBush
implements IPlantable {
    private Supplier<Block> grassSupplier;
    private AxisAlignedBB size;

    public BlockTwilightFlower(String name, Supplier<Block> grassSupplier, MapColor mapColorIn) {
        this(name, grassSupplier, 0.4, 1.0, mapColorIn);
    }

    public BlockTwilightFlower(String name, Supplier<Block> grassSupplier, double width, double height, MapColor mapColorIn) {
        super(Material.field_151585_k, mapColorIn);
        this.setRegistryName("divinerpg", name);
        this.func_149663_c(name);
        this.grassSupplier = grassSupplier;
        this.func_149647_a(DivineRPGTabs.BLOCKS);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
        if (width <= 0.0 || height <= 0.0) {
            throw new RuntimeException("Width or height cannot be less/equals zero!");
        }
        double leftCorner = Double.max(0.0, 0.5 - width / 2.0);
        double rightCorner = 0.5 + width / 2.0;
        this.size = new AxisAlignedBB(leftCorner, 0.0, leftCorner, rightCorner, height, rightCorner);
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != this) {
            return this.func_176223_P();
        }
        return state;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && soil.func_177230_c() == this.grassSupplier.get();
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == this.grassSupplier.get();
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        return this.func_185514_i(worldIn.func_180495_p(pos.func_177977_b()));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.size;
    }

    public Block getGrass() {
        return this.grassSupplier.get();
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }
}

