/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.vanilla;

import divinerpg.objects.entities.entity.EntityDivineMob;
import divinerpg.registry.LootTableRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateClimber;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityPumpkinSpider
extends EntityDivineMob {
    private static final DataParameter<Boolean> CLIMBING = EntityDataManager.func_187226_a(EntityPumpkinSpider.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PROVOKED = EntityDataManager.func_187226_a(EntityPumpkinSpider.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityPumpkinSpider(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.25f, 1.0f);
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CLIMBING, (Object)false);
        this.field_70180_af.func_187214_a(PROVOKED, (Object)false);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateClimber((EntityLiving)this, worldIn);
    }

    @Override
    public boolean needsSpecialAI() {
        return true;
    }

    public void func_70024_g(double x, double y, double z) {
        if (this.getProvoked()) {
            super.func_70024_g(x, y, z);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.getProvoked()) {
            EntityPlayer player = this.field_70170_p.func_184142_a((Entity)this, 6.0, 6.0);
            this.field_70761_aq = 0.0f;
            if (player != null) {
                this.setProvoked(player);
            }
        } else if (!this.field_70170_p.field_72995_K) {
            this.setBesideClimbableBlock(this.field_70123_F);
        }
    }

    public void setBesideClimbableBlock(boolean climbing) {
        this.field_70180_af.func_187227_b(CLIMBING, (Object)climbing);
    }

    public boolean isBesideClimbableBlock() {
        return (Boolean)this.field_70180_af.func_187225_a(CLIMBING);
    }

    public boolean func_70617_f_() {
        return this.getProvoked() && this.isBesideClimbableBlock();
    }

    public void func_70110_aj() {
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("Provoked", this.getProvoked());
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74767_n("Provoked")) {
            this.setProvoked(null);
        }
    }

    public boolean getProvoked() {
        return (Boolean)this.field_70180_af.func_187225_a(PROVOKED);
    }

    @Nullable
    public void setProvoked(EntityPlayer player) {
        this.field_70180_af.func_187227_b(PROVOKED, (Object)true);
        this.addBasicAI();
        this.addAttackingAI();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        if (player != null && !player.field_71075_bZ.field_75098_d) {
            this.func_70624_b((EntityLivingBase)player);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity entity = source.func_76346_g();
        if (entity instanceof EntityPlayer && !this.getProvoked()) {
            EntityPlayer player = (EntityPlayer)entity;
            this.setProvoked(player);
        }
        return super.func_70097_a(source, amount);
    }

    protected boolean func_70814_o() {
        return true;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187821_fM;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187819_fL;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.ENTITIES_PUMPKIN_SPIDER;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70170_p.field_73011_w.getDimension() == 0 && this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150349_c && super.func_70601_bi();
    }
}

