/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils;

import net.minecraft.command.ICommandSender;
import net.minecraft.item.Item;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.command.TextComponentHelper;

public class LocalizeUtils {
    private static final TextComponentBase InfiniteUses = new TextComponentTranslation("tooltip.uses.infinite", new Object[0]);
    private static final TextComponentBase NoProtection = new TextComponentTranslation("tooltip.noprotection", new Object[0]);
    private static final TextComponentBase InfiniteAmmo = new TextComponentTranslation("tooltip.ammo.infinite", new Object[0]);
    private static final TextComponentBase ExposiveShoots = new TextComponentTranslation("tooltip.shots.explosive", new Object[0]);
    private static final TextComponentBase HomingShoots = new TextComponentTranslation("tooltip.shots.homing", new Object[0]);
    private static final TextComponentBase SingleUse = new TextComponentTranslation("tooltip.uses.single", new Object[0]);
    private static final TextComponentBase InstantConsumption = new TextComponentTranslation("tooltip.instant_consumption", new Object[0]);
    private static final TextComponentBase WeakenedWithoutArcana = new TextComponentTranslation("tooltip.weakened_without_arcana", new Object[0]);
    private static final String RemainingUses = "tooltip.uses";
    private static final String DamageReductionStringFormat = "tooltip.damage.reduction";
    private static final String Ammo = "tooltip.ammo";
    private static final String ArcanaConsuming = "tooltip.arcana";
    private static final String ArcanaDamageSource = "tooltip.damage.arcana";
    private static final String ArcanaRegen = "tooltip.arcana.regen";
    private static final String MeleeDamage = "tooltip.damage.melee";
    private static final String BowDamage = "tooltip.damage.ranged";
    private static final String RangedAndMeleeDamage = "tooltip.damage.both";
    private static final String Efficency = "tooltip.efficiency";
    private static final String HarvestLevel = "tooltip.harvest_level";
    private static final String Poison = "tooltip.effect.poisons";
    private static final String BurnMobs = "tooltip.effect.burns";
    private static final String SlowMobs = "tooltip.effect.slows";

    public static TextComponentBase getArmorAbility(String keyPart, Object ... params) {
        String id = String.format("tooltip.armor_info.%s", keyPart);
        return params == null || params.length < 1 ? new TextComponentTranslation(id, new Object[0]) : new TextComponentTranslation(id, params);
    }

    public static String usesRemaining(int uses) {
        return LocalizeUtils.i18n(RemainingUses, uses);
    }

    public static String infiniteAmmo() {
        return InfiniteAmmo.func_150254_d();
    }

    public static String ammo(Item ammo) {
        return LocalizeUtils.ammo(ammo, TextFormatting.GRAY);
    }

    public static String ammo(Item ammo, boolean isPresent) {
        return LocalizeUtils.ammo(ammo, isPresent ? TextFormatting.GREEN : TextFormatting.RED);
    }

    public static String ammo(Item ammo, TextFormatting formatting) {
        TextComponentTranslation ammoName = new TextComponentTranslation(ammo.func_77658_a() + ".name", new Object[0]);
        ammoName.func_150256_b().func_150238_a(formatting);
        return LocalizeUtils.i18n(Ammo, ammoName);
    }

    public static String arcanaConsumed(Object ar) {
        return LocalizeUtils.i18n(ArcanaConsuming, ar);
    }

    public static String arcanaDam(double dam) {
        return LocalizeUtils.i18n(ArcanaDamageSource, dam);
    }

    public static String arcanaRegen(int ar) {
        return LocalizeUtils.i18n(ArcanaRegen, ar);
    }

    public static String bowDam(String dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static String burn(int seconds) {
        return LocalizeUtils.i18n(BurnMobs, seconds);
    }

    public static String infiniteUses() {
        return InfiniteUses.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150254_d();
    }

    public static String instantConsumption() {
        return InstantConsumption.func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)).func_150254_d();
    }

    public static String weakenedWithoutArcana() {
        return WeakenedWithoutArcana.func_150255_a(new Style().func_150238_a(TextFormatting.RED)).func_150254_d();
    }

    public static String damageReduction(double reduct, double fullReduct) {
        return LocalizeUtils.i18n(DamageReductionStringFormat, reduct, fullReduct);
    }

    public static String efficiency(double eff) {
        return LocalizeUtils.i18n(Efficency, eff);
    }

    public static String harvestLevel(int lvl) {
        return LocalizeUtils.i18n(HarvestLevel, lvl);
    }

    public static String explosiveShots() {
        return ExposiveShoots.func_150254_d();
    }

    public static String homingShots() {
        return HomingShoots.func_150254_d();
    }

    public static String singleUse() {
        return SingleUse.func_150254_d();
    }

    public static String meleeDam(double dam) {
        return LocalizeUtils.i18n(MeleeDamage, dam);
    }

    public static String poison(float seconds) {
        return LocalizeUtils.i18n(Poison, Float.valueOf(seconds));
    }

    public static String rangedDam(double dam) {
        return LocalizeUtils.i18n(BowDamage, dam);
    }

    public static String slow(double seconds) {
        return LocalizeUtils.i18n(SlowMobs, seconds);
    }

    public static String noProtection() {
        return NoProtection.func_150254_d();
    }

    public static String normal(String message) {
        return LocalizeUtils.normal(message, TextFormatting.WHITE);
    }

    public static String normal(String message, TextFormatting format) {
        TextComponentTranslation text = new TextComponentTranslation(message, new Object[0]);
        text.func_150256_b().func_150238_a(format);
        return text.func_150254_d();
    }

    public static String version(String vers) {
        TextComponentTranslation text = new TextComponentTranslation("message.version", new Object[]{vers});
        text.func_150256_b().func_150238_a(TextFormatting.RED);
        return text.func_150254_d();
    }

    public static ITextComponent getClientSideTranslation(ICommandSender sender, String str, Object ... args) {
        return TextComponentHelper.createComponentTranslation((ICommandSender)sender, (String)str, (Object[])args);
    }

    public static String i18n(String text, Object ... args) {
        TextComponentTranslation result = new TextComponentTranslation(text, args);
        result.func_150256_b().func_150238_a(TextFormatting.GRAY);
        return result.func_150254_d();
    }

    public static String i18n(TextFormatting color, String text, Object ... args) {
        TextComponentTranslation result = new TextComponentTranslation(text, args);
        result.func_150256_b().func_150238_a(color);
        return result.func_150254_d();
    }
}

