/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.item;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.capability.ItemTools;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.FilterRegistry;
import crazypants.enderio.base.filter.capability.CapabilityFilterHolder;
import crazypants.enderio.base.filter.capability.IFilterHolder;
import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.base.filter.item.ItemFilter;
import crazypants.enderio.base.filter.item.items.IItemFilterItemUpgrade;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.capability.CapabilityUpgradeHolder;
import crazypants.enderio.conduits.capability.IUpgradeHolder;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.item.IItemConduit;
import crazypants.enderio.conduits.conduit.item.ItemConduitNetwork;
import crazypants.enderio.conduits.conduit.item.NetworkedInventory;
import crazypants.enderio.conduits.gui.ItemSettings;
import crazypants.enderio.conduits.init.ConduitObject;
import crazypants.enderio.conduits.lang.Lang;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.conduits.render.ConduitTextureWrapper;
import crazypants.enderio.util.EnumReader;
import crazypants.enderio.util.Prep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemConduit
extends AbstractConduit
implements IItemConduit,
IFilterHolder<IItemFilter>,
IUpgradeHolder {
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    @Nonnull
    public static final String EXTERNAL_INTERFACE_GEOM = "ExternalInterface";
    @Nonnull
    public static final IConduitTexture ICON_KEY = new ConduitTexture(TextureRegistry.registerTexture("blocks/conduit"), ConduitTexture.arm(0));
    @Nonnull
    public static final IConduitTexture ICON_KEY_CORE = new ConduitTexture(TextureRegistry.registerTexture("blocks/item_conduit_core"), ConduitTexture.core());
    @Nonnull
    public static final IConduitTexture ICON_KEY_ENDER = new ConduitTexture(TextureRegistry.registerTexture("blocks/ender_still"), new Vector4f(0.09375f, 0.375f, 0.90625f, 0.625f));
    ItemConduitNetwork network;
    @Nonnull
    protected final EnumMap<EnumFacing, RedstoneControlMode> extractionModes = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, DyeColor> extractionColors = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, IItemFilter> outputFilters = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, IItemFilter> inputFilters = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, ItemStack> outputFilterUpgrades = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, ItemStack> inputFilterUpgrades = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, ItemStack> functionUpgrades = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Boolean> selfFeed = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Boolean> roundRobin = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, Integer> priorities = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, DyeColor> outputColors = new EnumMap(EnumFacing.class);
    @Nonnull
    protected final EnumMap<EnumFacing, DyeColor> inputColors = new EnumMap(EnumFacing.class);
    private int metaData;

    public ItemConduit() {
        this(0);
    }

    public ItemConduit(int itemDamage) {
        this.metaData = itemDamage;
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.outputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.inputFilterUpgrades.put(dir, ItemStack.field_190927_a);
            this.functionUpgrades.put(dir, ItemStack.field_190927_a);
        }
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setConnectionMode(dir, EnumReader.get(ConnectionMode.class, dataRoot.func_74765_d("connectionMode")));
        this.setExtractionSignalColor(dir, EnumReader.get(DyeColor.class, dataRoot.func_74765_d("extractionSignalColor")));
        this.setExtractionRedstoneMode(EnumReader.get(RedstoneControlMode.class, dataRoot.func_74765_d("extractionRedstoneMode")), dir);
        this.setInputColor(dir, EnumReader.get(DyeColor.class, dataRoot.func_74765_d("inputColor")));
        this.setOutputColor(dir, EnumReader.get(DyeColor.class, dataRoot.func_74765_d("outputColor")));
        this.setSelfFeedEnabled(dir, dataRoot.func_74767_n("selfFeed"));
        this.setRoundRobinEnabled(dir, dataRoot.func_74767_n("roundRobin"));
        this.setOutputPriority(dir, dataRoot.func_74762_e("outputPriority"));
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
        dataRoot.func_74777_a("inputColor", (short)this.getInputColor(dir).ordinal());
        dataRoot.func_74777_a("outputColor", (short)this.getOutputColor(dir).ordinal());
        dataRoot.func_74757_a("selfFeed", this.isSelfFeedEnabled(dir));
        dataRoot.func_74757_a("roundRobin", this.isRoundRobinEnabled(dir));
        dataRoot.func_74768_a("outputPriority", this.getOutputPriority(dir));
    }

    @Override
    @Nonnull
    public NNList<ItemStack> getDrops() {
        NNList<ItemStack> res = super.getDrops();
        for (ItemStack stack : this.functionUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.inputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        for (ItemStack stack : this.outputFilterUpgrades.values()) {
            res.add((Object)stack);
        }
        return res;
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            return false;
        }
        CollidableComponent component = res.component;
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && component != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.externalConnections.contains(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconnectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void setInputFilter(@Nonnull EnumFacing dir, @Nonnull IItemFilter filter) {
        this.inputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilter(@Nonnull EnumFacing dir, @Nonnull IItemFilter filter) {
        this.outputFilters.put(dir, filter);
        if (this.network != null) {
            this.network.routesChanged();
        }
        this.setClientStateDirty();
    }

    @Override
    public IItemFilter getInputFilter(@Nonnull EnumFacing dir) {
        return this.inputFilters.get(dir);
    }

    @Override
    public IItemFilter getOutputFilter(@Nonnull EnumFacing dir) {
        return this.outputFilters.get(dir);
    }

    @Override
    public void setInputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.inputFilterUpgrades.put(dir, stack);
        this.setInputFilter(dir, (IItemFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    public void setOutputFilterUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack stack) {
        this.outputFilterUpgrades.put(dir, stack);
        this.setOutputFilter(dir, (IItemFilter)FilterRegistry.getFilterForUpgrade(stack));
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getInputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.inputFilterUpgrades.get(dir);
    }

    @Override
    @Nonnull
    public ItemStack getOutputFilterUpgrade(@Nonnull EnumFacing dir) {
        return this.outputFilterUpgrades.get(dir);
    }

    @Override
    public void setFunctionUpgrade(@Nonnull EnumFacing dir, @Nonnull ItemStack upgrade) {
        this.functionUpgrades.put(dir, upgrade);
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public ItemStack getFunctionUpgrade(@Nonnull EnumFacing dir) {
        return this.functionUpgrades.get(dir);
    }

    @Override
    public int getMetaData() {
        return this.metaData;
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        this.extractionModes.put(dir, mode);
    }

    @Override
    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(@Nonnull EnumFacing dir) {
        RedstoneControlMode res = this.extractionModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.NEVER;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.extractionColors.put(dir, col);
    }

    @Override
    @Nonnull
    public DyeColor getExtractionSignalColor(@Nonnull EnumFacing dir) {
        DyeColor result = this.extractionColors.get(dir);
        if (result == null) {
            return DyeColor.RED;
        }
        return result;
    }

    @Override
    public boolean isExtractionRedstoneConditionMet(@Nonnull EnumFacing dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet(this, mode, this.getExtractionSignalColor(dir), dir);
    }

    @Override
    public int getMaximumExtracted(@Nonnull EnumFacing dir) {
        ItemStack stack = this.functionUpgrades.get(dir);
        if (stack.func_190926_b()) {
            return 4;
        }
        FunctionUpgrade functionUpgrade = ItemFunctionUpgrade.getFunctionUpgrade(stack);
        return functionUpgrade.getMaximumExtracted(stack.func_190916_E());
    }

    @Override
    public float getTickTimePerItem(@Nonnull EnumFacing dir) {
        float maxExtract = 10.0f / (float)this.getMaximumExtracted(dir);
        return maxExtract;
    }

    @Override
    public void itemsExtracted(int numExtracted, int slot) {
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing direction) {
        super.externalConnectionAdded(direction);
        this.checkInventoryConnections(direction);
    }

    @Override
    public IItemHandler getExternalInventory(@Nonnull EnumFacing direction) {
        World world = this.getBundle().getBundleworld();
        BlockPos loc = this.getBundle().getLocation().func_177972_a(direction);
        return ItemTools.getExternalInventory((IBlockAccess)world, loc, direction.func_176734_d());
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing direction) {
        this.externalConnections.remove(direction);
        this.connectionsChanged();
        this.checkInventoryConnections(direction);
    }

    private void checkInventoryConnections(@Nonnull EnumFacing direction) {
        if (this.network != null) {
            BlockPos p = this.getBundle().getEntity().func_174877_v().func_177972_a(direction);
            NetworkedInventory networkedInventory = this.network.getInventory(this, direction);
            if (this.externalConnections.contains(direction) && this.getConnectionMode(direction) != ConnectionMode.DISABLED) {
                if (networkedInventory == null) {
                    this.network.inventoryAdded(this, direction, p, this.getExternalInventory(direction));
                }
            } else if (networkedInventory != null) {
                this.network.inventoryRemoved(this, p);
            }
        }
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        ConnectionMode oldVal = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (oldVal == mode) {
            return;
        }
        super.setConnectionMode(dir, mode);
        this.checkInventoryConnections(dir);
        if (this.network != null) {
            this.network.routesChanged();
        }
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreDisabled) {
        return this.getExternalInventory(direction) != null;
    }

    @Override
    @Nonnull
    protected ConnectionMode getDefaultConnectionMode() {
        return ConnectionMode.INPUT;
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IItemConduit.class;
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        ItemStack result = new ItemStack(ConduitObject.item_item_conduit.getItemNN(), 1, this.metaData);
        return result;
    }

    @Nullable
    public ItemConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (ItemConduitNetwork)network;
        return super.setNetwork(network);
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    @Nonnull
    public Map<EnumFacing, DyeColor> getInputColors() {
        return this.inputColors;
    }

    @Override
    @Nonnull
    public Map<EnumFacing, DyeColor> getOutputColors() {
        return this.outputColors;
    }

    @Override
    @Nonnull
    public Map<EnumFacing, Boolean> getSelfFeed() {
        return this.selfFeed;
    }

    @Override
    @Nonnull
    public Map<EnumFacing, Boolean> getRoundRobin() {
        return this.roundRobin;
    }

    @Override
    @Nonnull
    public Map<EnumFacing, Integer> getOutputPriorities() {
        return this.priorities;
    }

    @Override
    public void setClientDirty() {
        this.setClientStateDirty();
        this.collidablesDirty = true;
    }

    @Override
    public void refreshConnection(@Nonnull EnumFacing dir) {
        if (this.network == null) {
            return;
        }
        this.network.routesChanged();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getEnderIcon() {
        return ICON_KEY_ENDER;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getCoreIcon() {
        return ICON_KEY_CORE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return this.getCoreIcon();
        }
        if (EXTERNAL_INTERFACE_GEOM.equals(component.data)) {
            return this.getCoreIcon();
        }
        if ("ColorController".equals(component.data)) {
            return new ConduitTextureWrapper(IconUtil.instance.whiteTexture);
        }
        return ICON_KEY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return this.getEnderIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        NBTTagCompound itemRoot;
        IItemFilter filter;
        NBTTagCompound itemRoot2;
        ItemStack up;
        IItemFilter f;
        super.writeToNBT(nbtRoot);
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilters.entrySet()) {
            if (entry.getValue() == null || this.isDefault(f = entry.getValue())) continue;
            NBTTagCompound itemRoot22 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot22);
            nbtRoot.func_74782_a("inFilts." + entry.getKey().name(), (NBTBase)itemRoot22);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.functionUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid(up)) continue;
            itemRoot2 = new NBTTagCompound();
            up.func_77955_b(itemRoot2);
            nbtRoot.func_74782_a("functionUpgrades." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilters.entrySet()) {
            f = entry.getValue();
            if (f == null || this.isDefault(f)) continue;
            itemRoot2 = new NBTTagCompound();
            FilterRegistry.writeFilterToNbt(f, itemRoot2);
            nbtRoot.func_74782_a("outFilts." + entry.getKey().name(), (NBTBase)itemRoot2);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.inputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid(up)) continue;
            filter = this.getInputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("inputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, IItemFilter> entry : this.outputFilterUpgrades.entrySet()) {
            up = (ItemStack)entry.getValue();
            if (up == null || !Prep.isValid(up)) continue;
            filter = this.getOutputFilter(entry.getKey());
            FilterRegistry.writeFilterToStack(filter, up);
            itemRoot = new NBTTagCompound();
            up.func_77955_b(itemRoot);
            nbtRoot.func_74782_a("outputFilterUpgrades." + entry.getKey().name(), (NBTBase)itemRoot);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionModes.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((RedstoneControlMode)((Object)entry.getValue())).ordinal();
            nbtRoot.func_74777_a("extRM." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.extractionColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("extSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.selfFeed.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("selfFeed." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.roundRobin.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74757_a("roundRobin." + entry.getKey().name(), ((Boolean)entry.getValue()).booleanValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.priorities.entrySet()) {
            if (entry.getValue() == null) continue;
            nbtRoot.func_74768_a("priority." + entry.getKey().name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<EnumFacing, Object> entry : this.inputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("inSC." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, Object> entry : this.outputColors.entrySet()) {
            if (entry.getValue() == null) continue;
            short ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("outSC." + entry.getKey().name(), ord);
        }
    }

    private boolean isDefault(IItemFilter f) {
        if (f instanceof ItemFilter) {
            return ((ItemFilter)f).isDefault();
        }
        return false;
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.metaData = nbtRoot.func_74764_b("metaData") ? (int)nbtRoot.func_74765_d("metaData") : 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            ItemStack ups;
            NBTTagCompound upTag;
            IItemFilter filter;
            NBTTagCompound filterTag;
            String key = "inFilts." + dir.name();
            if (nbtRoot.func_74764_b(key)) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IItemFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.inputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "functionUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.functionUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "inputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.inputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outputFilterUpgrades." + dir.name())) {
                upTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                ups = new ItemStack(upTag);
                this.outputFilterUpgrades.put(dir, ups);
            }
            if (nbtRoot.func_74764_b(key = "outFilts." + dir.name())) {
                filterTag = (NBTTagCompound)nbtRoot.func_74781_a(key);
                filter = (IItemFilter)FilterRegistry.loadFilterFromNbt(filterTag);
                this.outputFilters.put(dir, filter);
            }
            if (nbtRoot.func_74764_b(key = "extRM." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.extractionModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "extSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.extractionColors.put(dir, DyeColor.values()[ord]);
            }
            if (nbtRoot.func_74764_b(key = "selfFeed." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.selfFeed.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "roundRobin." + dir.name())) {
                boolean val = nbtRoot.func_74767_n(key);
                this.roundRobin.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "priority." + dir.name())) {
                int val = nbtRoot.func_74762_e(key);
                this.priorities.put(dir, val);
            }
            if (nbtRoot.func_74764_b(key = "inSC." + dir.name()) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < DyeColor.values().length) {
                this.inputColors.put(dir, DyeColor.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "outSC." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.outputColors.put(dir, DyeColor.values()[ord]);
        }
        this.connectionsDirty = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        hashCodes.addEnum(this.outputColors);
        hashCodes.addEnum(this.inputColors);
        hashCodes.addEnum(this.extractionColors);
        hashCodes.addEnum(this.extractionModes);
    }

    @Override
    public void invalidate() {
        if (this.network != null) {
            BlockPos pos = this.getBundle().getEntity().func_174877_v();
            for (EnumFacing direction : this.externalConnections) {
                try {
                    BlockPos p = pos.func_177972_a(direction);
                    this.network.inventoryRemoved(this, p);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Nonnull
    public ItemConduitNetwork createNetworkForType() {
        return new ItemConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new ItemSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof ItemSettings) {
            return ((ItemSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 0;
    }

    @Override
    public boolean hasInternalCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY && this.getExternalConnections().contains(facing);
    }

    @Override
    @Nullable
    public <T> T getInternalCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFilterHolder.FILTER_HOLDER_CAPABILITY || capability == CapabilityUpgradeHolder.UPGRADE_HOLDER_CAPABILITY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public IItemFilter getFilter(int filterId, int param1) {
        if (filterId == 1) {
            return this.getInputFilter(EnumFacing.func_82600_a((int)param1));
        }
        if (filterId == 2) {
            return this.getOutputFilter(EnumFacing.func_82600_a((int)param1));
        }
        return null;
    }

    @Override
    public void setFilter(int filterId, EnumFacing side, @Nonnull IItemFilter filter) {
        if (filterId == 1) {
            this.setInputFilter(side, filter);
        } else if (filterId == 2) {
            this.setOutputFilter(side, filter);
        }
    }

    @Override
    @Nullable
    public IItemHandler getInventoryForSnapshot(int filterId, int param1) {
        ItemConduitNetwork icn = this.getNetwork();
        if (icn != null) {
            return icn.getInventory(this, EnumFacing.func_82600_a((int)param1)).getInventory();
        }
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getFilterStack(int filterIndex, EnumFacing side) {
        if (filterIndex == 1) {
            return this.getInputFilterUpgrade(side);
        }
        if (filterIndex == 2) {
            return this.getOutputFilterUpgrade(side);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void setFilterStack(int filterIndex, EnumFacing side, @Nonnull ItemStack stack) {
        if (filterIndex == 1) {
            this.setInputFilterUpgrade(side, stack);
        } else if (filterIndex == 2) {
            this.setOutputFilterUpgrade(side, stack);
        }
    }

    @Override
    @Nonnull
    public ItemStack getUpgradeStack(int param1) {
        return this.getFunctionUpgrade(EnumFacing.func_82600_a((int)param1));
    }

    @Override
    public void setUpgradeStack(int param1, @Nonnull ItemStack stack) {
        this.setFunctionUpgrade(EnumFacing.func_82600_a((int)param1), stack);
    }

    @Override
    public int getUpgradeSlotLimit(@Nonnull ItemStack stack) {
        return stack.func_77973_b() instanceof ItemFunctionUpgrade ? ((ItemFunctionUpgrade)stack.func_77973_b()).getUpgradeSlotLimit() : IUpgradeHolder.super.getUpgradeSlotLimit(stack);
    }

    @Override
    @Nonnull
    public List<String> getFunctionUpgradeToolTipText(@Nonnull EnumFacing dir) {
        return new NNList((Object[])new String[]{Lang.GUI_ITEM_FUNCTION_UPGRADE_DETAILS.get(), Lang.GUI_ITEM_FUNCTION_UPGRADE_DETAILS2.get(this.getMaximumExtracted(dir))});
    }

    @Override
    public int getInputFilterIndex() {
        return 1;
    }

    @Override
    public int getOutputFilterIndex() {
        return 2;
    }

    @Override
    public boolean isFilterUpgradeAccepted(@Nonnull ItemStack stack, boolean isInput) {
        return stack.func_77973_b() instanceof IItemFilterItemUpgrade;
    }

    @Override
    @Nonnull
    public NNList<ITextComponent> getConduitProbeInformation(@Nonnull EntityPlayer player) {
        NNList<ITextComponent> result = super.getConduitProbeInformation(player);
        if (this.getExternalConnections().isEmpty()) {
            TextComponentTranslation elem = crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_ITEM_HEADING_NO_CONNECTIONS.toChatServer();
            elem.func_150256_b().func_150238_a(TextFormatting.GOLD);
            result.add((Object)elem);
        } else {
            ItemStack input = player.func_184614_ca();
            if (input.func_77973_b() == ModObject.itemConduitProbe.getItemNN()) {
                input = player.func_184592_cb();
            }
            ItemConduitNetwork icn = this.getNetwork();
            for (EnumFacing dir : this.getExternalConnections()) {
                if (dir == null) continue;
                ConnectionMode mode = this.getConnectionMode(dir);
                TextComponentTranslation elem = crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_ITEM_HEADING.toChatServer(new TextComponentTranslation(EnderIO.lang.addPrefix("facing." + dir), new Object[0]));
                elem.func_150256_b().func_150238_a(TextFormatting.GREEN);
                result.add((Object)elem);
                if (icn != null && mode.acceptsInput()) {
                    List<String> targets = icn.getTargetsForExtraction(this.getBundle().getLocation().func_177972_a(dir), this, input);
                    elem = input.func_190926_b() ? (targets.isEmpty() ? crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_EXTRACT_NO_ITEM_NO_TARGET.toChatServer() : crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_EXTRACT_NO_ITEM_TARGETS.toChatServer()) : (targets.isEmpty() ? crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_EXTRACT_ITEM_NO_TARGET.toChatServer(input.func_82833_r()) : crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_EXTRACT_ITEM_TARGETS.toChatServer(input.func_82833_r()));
                    elem.func_150256_b().func_150238_a(TextFormatting.BLUE);
                    result.add((Object)elem);
                    for (String str : targets) {
                        result.add((Object)new TextComponentString("  -> " + str));
                    }
                }
                if (icn == null || !mode.acceptsOutput()) continue;
                List<String> sources = icn.getInputSourcesFor(this, dir, input);
                elem = sources.isEmpty() ? (input.func_190926_b() ? crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_NO_ITEMS.toChatServer() : crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_NO_ITEM.toChatServer(input.func_82833_r())) : (input.func_190926_b() ? crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_RECEIVE_ITEMS.toChatServer() : crazypants.enderio.powertools.lang.Lang.GUI_CONDUIT_PROBE_RECEIVE_ITEM.toChatServer(input.func_82833_r()));
                elem.func_150256_b().func_150238_a(TextFormatting.BLUE);
                result.add((Object)elem);
                for (String str : sources) {
                    result.add((Object)new TextComponentString("  -> " + str));
                }
            }
        }
        return result;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        EnumFacing keydir = key.dir;
        if (keydir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.getInstance().createBoundsForConnectionController(keydir, key.offset);
        CollidableComponent cc = new CollidableComponent(IItemConduit.class, bb, keydir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }
}

