/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.network;

import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.conduits.gui.ExternalConnectionContainer;
import crazypants.enderio.conduits.network.AbstractConduitPacket;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSlotVisibility
extends AbstractConduitPacket<IConduit> {
    private boolean filterVisible;
    private boolean upgradeVisible;

    public PacketSlotVisibility() {
    }

    public PacketSlotVisibility(@Nonnull IConduit conduit, boolean filterVisible, boolean upgradeVisible) {
        super(conduit);
        this.filterVisible = filterVisible;
        this.upgradeVisible = upgradeVisible;
    }

    @Override
    public void write(@Nonnull ByteBuf bb) {
        super.write(bb);
        int value = (this.filterVisible ? 1 : 0) | (this.upgradeVisible ? 2 : 0);
        bb.writeByte(value);
    }

    @Override
    public void read(@Nonnull ByteBuf bb) {
        super.read(bb);
        short value = bb.readUnsignedByte();
        this.filterVisible = (value & 1) != 0;
        this.upgradeVisible = (value & 2) != 0;
    }

    public static class Handler
    implements IMessageHandler<PacketSlotVisibility, IMessage> {
        public IMessage onMessage(PacketSlotVisibility message, MessageContext ctx) {
            Object conduit = message.getConduit(ctx);
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (conduit != null && player.field_71070_bA instanceof ExternalConnectionContainer) {
                ExternalConnectionContainer ecc = (ExternalConnectionContainer)player.field_71070_bA;
                ecc.setInOutSlotsVisible(message.filterVisible, message.upgradeVisible, (IConduit)conduit);
            }
            return null;
        }
    }
}

