/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.invpanel.client;

import crazypants.enderio.base.filter.item.IItemFilter;
import crazypants.enderio.invpanel.client.AbstractItemEntryFilter;
import crazypants.enderio.invpanel.client.CountComparator;
import crazypants.enderio.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.invpanel.client.ItemEntry;
import crazypants.enderio.invpanel.client.ModComparator;
import crazypants.enderio.invpanel.client.NameComparator;
import crazypants.enderio.invpanel.client.SortOrder;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;

public class DatabaseView {
    @Nonnull
    public static final Locale LOCALE;
    @Nonnull
    private final ArrayList<ItemEntry> filteredItems;
    private InventoryDatabaseClient database;
    private int dbItemsChangeCount;
    private int dbCountChangeCount;
    @Nonnull
    private SortOrder order = SortOrder.NAME;
    private boolean invertSortOrder;
    private boolean needsSorting;
    private IItemFilter itemFilter;
    @Nonnull
    private String currentFilter = "";
    private boolean needsFiltering;
    private boolean needsNewFiltering;
    private final Collator collator;

    public DatabaseView() {
        this.filteredItems = new ArrayList();
        this.collator = Collator.getInstance(LOCALE);
    }

    public void setDatabase(InventoryDatabaseClient database) {
        if (this.database != database) {
            this.database = database;
            if (database != null) {
                this.dbItemsChangeCount = database.getItemsChangeCount();
                this.dbCountChangeCount = database.getCountChangeCount();
            }
            this.needsSorting = true;
            this.needsFiltering = true;
            this.needsNewFiltering = true;
        }
    }

    public void setSortOrder(@Nonnull SortOrder order, boolean invert) {
        if (this.order != order || this.invertSortOrder != invert) {
            this.order = order;
            this.invertSortOrder = invert;
            this.needsSorting = true;
        }
    }

    public void setItemFilter(@Nullable IItemFilter itemFilter) {
        if (this.itemFilter != itemFilter) {
            this.itemFilter = itemFilter;
            this.needsNewFiltering = true;
            this.needsFiltering = true;
        }
    }

    public void updateFilter(@Nonnull String newFilter) {
        if (!this.currentFilter.equals(newFilter = newFilter.trim())) {
            if (newFilter.length() < this.currentFilter.length() || !newFilter.regionMatches(0, this.currentFilter, 0, this.currentFilter.length())) {
                this.needsNewFiltering = true;
            }
            this.needsFiltering = true;
            this.currentFilter = newFilter;
        }
    }

    @Nonnull
    public SortOrder getSortOrder() {
        return this.order;
    }

    public boolean isSortOrderInverted() {
        return this.invertSortOrder;
    }

    public boolean sortItems() {
        boolean changed = false;
        if (this.database != null) {
            if (this.dbItemsChangeCount != this.database.getItemsChangeCount()) {
                this.dbItemsChangeCount = this.database.getItemsChangeCount();
                this.needsSorting = true;
                this.needsFiltering = true;
                this.needsNewFiltering = true;
            }
            if (this.dbCountChangeCount != this.database.getCountChangeCount()) {
                this.dbCountChangeCount = this.database.getCountChangeCount();
                if (this.order == SortOrder.COUNT) {
                    this.needsSorting = true;
                }
            }
        }
        if (this.needsFiltering) {
            AbstractItemEntryFilter filter;
            if (this.needsNewFiltering) {
                this.filteredItems.clear();
                if (this.database != null) {
                    this.database.getItems(this.filteredItems);
                }
                this.needsSorting = true;
            }
            if ((filter = AbstractItemEntryFilter.parse(this.currentFilter, LOCALE, this.itemFilter)) != null) {
                Iterator<ItemEntry> iter = this.filteredItems.iterator();
                while (iter.hasNext()) {
                    ItemEntry entry = iter.next();
                    if (filter.matches(entry)) continue;
                    iter.remove();
                    changed = true;
                }
            }
            this.needsFiltering = false;
            this.needsNewFiltering = false;
        }
        if (this.needsSorting) {
            Comparator<ItemEntry> cmp;
            switch (this.order) {
                case NAME: {
                    cmp = new NameComparator(this.collator);
                    break;
                }
                case MOD: {
                    cmp = new ModComparator(this.collator);
                    break;
                }
                default: {
                    cmp = new CountComparator(this.collator);
                }
            }
            if (this.invertSortOrder) {
                cmp = Collections.reverseOrder(cmp);
            }
            Collections.sort(this.filteredItems, cmp);
            changed = true;
            this.needsSorting = false;
        }
        return changed;
    }

    public int getNumEntries() {
        return this.filteredItems.size();
    }

    public ItemEntry getItemEntry(int index) {
        return this.filteredItems.get(index);
    }

    static {
        String languageCode = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a();
        int idx = languageCode.indexOf(95);
        if (idx > 0) {
            String lang = languageCode.substring(0, idx);
            String country = languageCode.substring(idx + 1);
            LOCALE = new Locale(lang, country);
        } else {
            LOCALE = new Locale(languageCode);
        }
    }
}

