/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.util;

import com.enderio.core.common.util.NullHelper;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;

public class PropertyEnumExtendable<T extends Comparable<T> & IStringSerializable>
extends PropertyHelper<T> {
    @Nonnull
    private final Set<T> allowedValues = new HashSet<T>();
    @Nonnull
    private final Map<String, T> nameToValue = new HashMap<String, T>();
    @Nonnull
    private final Map<T, Integer> nameToOrder = new HashMap<T, Integer>();
    @Nonnull
    private final List<T> orderValues = new ArrayList<T>();
    private boolean locked = false;

    protected PropertyEnumExtendable(String name, Class<T> valueClass) {
        super(name, valueClass);
    }

    public void addValue(@Nonnull T value) {
        if (this.locked) {
            throw new RuntimeException("Cannot add values after this Property has been used");
        }
        String s = ((IStringSerializable)value).func_176610_l();
        if (this.nameToValue.containsKey(s)) {
            throw new IllegalArgumentException("Multiple values have the same name '" + s + "'");
        }
        this.allowedValues.add(value);
        this.nameToValue.put(s, value);
        this.nameToOrder.put(value, this.orderValues.size());
        this.orderValues.add(value);
    }

    @Nonnull
    public T byID(int id) {
        return (T)((Comparable)NullHelper.first((Object[])new Comparable[]{(Comparable)this.orderValues.get(MathHelper.func_76125_a((int)id, (int)0, (int)(this.orderValues.size() - 1))), (Comparable)this.orderValues.get(0)}));
    }

    public int byIdentity(T id) {
        return (Integer)NullHelper.first((Object[])new Integer[]{this.nameToOrder.get(id), 0});
    }

    public List<T> getOrderedValues() {
        this.locked = true;
        return this.orderValues;
    }

    @Nonnull
    public Collection<T> func_177700_c() {
        this.locked = true;
        return this.allowedValues;
    }

    @Nonnull
    public Optional<T> func_185929_b(@Nonnull String value) {
        return Optional.fromNullable(this.nameToValue.get(value));
    }

    @Nonnull
    public String func_177702_a(@Nonnull T value) {
        return ((IStringSerializable)value).func_176610_l();
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof PropertyEnumExtendable && super.equals(p_equals_1_)) {
            PropertyEnumExtendable propertyenum = (PropertyEnumExtendable)((Object)p_equals_1_);
            return this.allowedValues.equals(propertyenum.allowedValues) && this.nameToValue.equals(propertyenum.nameToValue);
        }
        return false;
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.allowedValues.hashCode();
        i = 31 * i + this.nameToValue.hashCode();
        return i;
    }

    @Nonnull
    public static <T extends Comparable<T> & IStringSerializable> PropertyEnumExtendable<T> create(@Nonnull String name, @Nonnull Class<T> clazz) {
        return new PropertyEnumExtendable<T>(name, clazz);
    }
}

