/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.blocks.BlockBamboo;
import erebus.blocks.BlockDoorErebus;
import erebus.blocks.BlockLeavesErebus;
import erebus.blocks.BlockLogErebus;
import erebus.blocks.BlockPlanksErebus;
import erebus.blocks.BlockSaplingErebus;
import erebus.blocks.BlockSlabErebus;
import erebus.blocks.BlockStairsErebus;
import erebus.blocks.BlockWoodFence;
import erebus.blocks.BlockWoodFenceGate;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.IStringSerializable;

public enum EnumWood implements IStringSerializable
{
    BAOBAB,
    EUCALYPTUS,
    MAHOGANY,
    MOSSBARK,
    ASPER,
    CYPRESS,
    BALSAM(true, true, true, true, false),
    WHITE(false, true, false, false, false),
    BAMBOO(true, true, true, false, false),
    ROTTEN(true, true, false, false, true),
    MARSHWOOD,
    SCORCHED(true, true, false, false, true),
    VARNISHED(false, true, false, false, false);

    private final boolean hasLog;
    private final boolean hasPlanks;
    private final boolean hasSapling;
    private final boolean hasLeaves;
    private final boolean hasDoor;
    private Block stairs;
    private Block log;
    private Block slab;
    private Block leaves;
    private Block sapling;
    private Block door;
    private Block fence;
    private Block gate;

    private EnumWood(boolean hasLog, boolean hasPlanks, boolean hasSapling, boolean hasLeaves, boolean hasDoor) {
        this.hasLog = hasLog;
        this.hasPlanks = hasPlanks;
        this.hasSapling = hasSapling;
        this.hasLeaves = hasLeaves;
        this.hasDoor = hasDoor;
    }

    private EnumWood() {
        this(true, true, true, true, true);
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ENGLISH);
    }

    public int getID() {
        return this.ordinal();
    }

    public boolean hasSapling() {
        return this.hasSapling;
    }

    public boolean hasPlanks() {
        return this.hasPlanks;
    }

    public boolean hasLog() {
        return this.hasLog;
    }

    public boolean hasLeaves() {
        return this.hasLeaves;
    }

    public boolean hasDoor() {
        return this.hasDoor;
    }

    public Block getStairs() {
        return this.stairs;
    }

    public Block getLog() {
        return this.log;
    }

    public Block getSlab() {
        return this.slab;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public Block getSapling() {
        return this.sapling;
    }

    public Block getDoor() {
        return this.door;
    }

    public Block getFence() {
        return this.fence;
    }

    public Block getGate() {
        return this.gate;
    }

    public static void init() {
        for (EnumWood wood : EnumWood.values()) {
            Object log;
            if (wood.hasLog && wood != BAMBOO) {
                log = new BlockLogErebus();
                ModBlocks.registerBlock("log_" + wood.func_176610_l(), (Block)log);
                wood.log = log;
            } else if (wood.hasLog && wood == BAMBOO) {
                log = new BlockBamboo();
                ModBlocks.registerBlock("log_" + wood.func_176610_l(), (Block)log);
                wood.log = log;
            }
            if (wood.hasSapling) {
                BlockSaplingErebus sapling = new BlockSaplingErebus(wood);
                ModBlocks.registerBlock("sapling_" + wood.func_176610_l(), (Block)sapling);
                wood.sapling = sapling;
            }
            if (wood.hasLeaves) {
                BlockLeavesErebus leaves = new BlockLeavesErebus(wood);
                ModBlocks.registerBlock("leaves_" + wood.func_176610_l(), (Block)leaves);
                wood.leaves = leaves;
            }
            if (!wood.hasPlanks) continue;
            Block stairs = BlockStairsErebus.createWooden(ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)wood)));
            ModBlocks.registerBlock("stairs_" + wood.func_176610_l(), stairs);
            wood.stairs = stairs;
            BlockSlabErebus slabs = new BlockSlabErebus(ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)wood)), "axe", 0);
            ModBlocks.registerBlock("slab_planks_" + wood.func_176610_l(), slabs);
            Blocks.field_150480_ab.func_180686_a((Block)slabs, 5, 5);
            wood.slab = slabs;
            if (wood.hasDoor) {
                BlockDoorErebus door = new BlockDoorErebus(ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)wood)), "axe", 0);
                ModBlocks.registerBlock("door_" + wood.func_176610_l(), (Block)door);
                wood.door = door;
            }
            BlockWoodFence fence = new BlockWoodFence(ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)wood)));
            ModBlocks.registerBlock("fence_" + wood.func_176610_l(), fence);
            wood.fence = fence;
            BlockWoodFenceGate fenceGate = new BlockWoodFenceGate(ModBlocks.PLANKS.func_176223_P().func_177226_a(BlockPlanksErebus.TYPE, (Comparable)((Object)wood)));
            ModBlocks.registerBlock("fence_gate_" + wood.func_176610_l(), (Block)fenceGate);
            wood.gate = fenceGate;
        }
    }
}

