/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import com.google.common.base.Optional;
import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.ai.EntityAIBlockFollowOwner;
import erebus.proxy.CommonProxy;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimatedBlock
extends EntityCreature
implements IEntityAdditionalSpawnData {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimatedBlock.class, (DataSerializer)DataSerializers.field_187203_m);
    public Block blockID;
    public int blockMeta;
    private int lastX = 0;
    private int lastY = 0;
    private int lastZ = 0;
    public EntityAIWander aiWander;
    public EntityAINearestAttackableTarget aiAttackNearestTarget;
    public EntityAIAttackMelee aiAttackOnCollide;

    public EntityAnimatedBlock(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.5f);
        this.setBlock(Blocks.field_150348_b, 0);
        this.field_70728_aV = 0;
    }

    public void setBlock(Block blockID, int blockMeta) {
        this.blockID = blockID;
        this.blockMeta = blockMeta;
        this.setCanBeTempted();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    protected void func_184651_r() {
        this.aiWander = new EntityAIWander((EntityCreature)this, 0.5);
        this.aiAttackNearestTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true);
        this.aiAttackOnCollide = new EntityAIAttackMelee((EntityCreature)this, 0.5, false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiAttackOnCollide);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiWander);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiAttackNearestTarget);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 10.0 : 10.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 2.0 : 2.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected Item func_146068_u() {
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K && this.field_70128_L) {
            Utils.dropStack(this.func_130014_f_(), this.func_180425_c(), new ItemStack(this.blockID, 1, this.blockMeta));
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K && this.isGlowingBlock(this.blockID, this.blockMeta)) {
            if (this.func_130014_f_().func_72971_b(1.0f) < 0.5f) {
                this.lightUp(this.func_130014_f_(), this.func_180425_c());
            } else {
                this.switchOff();
            }
        }
    }

    private boolean isGlowingBlock(Block blockID, int blockMeta) {
        if (blockID == Blocks.field_150428_aP) {
            return true;
        }
        if (blockID == Blocks.field_150374_bv) {
            return true;
        }
        if (blockID == Blocks.field_150426_aN) {
            return true;
        }
        return blockID == ModBlocks.RED_GEM && (blockMeta == 0 || blockMeta == 2);
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, BlockPos pos) {
        world.func_175653_a(EnumSkyBlock.BLOCK, pos, 9);
        for (int i = -2; i < 2; ++i) {
            for (int j = -2; j < 2; ++j) {
                for (int k = -2; k < 2; ++k) {
                    if (pos.func_177958_n() + i == this.lastX && pos.func_177956_o() + j == this.lastY && pos.func_177952_p() + k == this.lastZ && !this.field_70128_L) continue;
                    world.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.lastX + i, this.lastY + j, this.lastZ + k));
                    this.lastX = pos.func_177958_n();
                    this.lastY = pos.func_177956_o();
                    this.lastZ = pos.func_177952_p();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        this.func_130014_f_().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.lastX, this.lastY, this.lastZ));
        this.func_130014_f_().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)));
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_130014_f_().field_72995_K && this.isGlowingBlock(this.blockID, this.blockMeta)) {
            this.switchOff();
        }
    }

    public boolean isClimbing() {
        return !this.field_70122_E && this.func_70617_f_();
    }

    public boolean func_70617_f_() {
        return this.field_70123_F;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack is = player.field_71071_by.func_70448_g();
        if (!this.func_130014_f_().field_72995_K && !is.func_190926_b() && is.func_77973_b() == ModItems.WAND_OF_ANIMATION) {
            this.func_70106_y();
            this.func_130014_f_().func_180501_a(this.func_180425_c(), this.blockID.func_176203_a(this.blockMeta), 3);
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), ModSounds.ALTAR_OFFERING, SoundCategory.NEUTRAL, 0.2f, 1.0f);
            return true;
        }
        if (this.blockID == ModBlocks.PETRIFIED_CRAFTING_TABLE && is.func_190926_b()) {
            player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.PETRIFIED_CRAFT.ordinal(), player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        boolean atk = false;
        if (super.func_70652_k(entity)) {
            atk = entity instanceof EntityMob;
        }
        return atk;
    }

    public void setCanBeTempted() {
        if (this.blockID == ModBlocks.PETRIFIED_CRAFTING_TABLE) {
            this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIBlockFollowOwner(this, 1.0, 10.0f, 2.0f));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("blockID", Block.func_149682_b((Block)this.blockID));
        nbt.func_74768_a("blockMeta", this.blockMeta);
        if (this.getOwnerId() == null) {
            nbt.func_74778_a("OwnerUUID", "");
        } else {
            nbt.func_74778_a("OwnerUUID", this.getOwnerId().toString());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        String s;
        super.func_70037_a(nbt);
        this.blockID = Block.func_149729_e((int)nbt.func_74762_e("blockID"));
        this.blockMeta = nbt.func_74762_e("blockMeta");
        if (nbt.func_150297_b("OwnerUUID", 8)) {
            s = nbt.func_74779_i("OwnerUUID");
        } else {
            String s1 = nbt.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (!s.isEmpty()) {
            try {
                this.setOwnerId(UUID.fromString(s));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(Block.func_149682_b((Block)this.blockID));
        buffer.writeInt(this.blockMeta);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.blockID = Block.func_149729_e((int)buffer.readInt());
        this.blockMeta = buffer.readInt();
        this.setCanBeTempted();
    }

    @Nullable
    public UUID getOwnerId() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID)).orNull();
    }

    public void setOwnerId(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.fromNullable((Object)uuid));
    }

    @Nullable
    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            return uuid == null ? null : this.func_130014_f_().func_152378_a(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public boolean belongsTo(EntityLivingBase entity) {
        return entity == this.getOwner();
    }
}

