/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.Erebus;
import erebus.ModItems;
import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.entity.ai.EntityAIErebusAttackMelee;
import erebus.entity.ai.EntityAIFlyingWander;
import erebus.entity.ai.FlyingMoveHelper;
import erebus.entity.ai.PathNavigateFlying;
import erebus.items.ItemMaterials;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityDragonfly
extends EntityMob {
    public double pickupHeight;
    private boolean dropped;
    private int droptime = 0;
    private int countDown;
    private static final DataParameter<Integer> SKIN_TYPE = EntityDataManager.func_187226_a(EntityDragonfly.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityDragonfly(World world) {
        super(world);
        this.func_70105_a(2.5f, 1.0f);
        this.field_70765_h = new FlyingMoveHelper((EntityCreature)this);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKIN_TYPE, (Object)this.field_70146_Z.nextInt(51));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIErebusAttackMelee((EntityCreature)this, 0.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFlyingWander((EntityCreature)this, 1.0, 1));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(ConfigHandler.INSTANCE.mobAttackDamageMultiplier < 2 ? 1.0 : 1.0 * (double)ConfigHandler.INSTANCE.mobAttackDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateFlying((EntityLiving)this, world);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entity) {
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean captured() {
        return this.func_184207_aI();
    }

    private void setCountdown(int count) {
        this.countDown = count;
    }

    private void setDropped(boolean dropstate) {
        this.dropped = dropstate;
    }

    public boolean getDropped() {
        return this.dropped;
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.5f;
    }

    public SoundEvent func_184639_G() {
        return ModSounds.FLY_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.FLY_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.3;
        }
        if (this.func_184207_aI()) {
            if (this.func_70638_az() != null && !this.func_130014_f_().func_175623_d(this.func_180425_c().func_177979_c(3)) || !this.getDropped() && (double)this.func_180425_c().func_177956_o() < this.pickupHeight + 10.0) {
                this.func_70661_as().func_75499_g();
                this.func_70661_as().func_75492_a(this.field_70165_t, this.field_70163_u + 10.0, this.field_70161_v, 1.0);
                this.field_70181_x += 0.08;
            }
            if (!this.func_130014_f_().field_72995_K && this.captured() && (this.field_70163_u > this.pickupHeight + 10.0 || this.countDown <= 0 || !this.func_130014_f_().field_72995_K && this.captured() && this.func_130014_f_().isSideSolid(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v)), EnumFacing.DOWN))) {
                this.setDropped(true);
                this.func_184226_ay();
            }
        }
        if (this.dropped) {
            ++this.droptime;
            if (this.droptime >= 20) {
                this.setDropped(false);
                this.droptime = 0;
            }
        }
        if (this.countDown >= 0) {
            --this.countDown;
        }
        if (this.func_130014_f_().field_72995_K && this.getSkin() == 0) {
            this.spawnParticles(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z);
            if (!this.func_145818_k_()) {
                this.func_96094_a("Ender Dragonfly");
            }
        }
        if (this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 0.32);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 20; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextInt(2) * 2 - 1;
            int motionZ = rand.nextInt(2) * 2 - 1;
            velY = ((double)rand.nextFloat() - 0.5) * 0.125;
            velZ = rand.nextFloat() * 1.0f * (float)motionZ;
            velX = rand.nextFloat() * 1.0f * (float)motionX;
            Erebus.PROXY.spawnCustomParticle("portal", this.func_130014_f_(), x, y, z, velX, velY, velZ);
        }
    }

    public void func_70100_b_(EntityPlayer player) {
        super.func_70100_b_(player);
        if (ConfigHandler.INSTANCE.dragonflyGrab) {
            if (player.func_70093_af()) {
                player.func_70095_a(false);
            }
            if (!(this.func_130014_f_().field_72995_K || player.field_71075_bZ.field_75098_d || this.captured() || this.field_70146_Z.nextInt(20) != 0 || this.getDropped())) {
                player.func_184205_a((Entity)this, true);
                this.pickupHeight = this.field_70163_u;
                this.func_70107_b(this.field_70165_t, player.field_70163_u + this.func_70033_W(), this.field_70161_v);
                this.setCountdown(60);
            }
        }
    }

    public double func_70033_W() {
        if (this.getCapturedPlayer() != null) {
            return this.getCapturedPlayer().field_70131_O;
        }
        return super.func_70033_W();
    }

    public EntityPlayer getCapturedPlayer() {
        for (Entity entity : this.func_184188_bt()) {
            if (!(entity instanceof EntityPlayer)) continue;
            return (EntityPlayer)entity;
        }
        return null;
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLivingBase) {
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * -0.6;
            double offSetZ = Math.cos(a) * -0.6;
            entity.func_70107_b(this.field_70165_t - offSetX, this.field_70163_u - this.func_70033_W(), this.field_70161_v - offSetZ);
            if (entity.func_70093_af()) {
                entity.func_70095_a(false);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amp) {
        if (this.func_190530_aW()) {
            return false;
        }
        if (super.func_70097_a(source, amp)) {
            Entity entity = source.func_76346_g();
            if (this.func_184207_aI() && this.getCapturedPlayer() != null) {
                if (entity == this.getCapturedPlayer()) {
                    this.setDropped(true);
                }
                this.func_184226_ay();
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() > 100) {
            return false;
        }
        int lightValue = this.field_70170_p.func_175671_l(blockpos);
        return lightValue > this.field_70146_Z.nextInt(7) ? false : this.func_70058_J() && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 6;
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        this.func_70099_a(new ItemStack(ModItems.MATERIALS, 1, ItemMaterials.EnumErebusMaterialsType.DRAGONFLY_WING.ordinal()), 0.0f);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70099_a(new ItemStack(ModItems.MATERIALS, this.field_70146_Z.nextInt(1) + 1 + looting, ItemMaterials.EnumErebusMaterialsType.COMPOUND_EYES.ordinal()), 0.0f);
        }
        if (this.getSkin() == 0) {
            this.func_70099_a(new ItemStack(Items.field_151079_bi, this.field_70146_Z.nextInt(1) + 1 + looting), 0.0f);
        }
    }

    public boolean func_70652_k(Entity entity) {
        return super.func_70652_k(entity);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setSkin(this.field_70146_Z.nextInt(51));
        return super.func_180482_a(difficulty, livingdata);
    }

    public void setSkin(int skinType) {
        this.field_70180_af.func_187227_b(SKIN_TYPE, (Object)skinType);
    }

    public int getSkin() {
        return (Integer)this.field_70180_af.func_187225_a(SKIN_TYPE);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("dragonflySkin", this.getSkin());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setSkin(nbt.func_74762_e("dragonflySkin"));
    }
}

