/*
 * Decompiled with CFR 0.152.
 */
package erebus.entity;

import erebus.ModSounds;
import erebus.core.handler.configs.ConfigHandler;
import erebus.items.ItemMaterials;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGlowWorm
extends EntityCreature {
    public int lastX;
    public int lastY;
    public int lastZ;
    private boolean triggerOnce;
    private static final DataParameter<Byte> TRIGGRED = EntityDataManager.func_187226_a(EntityGlowWorm.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityGlowWorm(World world) {
        super(world);
        this.func_70105_a(1.5f, 0.5f);
        this.field_70138_W = 0.0f;
        this.field_70178_ae = true;
        this.func_184644_a(PathNodeType.WATER, -8.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)0.7f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TRIGGRED, (Object)new Byte(0));
    }

    public boolean func_70601_bi() {
        float light = this.func_70013_c();
        if (light >= 0.0f) {
            return this.func_70058_J();
        }
        return super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 2;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.INSTANCE.mobHealthMultipier < 2 ? 15.0 : 15.0 * (double)ConfigHandler.INSTANCE.mobHealthMultipier);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.GLOW_WORM_SOUND;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSounds.GLOW_WORM_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.SQUISH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187823_fN, 0.15f, 1.0f);
    }

    protected void func_70628_a(boolean recentlyHit, int looting) {
        int chance = this.field_70146_Z.nextInt(4) + this.field_70146_Z.nextInt(1 + looting);
        for (int amount = 0; amount < chance; ++amount) {
            this.func_70099_a(ItemMaterials.EnumErebusMaterialsType.BIO_LUMINESCENCE.createStack(), 0.0f);
        }
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            this.findNearEntity();
        }
        if (this.func_130014_f_().field_72995_K && this.func_184202_aL()) {
            this.lightUp(this.func_130014_f_(), this.func_180425_c());
        }
        if (this.func_130014_f_().field_72995_K && !this.func_184202_aL()) {
            this.switchOff();
        }
        super.func_70071_h_();
    }

    @SideOnly(value=Side.CLIENT)
    private void lightUp(World world, BlockPos pos) {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        world.func_175653_a(EnumSkyBlock.BLOCK, pos, 9);
        for (int i = -2; i < 2; ++i) {
            for (int j = -2; j < 2; ++j) {
                for (int k = -2; k < 2; ++k) {
                    if (pos.func_177958_n() + i == this.lastX && pos.func_177956_o() + j == this.lastY && pos.func_177952_p() + k == this.lastZ && !this.field_70128_L) continue;
                    world.func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.lastX + i, this.lastY + j, this.lastZ + k));
                    this.lastX = pos.func_177958_n();
                    this.lastY = pos.func_177956_o();
                    this.lastZ = pos.func_177952_p();
                }
            }
        }
        this.triggerOnce = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void switchOff() {
        if (!ConfigHandler.INSTANCE.bioluminescence) {
            return;
        }
        if (this.triggerOnce) {
            this.func_130014_f_().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(this.lastX, this.lastY, this.lastZ));
            this.func_130014_f_().func_180500_c(EnumSkyBlock.BLOCK, new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)));
            this.triggerOnce = false;
        }
    }

    protected Entity findNearEntity() {
        List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.func_174813_aQ().func_72314_b(6.0, 6.0, 6.0));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (entity == null || this.getIsNearEntity()) continue;
            this.setIsNearEntity(true);
        }
        if (list.isEmpty() && this.getIsNearEntity()) {
            this.setIsNearEntity(false);
        }
        return null;
    }

    public boolean func_184202_aL() {
        return this.func_130014_f_().field_72995_K && this.func_130014_f_().func_72971_b(1.0f) < 0.5f && this.getIsNearEntity();
    }

    public void setIsNearEntity(boolean entityNear) {
        this.field_70180_af.func_187227_b(TRIGGRED, (Object)(entityNear ? (byte)1 : 0));
    }

    public boolean getIsNearEntity() {
        return (Byte)this.field_70180_af.func_187225_a(TRIGGRED) == 1;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.func_130014_f_().field_72995_K) {
            this.switchOff();
        }
    }
}

