/*
 * Decompiled with CFR 0.152.
 */
package erebus.tileentity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class TileEntityBasicInventory
extends TileEntity
implements ISidedInventory {
    public NonNullList<ItemStack> inventory;
    public IItemHandler itemHandler;
    private final String name;

    public TileEntityBasicInventory(int invtSize, String name) {
        this.setInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)invtSize, (Object)ItemStack.field_190927_a));
        this.name = name;
    }

    public int func_70302_i_() {
        return this.getInventory().size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.getInventory().get(slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.getInventory();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.getInventory(), (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        this.getInventory().set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.getInventory()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.loadFromNbt(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        return this.saveToNbt(compound);
    }

    public void loadFromNbt(NBTTagCompound compound) {
        this.setInventory((NonNullList<ItemStack>)NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a));
        if (compound.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.getInventory());
        }
    }

    public NBTTagCompound saveToNbt(NBTTagCompound compound) {
        ItemStackHelper.func_191281_a((NBTTagCompound)compound, this.getInventory(), (boolean)false);
        return compound;
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.getInventory().clear();
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public boolean canInsertItem() {
        return true;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public void setInventory(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((IInventory)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = this.createUnSidedHandler()) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }
}

