/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.inventory.container.TileInventoryContainer;
import org.cyclops.evilcraft.core.tileentity.TickingTankInventoryTileEntity;
import org.cyclops.evilcraft.core.tileentity.tickaction.TickComponent;

public class TickingTankInventoryContainer<T extends TickingTankInventoryTileEntity<T>>
extends TileInventoryContainer<T> {
    private final List<Supplier<Integer>> variablesMaxProgress = Lists.newArrayList();
    private final List<Supplier<Integer>> variablesProgress = Lists.newArrayList();
    private final Supplier<FluidStack> variableFluidStack;
    private final Supplier<Integer> variableFluidCapacity;

    public TickingTankInventoryContainer(InventoryPlayer inventory, T tile) {
        super(inventory, tile);
        for (TickComponent tickComponent : ((TickingTankInventoryTileEntity)((Object)tile)).getTickers()) {
            this.variablesMaxProgress.add(this.registerSyncedVariable(Integer.class, () -> (int)ticker.getRequiredTicks()));
            this.variablesProgress.add(this.registerSyncedVariable(Integer.class, tickComponent::getTick));
        }
        this.variableFluidStack = this.registerSyncedVariable(FluidStack.class, () -> ((TickingTankInventoryTileEntity)this.getTile()).getTank().getFluid());
        this.variableFluidCapacity = this.registerSyncedVariable(Integer.class, () -> ((TickingTankInventoryTileEntity)this.getTile()).getTank().getCapacity());
    }

    public int getMaxProgress(int ticker) {
        return this.variablesMaxProgress.get(ticker).get();
    }

    public int getProgress(int ticker) {
        return this.variablesProgress.get(ticker).get();
    }

    @Nullable
    public FluidStack getFluidStack() {
        return this.variableFluidStack.get();
    }

    public int getFluidCapacity() {
        return this.variableFluidCapacity.get();
    }
}

