/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.config;

import com.blakebr0.extendedcrafting.item.ModItems;
import java.io.File;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    public static Configuration config;
    public static ModConfig instance;
    public static boolean confGuideEnabled;
    public static boolean confHandheldTableEnabled;
    public static boolean confEnergyInWaila;
    public static boolean confCraftingCoreEnabled;
    public static int confCraftingCoreRFCapacity;
    public static int confCraftingCoreRFRate;
    public static boolean confCraftingCoreAcceptGTEU;
    public static boolean confInterfaceEnabled;
    public static int confInterfaceRFCapacity;
    public static int confInterfaceRFRate;
    public static boolean confInterfaceAcceptGTEU;
    public static boolean confInterfaceRenderer;
    public static boolean confTableEnabled;
    public static boolean confTableUseRecipes;
    public static boolean confCompressorEnabled;
    public static int confCompressorRFCapacity;
    public static int confCompressorRFRate;
    public static boolean confCompressorAcceptGTEU;
    public static boolean confCompressorRenderer;
    public static boolean confEnderEnabled;
    public static int confEnderTimeRequired;
    public static float confEnderAlternatorEff;
    public static boolean confRMEnabled;
    public static boolean confRMOredict;
    public static boolean confRMNBT;
    public static boolean confSingularityEnabled;
    public static int confSingularityAmount;
    public static int confSingularityRF;
    public static boolean confSingularityRecipes;
    public static boolean confUltimateSingularityRecipe;
    public static String confSingularityCatalyst;
    public static int confEUtoRF;

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("extendedcrafting")) {
            ModConfig.init();
        }
    }

    public static void init(File file) {
        config = new Configuration(file);
        config.load();
        ModConfig.init();
    }

    public static void init() {
        ModConfig.updateConfig();
        String category = "general";
        config.setCategoryComment(category, "Settings for general things.");
        confGuideEnabled = config.getBoolean("guide_enabled", category, true, "Should the In-Game Guide Book be enabled?");
        confHandheldTableEnabled = config.getBoolean("handheld_table_enabled", category, true, "Should the Handheld Crafting Table be enabled?");
        confEnergyInWaila = config.getBoolean("energy_in_waila", category, true, "Should WAILA show the current energy of Extended Crafting machines?");
        category = "combination_crafting";
        config.setCategoryComment(category, "Settings for the Crafting Core.");
        confCraftingCoreEnabled = config.getBoolean("enabled", category, true, "Should the Crafting Core and Pedestal be enabled?");
        confCraftingCoreRFCapacity = config.getInt("energy_capacity", category, 5000000, 0, Integer.MAX_VALUE, "How much FE the Crafting Core should hold.");
        confCraftingCoreRFRate = config.getInt("energy_rate", category, 500, 0, Integer.MAX_VALUE, "How much FE/t the Crafting Core should use when crafting by default.");
        confCraftingCoreAcceptGTEU = config.getBoolean("accept_gteu", category, false, "Should the Crafting Core accept GTEU?");
        category = "automation_interface";
        config.setCategoryComment(category, "Settings for the Automation Interface.");
        confInterfaceEnabled = config.getBoolean("enabled", category, true, "Should the Automation Interface be enabled?");
        confInterfaceRFCapacity = config.getInt("energy_capacity", category, 1000000, 0, Integer.MAX_VALUE, "How much FE the Automation Interface should hold.");
        confInterfaceRFRate = config.getInt("energy_rate", category, 80, 0, 100000, "How much FE the Automation Interface should use when moving items.");
        confInterfaceAcceptGTEU = config.getBoolean("accept_gteu", category, false, "Should the Automation Interface accept GTEU?");
        confInterfaceRenderer = config.getBoolean("render_item", category, true, "Should the Automation Interface render the result item inside it?");
        category = "table_crafting";
        config.setCategoryComment(category, "Settings for the Extended Crafting Tables.");
        confTableEnabled = config.getBoolean("enabled", category, true, "Should the Extended Crafting Tables be enabled?");
        confTableUseRecipes = config.getBoolean("inherit_vanilla_recipes", category, true, "Should the Basic Crafting Table inherit normal crafting recipes?");
        category = "quantum_compression";
        config.setCategoryComment(category, "Settings for the Quantum Compressor.");
        confCompressorEnabled = config.getBoolean("enabled", category, true, "Should the Quantum Compressor be enabled?");
        confCompressorRFCapacity = config.getInt("energy_capacity", category, 10000000, 0, Integer.MAX_VALUE, "How much FE the Quantum Compressor should hold.");
        confCompressorRFRate = config.getInt("energy_rate", category, 5000, 0, Integer.MAX_VALUE, "How much FE/t the Quantum Compressor should use when crafting by default.");
        confCompressorAcceptGTEU = config.getBoolean("accept_gteu", category, false, "Should the Quantum Compressor accept GTEU?");
        confCompressorRenderer = config.getBoolean("render_item", category, true, "Should the Quantum Compressor render the result item above it?");
        category = "ender_crafting";
        config.setCategoryComment(category, "Settings for the Ender Crafter.");
        confEnderEnabled = config.getBoolean("enabled", category, true, "Should the Ender Crafter and Ender Alternator be enabled?");
        confEnderTimeRequired = config.getInt("time_required", category, 60, 1, Integer.MAX_VALUE, "How many seconds each craft should take.");
        confEnderAlternatorEff = config.getFloat("alternator_effectiveness", category, 0.01f, 0.0f, 1.0f, "How much an Ender Alternator should speed up a craft. This is the percentage of time_required.");
        category = "recipe_maker";
        config.setCategoryComment(category, "Settings for the Recipe Maker.");
        confRMEnabled = config.getBoolean("enabled", category, true, "Should the Recipe Maker be enabled?");
        confRMOredict = config.getBoolean("use_oredictionary", category, true, "Should the Recipe Maker use OreDictionary entries when applicable?");
        confRMNBT = config.getBoolean("use_nbt", category, false, "Should the Recipe Maker also copy the NBT of the ingredients?");
        category = "singularity";
        config.setCategoryComment(category, "Settings for the Singularities.");
        confSingularityEnabled = config.getBoolean("enabled", category, true, "Should the Singularities be enabled?");
        confSingularityAmount = config.getInt("material_amount", category, 10000, 1, Integer.MAX_VALUE, "The amount of materials required to create a Singularity, for the default recipes.");
        confSingularityRF = config.getInt("energy_cost", category, 5000000, 0, Integer.MAX_VALUE, "The amount of RF required to craft a Singularity, for the default recipes.");
        confSingularityCatalyst = config.getString("default_catalyst", category, "extendedcrafting:material:11", "The catalyst required for the default Singularity recipes. modid:itemid:metadata");
        confSingularityRecipes = config.getBoolean("default_recipes", category, true, "Should the default Singularity recipes be enabled?");
        confUltimateSingularityRecipe = config.getBoolean("ultimate_singularity_recipe", category, true, "Should the default Ultimate Singularity recipe be enabled?");
        ModItems.itemSingularityCustom.configure(config);
        ModItems.itemSingularityUltimate.configure(config);
        category = "gregtech";
        config.setCategoryComment(category, "Settings for GregTech compatibility.");
        confEUtoRF = config.getInt("conversion", category, 4, 1, Integer.MAX_VALUE, "How much RF should one GTEU be handled as?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void updateConfig() {
        if (config.hasCategory("settings")) {
            ModConfig.updateProperty("crafting_core_rf_capacity", "energy_capacity", "combination_crafting");
            ModConfig.updateProperty("crafting_core_rf_rate", "energy_rate", "combination_crafting");
            ModConfig.updateProperty("compressor_rf_capacity", "energy_capacity", "quantum_compression");
            ModConfig.updateProperty("compressor_rf_rate", "energy_rate", "quantum_compression");
            ModConfig.updateProperty("interface_rf_capacity", "energy_capacity", "automation_interface");
            ModConfig.updateProperty("interface_rf_rate", "energy_rate", "automation_interface");
            ConfigCategory settings = config.getCategory("settings");
            settings.remove((Object)"compressor_item_rate");
            config.removeCategory(settings);
            config.renameProperty("recipe_maker", "recipe_maker_oredict", "use_oredictionary");
            config.renameProperty("recipe_maker", "recipe_maker_nbt", "use_nbt");
            config.renameProperty("singularity", "_singularity_amount", "material_amount");
            config.renameProperty("singularity", "_singularity_rf", "energy_cost");
            config.renameProperty("singularity", "_singularity_catalyst", "default_catalyst");
            config.renameProperty("singularity", "_singularity_recipes", "default_recipes");
            config.renameProperty("singularity", "_ultimate_singularity_recipe", "ultimate_singularity_recipe");
            config.renameProperty("singularity", "_custom_singularities", "custom_singularities");
            config.renameProperty("singularity", "_ultimate_blacklist", "ultimate_singularity_recipe_blacklist");
        }
    }

    private static void updateProperty(String oldName, String newName, String newCategory) {
        config.moveProperty("settings", oldName, newCategory);
        config.renameProperty(newCategory, oldName, newName);
    }

    public static boolean removeSingularity(String name) {
        boolean value = config.get("singularity", name, true).getBoolean();
        config.getCategory("singularity").remove((Object)name);
        return value;
    }
}

