/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.api.crafting.impl;

import com.zeitheron.hammercore.api.EnergyUnit;
import com.zeitheron.hammercore.api.crafting.IBaseIngredient;
import com.zeitheron.hammercore.api.crafting.ICraftingResult;
import com.zeitheron.hammercore.api.crafting.INameableRecipe;
import com.zeitheron.hammercore.api.crafting.impl.EnergyIngredient;
import com.zeitheron.hammercore.api.crafting.impl.FluidStackIngredient;
import com.zeitheron.hammercore.api.crafting.impl.FluidStackResult;
import com.zeitheron.hammercore.api.crafting.impl.ForgeEnergyResult;
import com.zeitheron.hammercore.api.crafting.impl.ItemStackResult;
import com.zeitheron.hammercore.api.crafting.impl.MCIngredient;
import com.zeitheron.hammercore.utils.charging.fe.FECharge;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreIngredient;

public class BaseNameableRecipe
implements INameableRecipe {
    public final ResourceLocation id;
    public final ICraftingResult<?> output;
    public final NonNullList<IBaseIngredient> ingredients;

    public BaseNameableRecipe(ResourceLocation id, ICraftingResult<?> output, NonNullList<IBaseIngredient> ingredients) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
    }

    @Override
    public ResourceLocation getRecipeName() {
        return this.id;
    }

    @Override
    public NonNullList<IBaseIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ICraftingResult<?> getResult() {
        return this.output;
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static class Builder {
        private final ResourceLocation id;
        private final NonNullList<Ingredient> inputItems = NonNullList.func_191196_a();
        private final NonNullList<FluidStack> inputFluid = NonNullList.func_191196_a();
        private ICraftingResult<?> output;
        private double RF;

        public Builder(ResourceLocation id) {
            if (id == null) {
                throw new IllegalArgumentException("Recipe id must not be null!");
            }
            this.id = id;
        }

        public Builder addInput(Ingredient ing) {
            this.inputItems.add((Object)ing);
            return this;
        }

        public Builder addInput(String oredict) {
            this.inputItems.add((Object)new OreIngredient(oredict));
            return this;
        }

        public Builder addInput(FluidStack stack) {
            this.inputFluid.add((Object)stack);
            return this;
        }

        public Builder setEnergy(double amount, EnergyUnit unit) {
            this.RF = unit.getInRF(amount);
            return this;
        }

        public Builder addEnergy(double amount, EnergyUnit unit) {
            this.RF += unit.getInRF(amount);
            return this;
        }

        public Builder withOutput(ItemStack stack) {
            this.output = new ItemStackResult(stack);
            return this;
        }

        public Builder withOutput(FluidStack stack) {
            this.output = new FluidStackResult(stack);
            return this;
        }

        public Builder withOutput(int FE) {
            this.output = new ForgeEnergyResult(new FECharge(FE));
            return this;
        }

        public Builder withOutput(ICraftingResult<?> stack) {
            this.output = stack;
            return this;
        }

        public double getEnergy(EnergyUnit unit) {
            return unit.getFromRF(this.RF);
        }

        public BaseNameableRecipe build() {
            NonNullList ings = NonNullList.func_191196_a();
            if (this.RF > 0.0) {
                ings.add((Object)new EnergyIngredient(this.RF, EnergyUnit.RF));
            }
            for (FluidStack stack : this.inputFluid) {
                ings.add((Object)new FluidStackIngredient(stack));
            }
            for (Ingredient ing : this.inputItems) {
                ings.add((Object)new MCIngredient(ing));
            }
            return new BaseNameableRecipe(this.id, this.output, (NonNullList<IBaseIngredient>)ings);
        }
    }
}

