/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.model.mc;

import com.google.common.collect.ImmutableMap;
import com.zeitheron.hammercore.HammerCore;
import com.zeitheron.hammercore.client.utils.GLList;
import com.zeitheron.hammercore.client.utils.UtilsFX;
import com.zeitheron.hammercore.client.utils.rendering.WavefrontLoader;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public class ModelRendererWavefront
extends ModelRenderer {
    private boolean compiled;
    private GLList list;
    private final Map<String, Object> renderProperties;
    public final WavefrontLoader.WavefrontMeshProvider meshProvider;
    public float scale = 0.0f;
    private final ResourceLocation texture;
    UUID renderedUUID;

    public ModelRendererWavefront(ModelBase model, WavefrontLoader.WavefrontMeshProvider meshProvider) {
        this(model, meshProvider, (ResourceLocation)null);
    }

    public ModelRendererWavefront(ModelBase model, WavefrontLoader.WavefrontMeshProvider meshProvider, ResourceLocation texture) {
        this(model, meshProvider, texture, null);
    }

    public ModelRendererWavefront(ModelBase model, WavefrontLoader.WavefrontMeshProvider meshProvider, TextureAtlasSprite sprite) {
        this(model, meshProvider, (ResourceLocation)(sprite != null ? TextureMap.field_110575_b : null), (Map<String, Object>)(sprite != null ? ImmutableMap.builder().put((Object)"uvTransformer", WavefrontLoader.transformUVToSprite(sprite)).build() : null));
    }

    public ModelRendererWavefront(ModelBase model, WavefrontLoader.WavefrontMeshProvider meshProvider, @Nullable ResourceLocation texture, @Nullable Map<String, Object> renderProperties) {
        super(model);
        this.meshProvider = meshProvider;
        this.renderProperties = renderProperties;
        this.texture = texture;
    }

    public void func_78785_a(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            this.compileDisplayList(scale);
            GlStateManager.func_179109_b((float)this.field_82906_o, (float)this.field_82908_p, (float)this.field_82907_q);
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c == 0.0f && this.field_78797_d == 0.0f && this.field_78798_e == 0.0f) {
                    this.render();
                } else {
                    GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                    this.render();
                    GlStateManager.func_179109_b((float)(-this.field_78800_c * scale), (float)(-this.field_78797_d * scale), (float)(-this.field_78798_e * scale));
                }
            } else {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
                this.render();
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179109_b((float)(-this.field_82906_o), (float)(-this.field_82908_p), (float)(-this.field_82907_q));
        }
    }

    public void render() {
        if (this.texture != null) {
            UtilsFX.bindTexture(this.texture);
        }
        this.list.render();
    }

    private void compileDisplayList(float scale) {
        if (this.compiled) {
            WavefrontLoader.WavefrontMesh mesh;
            if (this.renderedUUID != null && (mesh = this.meshProvider.getMesh()) != null && !this.renderedUUID.equals(mesh.getUniqueId())) {
                this.compiled = false;
            } else {
                return;
            }
        }
        if (this.scale == 0.0f) {
            this.scale = scale;
        }
        if (this.meshProvider.getMesh() == null) {
            this.compiled = true;
            HammerCore.LOG.error("Wavefront Mesh could not be parsed!!! The model is broken!");
            return;
        }
        if (this.list == null) {
            this.list = new GLList();
        }
        this.list.store(this.meshProvider.withSurprocessor(props -> {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)this.scale);
            GlStateManager.func_179114_b((float)180.0f, (float)-1.0f, (float)0.0f, (float)1.0f);
        }, props -> GlStateManager.func_179121_F()), this.renderProperties);
        this.compiled = true;
        this.renderedUUID = this.meshProvider.getMesh().getUniqueId();
    }

    public void func_78791_b(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
            if (this.field_78796_g != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (this.field_78795_f != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            if (this.field_78808_h != 0.0f) {
                GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.list.render();
            GlStateManager.func_179121_F();
        }
    }

    public void func_78794_c(float scale) {
        if (!this.field_78807_k && this.field_78806_j) {
            if (this.field_78795_f == 0.0f && this.field_78796_g == 0.0f && this.field_78808_h == 0.0f) {
                if (this.field_78800_c != 0.0f || this.field_78797_d != 0.0f || this.field_78798_e != 0.0f) {
                    GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                }
            } else {
                GlStateManager.func_179109_b((float)(this.field_78800_c * scale), (float)(this.field_78797_d * scale), (float)(this.field_78798_e * scale));
                if (this.field_78808_h != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78808_h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                }
                if (this.field_78796_g != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78796_g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                if (this.field_78795_f != 0.0f) {
                    GlStateManager.func_179114_b((float)(this.field_78795_f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
        }
    }

    public void dispose() {
        if (this.list != null) {
            this.list.delete();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

