/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import org.cyclops.cyclopscore.client.gui.component.input.GuiTextFieldExtended;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElement;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchType;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeRecipeValueChangedPacket;

public class ValueTypeRecipeLPElement
extends ValueTypeLPElementBase {
    @SideOnly(value=Side.CLIENT)
    private SubGuiRenderPattern lastGui;
    private NonNullList<Pair<ItemStack, ItemMatchType>> inputStacks;
    private ItemStack inputFluid;
    private String inputFluidAmount = "0";
    private String inputEnergy = "0";
    private NonNullList<ItemStack> outputStacks;
    private ItemStack outputFluid;
    private String outputFluidAmount = "0";
    private String outputEnergy = "0";

    public static ItemMatchType getDefaultItemMatch() {
        return ItemMatchType.ITEMMETA;
    }

    public ValueTypeRecipeLPElement() {
        super(ValueTypes.OBJECT_RECIPE);
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.RECIPE;
    }

    @Override
    public void onInputSlotUpdated(int slotId, ItemStack itemStack) {
        int amount;
        if (this.inputStacks == null) {
            return;
        }
        if (slotId >= 0 && slotId < 9) {
            this.inputStacks.set(slotId, (Object)Pair.of((Object)itemStack.func_77946_l(), (Object)((Pair)this.inputStacks.get(slotId)).getRight()));
        }
        if (slotId == 9) {
            this.inputFluid = itemStack.func_77946_l();
            if (this.inputFluidAmount.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.inputFluid));
                this.inputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSide() && this.lastGui != null) {
                    this.refreshInputFluidAmountBox();
                }
            }
        }
        if (slotId > 9 && slotId < 13) {
            this.outputStacks.set(slotId - 10, (Object)itemStack.func_77946_l());
        }
        if (slotId == 13) {
            this.outputFluid = itemStack.func_77946_l();
            if (this.outputFluidAmount.equalsIgnoreCase("0")) {
                amount = FluidHelpers.getAmount((FluidStack)Helpers.getFluidStack(this.outputFluid));
                this.outputFluidAmount = Integer.toString(amount);
                if (MinecraftHelpers.isClientSide() && this.lastGui != null) {
                    this.refreshOutputFluidAmountBox();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void refreshInputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.getInputFluidAmountBox() != null) {
            this.lastGui.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void refreshOutputFluidAmountBox() {
        if (this.lastGui != null && this.lastGui.getOutputFluidAmountBox() != null) {
            this.lastGui.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
        }
    }

    public boolean isValidForRecipeGrid(List<ItemStack> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        return itemInputs.size() <= 9 && itemOutputs.size() <= 3 && fluidInputs.size() <= 1 && fluidOutputs.size() <= 1;
    }

    protected void putStackInContainer(ContainerLogicProgrammerBase container, int slot, ItemStack itemStack) {
        container.func_75141_a(container.field_75151_b.size() - 50 + slot, itemStack);
    }

    /*
     * WARNING - void declaration
     */
    public void setRecipeGrid(ContainerLogicProgrammerBase container, List<ItemStack> itemInputs, List<FluidStack> fluidInputs, List<ItemStack> itemOutputs, List<FluidStack> fluidOutputs) {
        void var8_12;
        int slot = 0;
        for (ItemStack itemStack : itemInputs) {
            this.putStackInContainer(container, slot, itemStack);
            ++slot;
        }
        while (slot < 9) {
            this.putStackInContainer(container, slot, ItemStack.field_190927_a);
            ++slot;
        }
        slot = 9;
        FluidStack fluidStackInput = null;
        if (fluidInputs.size() > 0) {
            fluidStackInput = fluidInputs.get(0);
        }
        this.putStackInContainer(container, slot, fluidStackInput == null ? ItemStack.field_190927_a : this.getFluidBucket(fluidStackInput));
        this.inputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)fluidStackInput));
        if (MinecraftHelpers.isClientSide()) {
            this.refreshInputFluidAmountBox();
        }
        slot = 10;
        for (ItemStack itemOutput : itemOutputs) {
            this.putStackInContainer(container, slot, itemOutput);
            ++slot;
        }
        while (slot < 13) {
            this.putStackInContainer(container, slot, ItemStack.field_190927_a);
            ++slot;
        }
        slot = 13;
        Object var8_10 = null;
        if (fluidOutputs.size() > 0) {
            FluidStack fluidStack = fluidOutputs.get(0);
        }
        this.putStackInContainer(container, slot, var8_12 == null ? ItemStack.field_190927_a : this.getFluidBucket((FluidStack)var8_12));
        this.outputFluidAmount = String.valueOf(FluidHelpers.getAmount((FluidStack)var8_12));
        if (MinecraftHelpers.isClientSide()) {
            this.refreshOutputFluidAmountBox();
        }
    }

    protected ItemStack getFluidBucket(FluidStack fluidStack) {
        ItemStack itemStack = new ItemStack(Items.field_151133_ar);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)itemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        fluidHandler.fill(new FluidStack(fluidStack, 1000), true);
        return fluidHandler.getContainer();
    }

    protected boolean isInputValid() {
        return this.inputStacks.stream().anyMatch(stack -> !((ItemStack)stack.getLeft()).func_190926_b()) || !this.inputFluid.func_190926_b() || !this.inputFluidAmount.equalsIgnoreCase("0") || !this.inputEnergy.equalsIgnoreCase("0");
    }

    protected boolean isOutputValid() {
        return this.outputStacks.stream().anyMatch(stack -> !stack.func_190926_b()) || !this.outputFluid.func_190926_b() || !this.outputFluidAmount.equalsIgnoreCase("0") || !this.outputEnergy.equalsIgnoreCase("0");
    }

    @Override
    public boolean canWriteElementPre() {
        return this.isInputValid() == this.isOutputValid();
    }

    @Override
    public void activate() {
        this.inputStacks = NonNullList.func_191197_a((int)9, (Object)Pair.of((Object)ItemStack.field_190927_a, (Object)((Object)ValueTypeRecipeLPElement.getDefaultItemMatch())));
        this.inputFluid = ItemStack.field_190927_a;
        this.inputFluidAmount = "0";
        this.inputEnergy = "0";
        this.outputStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
        this.outputFluid = ItemStack.field_190927_a;
        this.outputFluidAmount = "0";
        this.outputEnergy = "0";
    }

    @Override
    public void deactivate() {
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (!this.inputFluid.func_190926_b() && Helpers.getFluidStack(this.inputFluid) == null) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.fluid.no_fluid", new Object[0]);
        }
        if (!this.outputFluid.func_190926_b() && Helpers.getFluidStack(this.outputFluid) == null) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.fluid.no_fluid", new Object[0]);
        }
        try {
            Integer.parseInt(this.inputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputFluidAmount});
        }
        try {
            Integer.parseInt(this.outputFluidAmount);
        }
        catch (NumberFormatException e) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputFluidAmount});
        }
        try {
            Integer.parseInt(this.inputEnergy);
        }
        catch (NumberFormatException e) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.inputEnergy});
        }
        try {
            Integer.parseInt(this.outputEnergy);
        }
        catch (NumberFormatException e) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input", new Object[]{this.outputEnergy});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return true;
    }

    @Override
    public Slot createSlot(IInventory temporaryInputSlots, int slotId, int x, int y) {
        Slot slot = ILogicProgrammerElement.createSlotDefault(this, temporaryInputSlots, slotId, x, y);
        if (slotId < 9) {
            slot.setBackgroundName(ValueTypeRecipeLPElement.getDefaultItemMatch().getSlotSpriteName().toString());
        }
        return slot;
    }

    @Override
    public boolean slotClick(int slotId, Slot slot, int mouseButton, ClickType clickType, EntityPlayer player) {
        if (slotId >= 4 && slotId < 13 && mouseButton == 0 && clickType == ClickType.QUICK_MOVE) {
            int id = slotId - 4;
            this.inputStacks.set(id, (Object)Pair.of((Object)((Pair)this.inputStacks.get(id)).getLeft(), (Object)((Object)((ItemMatchType)((Object)((Pair)this.inputStacks.get(id)).getRight())).next())));
            slot.setBackgroundName(((ItemMatchType)((Object)((Pair)this.inputStacks.get(id)).getRight())).getSlotSpriteName().toString());
            return true;
        }
        return super.slotClick(slotId, slot, mouseButton, clickType, player);
    }

    @Override
    public int getItemStackSizeLimit() {
        return 64;
    }

    protected Map<IngredientComponent<?, ?>, List<IPrototypedIngredientAlternatives<?, ?>>> getInputs(List<Pair<ItemStack, ItemMatchType>> itemStacks, ItemStack fluid, int fluidAmount, int energy) {
        List energies;
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (((ItemStack)itemStacks.get(i).getLeft()).func_190926_b()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (fluidStack != null) {
            fluidStack.amount = fluidAmount;
        }
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        List items = itemStacks.stream().map(stack -> ((ItemMatchType)((Object)((Object)stack.getRight()))).getPrototypeHandler().getPrototypesFor((ItemStack)stack.getLeft())).collect(Collectors.toList());
        List fluids = fluidStack != null ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.FLUIDSTACK, (Object)fluidStack, (Object)3)))) : Collections.emptyList();
        List<Object> list = energies = energy > 0 ? Collections.singletonList(new PrototypedIngredientAlternativesList(Collections.singletonList(new PrototypedIngredient(IngredientComponent.ENERGY, (Object)energy, (Object)false)))) : Collections.emptyList();
        if (!items.isEmpty()) {
            inputs.put(IngredientComponent.ITEMSTACK, items);
        }
        if (!fluids.isEmpty()) {
            inputs.put(IngredientComponent.FLUIDSTACK, fluids);
        }
        if (!energies.isEmpty()) {
            inputs.put(IngredientComponent.ENERGY, energies);
        }
        return inputs;
    }

    protected Map<IngredientComponent<?, ?>, List<?>> getOutputs(List<ItemStack> itemStacks, ItemStack fluid, int fluidAmount, int energy) {
        int lastNonEmpty = 0;
        for (int i = 0; i < itemStacks.size(); ++i) {
            if (itemStacks.get(i).func_190926_b()) continue;
            lastNonEmpty = i + 1;
        }
        itemStacks = itemStacks.subList(0, lastNonEmpty);
        FluidStack fluidStack = Helpers.getFluidStack(fluid);
        if (fluidStack != null) {
            fluidStack.amount = fluidAmount;
        }
        IdentityHashMap outputs = Maps.newIdentityHashMap();
        if (!itemStacks.isEmpty()) {
            outputs.put(IngredientComponent.ITEMSTACK, itemStacks);
        }
        if (fluidStack != null) {
            outputs.put(IngredientComponent.FLUIDSTACK, Collections.singletonList(fluidStack));
        }
        if (energy > 0) {
            outputs.put(IngredientComponent.ENERGY, Collections.singletonList(energy));
        }
        return outputs;
    }

    @Override
    public IValue getValue() {
        if (!this.isInputValid() && !this.isOutputValid()) {
            return ValueObjectTypeRecipe.ValueRecipe.of(null);
        }
        return ValueObjectTypeRecipe.ValueRecipe.of((IRecipeDefinition)new RecipeDefinition(this.getInputs((List<Pair<ItemStack, ItemMatchType>>)this.inputStacks, this.inputFluid, Integer.parseInt(this.inputFluidAmount), Integer.parseInt(this.inputEnergy)), (IMixedIngredients)new MixedIngredients(this.getOutputs((List<ItemStack>)this.outputStacks, this.outputFluid, Integer.parseInt(this.outputFluidAmount), Integer.parseInt(this.outputEnergy)))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.lastGui = new SubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.lastGui;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setValueInGui(ISubGuiBox subGui) {
        int i;
        SubGuiRenderPattern gui = (SubGuiRenderPattern)subGui;
        IInventory slots = ((ContainerLogicProgrammerBase)gui.container).getTemporaryInputSlots();
        for (i = 0; i < this.inputStacks.size(); ++i) {
            Pair entry = (Pair)this.inputStacks.get(i);
            slots.func_70299_a(i, (ItemStack)entry.getLeft());
        }
        slots.func_70299_a(9, this.inputFluid);
        if (gui.getInputFluidAmountBox() != null) {
            gui.getInputFluidAmountBox().func_146180_a(this.inputFluidAmount);
            gui.getInputEnergyBox().func_146180_a(this.inputEnergy);
            for (i = 0; i < this.outputStacks.size(); ++i) {
                slots.func_70299_a(10 + i, (ItemStack)this.outputStacks.get(i));
            }
            slots.func_70299_a(13, this.outputFluid);
            gui.getOutputFluidAmountBox().func_146180_a(this.outputFluidAmount);
            gui.getOutputEnergyBox().func_146180_a(this.outputEnergy);
        }
    }

    public String getInputFluidAmount() {
        return this.inputFluidAmount;
    }

    public void setInputFluidAmount(String inputFluidAmount) {
        this.inputFluidAmount = inputFluidAmount;
    }

    public String getInputEnergy() {
        return this.inputEnergy;
    }

    public void setInputEnergy(String inputEnergy) {
        this.inputEnergy = inputEnergy;
    }

    public String getOutputFluidAmount() {
        return this.outputFluidAmount;
    }

    public void setOutputFluidAmount(String outputFluidAmount) {
        this.outputFluidAmount = outputFluidAmount;
    }

    public String getOutputEnergy() {
        return this.outputEnergy;
    }

    public void setOutputEnergy(String outputEnergy) {
        this.outputEnergy = outputEnergy;
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SubGuiRenderPattern
    extends RenderPattern<ValueTypeRecipeLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private boolean renderTooltip = true;
        private GuiTextFieldExtended inputFluidAmountBox = null;
        private GuiTextFieldExtended inputEnergyBox = null;
        private GuiTextFieldExtended outputFluidAmountBox = null;
        private GuiTextFieldExtended outputEnergyBox = null;

        public SubGuiRenderPattern(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        protected static GuiTextFieldExtended makeTextBox(int componentId, int x, int y, String text) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int searchWidth = 35;
            GuiTextFieldExtended box = new GuiTextFieldExtended(componentId, fontRenderer, x, y, searchWidth, fontRenderer.field_78288_b + 3, true);
            box.func_146203_f(10);
            box.func_146185_a(false);
            box.func_146189_e(true);
            box.func_146193_g(0xFFFFFF);
            box.func_146205_d(true);
            box.func_146180_a(text);
            box.field_146218_h = searchWidth;
            return box;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.inputFluidAmountBox = SubGuiRenderPattern.makeTextBox(0, guiLeft + this.getX() + 21, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getInputFluidAmount());
            this.inputEnergyBox = SubGuiRenderPattern.makeTextBox(1, guiLeft + this.getX() + 21, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getInputEnergy());
            this.outputFluidAmountBox = SubGuiRenderPattern.makeTextBox(2, guiLeft + this.getX() + 101, guiTop + this.getY() + 59, ((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount());
            this.outputEnergyBox = SubGuiRenderPattern.makeTextBox(3, guiLeft + this.getX() + 101, guiTop + this.getY() + 77, ((ValueTypeRecipeLPElement)this.element).getOutputEnergy());
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground((GuiLogicProgrammerBase)this.gui, (ContainerLogicProgrammerBase)this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeRecipeLPElement)this.element).getValueType());
            for (int slotId = 0; slotId < ((GuiLogicProgrammerBase)this.gui).field_147002_h.field_75151_b.size(); ++slotId) {
                TextureAtlasSprite textureatlassprite;
                Slot slot = (Slot)((GuiLogicProgrammerBase)this.gui).field_147002_h.field_75151_b.get(slotId);
                if (slotId < 4 || slotId >= 13) continue;
                int slotX = slot.field_75223_e;
                int slotY = slot.field_75221_f;
                if (slot.func_75216_d() && slot.func_111238_b() && (textureatlassprite = slot.getBackgroundSprite()) != null) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    ((GuiLogicProgrammerBase)this.gui).field_146297_k.func_110434_K().func_110577_a(slot.getBackgroundLocation());
                    this.func_175175_a(slotX, slotY, textureatlassprite, 16, 16);
                    GlStateManager.func_179126_j();
                }
                if (!((GuiLogicProgrammerBase)this.gui).func_146978_c(slotX, slotY, 16, 16, mouseX, mouseY)) continue;
                String name = "valuetype.valuetypes.integrateddynamics.ingredients.match." + ((ItemMatchType)((Object)((Pair)((ValueTypeRecipeLPElement)this.element).inputStacks.get(slot.getSlotIndex())).getRight())).name().toLowerCase(Locale.ENGLISH);
                ((GuiLogicProgrammerBase)this.gui).drawTooltip(Lists.newArrayList((Object[])new String[]{L10NHelpers.localize((String)(name + ".desc"), (Object[])new Object[0]) + " " + TextFormatting.RESET + TextFormatting.ITALIC + L10NHelpers.localize((String)"valuetype.valuetypes.integrateddynamics.ingredients.info", (Object[])new Object[0])}), mouseX - guiLeft, mouseY - guiTop - 15);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.func_73729_b(guiLeft + this.getX() + 66, guiTop + this.getY() + 21, 0, 38, 22, 15);
            this.inputFluidAmountBox.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
            fontRenderer.func_78276_b(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit.name", (Object[])new Object[0]) + ":", guiLeft + this.getX() + 2, guiTop + this.getY() + 78, 0);
            this.inputEnergyBox.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
            this.outputFluidAmountBox.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
            fontRenderer.func_78276_b(L10NHelpers.localize((String)"general.integrateddynamics.energy_unit.name", (Object[])new Object[0]) + ":", guiLeft + this.getX() + 84, guiTop + this.getY() + 78, 0);
            this.outputEnergyBox.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }

        @Override
        public boolean keyTyped(boolean checkHotbarKeys, char typedChar, int keyCode) throws IOException {
            if (!checkHotbarKeys) {
                if (this.inputFluidAmountBox.func_146201_a(typedChar, keyCode)) {
                    ((ValueTypeRecipeLPElement)this.element).setInputFluidAmount(this.inputFluidAmountBox.func_146179_b());
                    ((ContainerLogicProgrammerBase)this.container).onDirty();
                    IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_FLUID));
                    return true;
                }
                if (this.inputEnergyBox.func_146201_a(typedChar, keyCode)) {
                    ((ValueTypeRecipeLPElement)this.element).setInputEnergy(this.inputEnergyBox.func_146179_b());
                    ((ContainerLogicProgrammerBase)this.container).onDirty();
                    IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getInputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.INPUT_ENERGY));
                    return true;
                }
                if (this.outputFluidAmountBox.func_146201_a(typedChar, keyCode)) {
                    ((ValueTypeRecipeLPElement)this.element).setOutputFluidAmount(this.outputFluidAmountBox.func_146179_b());
                    ((ContainerLogicProgrammerBase)this.container).onDirty();
                    IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputFluidAmount(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_FLUID));
                    return true;
                }
                if (this.outputEnergyBox.func_146201_a(typedChar, keyCode)) {
                    ((ValueTypeRecipeLPElement)this.element).setOutputEnergy(this.outputEnergyBox.func_146179_b());
                    ((ContainerLogicProgrammerBase)this.container).onDirty();
                    IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeRecipeValueChangedPacket(((ValueTypeRecipeLPElement)this.element).getOutputEnergy(), LogicProgrammerValueTypeRecipeValueChangedPacket.Type.OUTPUT_ENERGY));
                    return true;
                }
            }
            return super.keyTyped(checkHotbarKeys, typedChar, keyCode);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            this.inputFluidAmountBox.func_146192_a(mouseX, mouseY, mouseButton);
            this.inputEnergyBox.func_146192_a(mouseX, mouseY, mouseButton);
            this.outputFluidAmountBox.func_146192_a(mouseX, mouseY, mouseButton);
            this.outputEnergyBox.func_146192_a(mouseX, mouseY, mouseButton);
            super.mouseClicked(mouseX, mouseY, mouseButton);
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }

        public GuiTextFieldExtended getInputFluidAmountBox() {
            return this.inputFluidAmountBox;
        }

        public GuiTextFieldExtended getInputEnergyBox() {
            return this.inputEnergyBox;
        }

        public GuiTextFieldExtended getOutputFluidAmountBox() {
            return this.outputFluidAmountBox;
        }

        public GuiTextFieldExtended getOutputEnergyBox() {
            return this.outputEnergyBox;
        }
    }
}

