/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityExportWrapper
implements IIngredientComponentStorage<ItemStack, Integer>,
IBlockSource {
    private final WorldServer world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final int lifespan;
    private final int delayBeforePickup;
    private final EnumFacing facing;
    private final double velocity;
    private final float yawOffset;
    private final float pitchOffset;
    private final boolean dispense;
    private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
    private static final BehaviorDefaultDispenseItem DISPENSE_ITEM_DIRECTLY = new BehaviorDefaultDispenseItem();

    public ItemHandlerWorldEntityExportWrapper(WorldServer world, BlockPos pos, double offsetX, double offsetY, double offsetZ, int lifespan, int delayBeforePickup, EnumFacing facing, double velocity, double yawOffset, double pitchOffset, boolean dispense, IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler) {
        this.world = world;
        this.pos = pos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.lifespan = lifespan;
        this.delayBeforePickup = delayBeforePickup;
        this.facing = facing;
        this.velocity = velocity;
        this.yawOffset = (float)yawOffset;
        this.pitchOffset = (float)pitchOffset;
        this.dispense = dispense;
        this.dispenseResultHandler = dispenseResultHandler;
    }

    protected void setThrowableHeading(EntityItem entity, double x, double y, double z, double velocity) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        entity.field_70159_w = x *= velocity;
        entity.field_70181_x = y *= velocity;
        entity.field_70179_y = z *= velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        entity.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        entity.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        entity.field_70126_B = entity.field_70177_z;
        entity.field_70127_C = entity.field_70125_A;
    }

    protected static void handleDispenseResult(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, IBlockSource blockSource, ItemStack itemStack) {
        ItemStack remaining = (ItemStack)dispenseResultHandler.insert((Object)itemStack, false);
        if (!remaining.func_190926_b()) {
            DISPENSE_ITEM_DIRECTLY.func_82482_a(blockSource, remaining);
        }
    }

    public double func_82615_a() {
        return (double)this.func_180699_d().func_177958_n() + this.offsetX;
    }

    public double func_82617_b() {
        return (double)this.func_180699_d().func_177956_o() + this.offsetY;
    }

    public double func_82616_c() {
        return (double)this.func_180699_d().func_177952_p() + this.offsetZ;
    }

    public BlockPos func_180699_d() {
        return this.pos.func_177972_a(this.facing.func_176734_d());
    }

    public IBlockState func_189992_e() {
        return Blocks.field_150367_z.func_176223_P().func_177226_a((IProperty)BlockDispenser.field_176440_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockDispenser.field_176441_a, (Comparable)this.facing);
    }

    public TileEntityDispenser getBlockTileEntity() {
        return new SimulatedTileEntityDispenser(this.dispenseResultHandler, this);
    }

    public World func_82618_k() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 64L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (!simulate) {
            IBehaviorDispenseItem behaviorDispenseItem;
            if (this.dispense && (behaviorDispenseItem = (IBehaviorDispenseItem)BlockDispenser.field_149943_a.func_82594_a((Object)stack.func_77973_b())).getClass() != BehaviorDefaultDispenseItem.class) {
                ItemStack result = behaviorDispenseItem.func_82482_a((IBlockSource)this, stack.func_77946_l());
                if (!result.func_190926_b()) {
                    ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, this, result);
                }
                return ItemStack.field_190927_a;
            }
            EntityItem entity = new EntityItem((World)this.world, (double)this.pos.func_177958_n() + this.offsetX, (double)this.pos.func_177956_o() + this.offsetY, (double)this.pos.func_177952_p() + this.offsetZ, stack.func_77946_l());
            entity.lifespan = this.lifespan <= 0 ? stack.func_77973_b().getEntityLifespan(stack, (World)this.world) : this.lifespan;
            float yaw = this.facing.func_185119_l() + this.yawOffset;
            float pitch = (this.facing == EnumFacing.UP ? -90.0f : (this.facing == EnumFacing.DOWN ? 90.0f : 0.0f)) - this.pitchOffset;
            this.setThrowableHeading(entity, -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180))), -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180))), MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180))), this.velocity);
            entity.func_174867_a(this.delayBeforePickup);
            this.world.func_72838_d((Entity)entity);
            if (GeneralConfig.worldInteractionEvents) {
                this.world.func_175718_b(1000, this.pos, 0);
                this.world.func_175718_b(2000, this.pos.func_177972_a(this.facing.func_176734_d()), this.facing.func_82601_c() + 1 + (this.facing.func_82599_e() + 1) * 3);
            }
        } else if (this.dispense) {
            stack = stack.func_77946_l();
            stack.func_77979_a(1);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    protected static class SimulatedTileEntityDispenser
    extends TileEntityDispenser {
        private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
        private final IBlockSource blockSource;

        public SimulatedTileEntityDispenser(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, IBlockSource blockSource) {
            this.dispenseResultHandler = dispenseResultHandler;
            this.blockSource = blockSource;
        }

        public int func_70302_i_() {
            return 0;
        }

        public int func_146017_i() {
            return 0;
        }

        public boolean func_191420_l() {
            return true;
        }

        public int func_146019_a(ItemStack stack) {
            ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, this.blockSource, stack);
            return 0;
        }

        protected NonNullList<ItemStack> func_190576_q() {
            return NonNullList.func_191196_a();
        }
    }
}

