/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.jeiutilities.jei.bookmark;

import com.github.vfyjxf.jeiutilities.JEIUtilities;
import com.github.vfyjxf.jeiutilities.config.JeiUtilitiesConfig;
import com.github.vfyjxf.jeiutilities.helper.IngredientHelper;
import com.github.vfyjxf.jeiutilities.helper.RecipeHelper;
import com.github.vfyjxf.jeiutilities.helper.ReflectionUtils;
import com.github.vfyjxf.jeiutilities.jei.JeiUtilitiesPlugin;
import com.github.vfyjxf.jeiutilities.jei.ingredient.CraftingRecipeInfo;
import com.github.vfyjxf.jeiutilities.jei.ingredient.RecipeInfo;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.bookmarks.BookmarkList;
import mezz.jei.config.Config;
import mezz.jei.gui.Focus;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.startup.IModIdHelper;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RecipeBookmarkList
extends BookmarkList {
    public static final String MARKER_OTHER = "O:";
    public static final String MARKER_STACK = "T:";
    public static final String MARKER_RECIPE = "R:";
    private final List<Object> list = (List)ReflectionUtils.getFieldValue(BookmarkList.class, this, "list");
    private final List<IIngredientGridSource.Listener> listeners = (List)ReflectionUtils.getFieldValue(BookmarkList.class, this, "listeners");

    public static BookmarkList create(IngredientRegistry ingredientRegistry) {
        if (JeiUtilitiesConfig.getRecordRecipes()) {
            return new RecipeBookmarkList(ingredientRegistry);
        }
        return new BookmarkList(ingredientRegistry);
    }

    public RecipeBookmarkList(IngredientRegistry ingredientRegistry) {
        super(ingredientRegistry);
    }

    public void saveBookmarks() {
        ArrayList<String> strings = new ArrayList<String>();
        for (IIngredientListElement element : this.getIngredientList()) {
            Object object = element.getIngredient();
            if (object instanceof ItemStack) {
                strings.add(MARKER_STACK + ((ItemStack)object).func_77955_b(new NBTTagCompound()));
                continue;
            }
            if (object instanceof RecipeInfo) {
                strings.add(MARKER_RECIPE + object);
                continue;
            }
            strings.add(MARKER_OTHER + RecipeBookmarkList.getUid(element));
        }
        File file = Config.getBookmarkFile();
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                Log.get().error("Failed to save bookmarks list to file {}", (Object)file, (Object)e);
            }
        }
    }

    public void loadBookmarks() {
        List ingredientJsonStrings;
        File file = Config.getBookmarkFile();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            Iterator<IIngredientGridSource.Listener> iterator = null;
            try {
                ingredientJsonStrings = IOUtils.readLines((Reader)reader);
            }
            catch (Throwable throwable) {
                iterator = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (iterator != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)iterator)).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.get().error("Failed to load bookmarks from file {}", (Object)file, (Object)e);
            return;
        }
        ArrayList<IIngredientType> otherIngredientTypes = new ArrayList<IIngredientType>(JeiUtilitiesPlugin.ingredientRegistry.getRegisteredIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM);
        this.list.clear();
        this.getIngredientList().clear();
        for (String ingredientJsonString : ingredientJsonStrings) {
            if (ingredientJsonString.startsWith(MARKER_STACK)) {
                String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                try {
                    NBTTagCompound itemStackAsNbt = JsonToNBT.func_180713_a((String)itemStackAsJson);
                    ItemStack itemStack = new ItemStack(itemStackAsNbt);
                    if (!itemStack.func_190926_b()) {
                        ItemStack normalized = (ItemStack)this.normalize(itemStack);
                        this.addToLists(normalized);
                        continue;
                    }
                    Log.get().warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                }
                catch (NBTException e) {
                    Log.get().error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                }
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_RECIPE)) {
                String recipeInfoAsJson = ingredientJsonString.substring(MARKER_RECIPE.length());
                RecipeInfo recipeInfo = this.loadInfoFromJson(recipeInfoAsJson, otherIngredientTypes);
                if (recipeInfo == null) continue;
                this.addToLists(recipeInfo);
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                Object ingredient = this.getUnknownIngredientByUid(otherIngredientTypes, uid);
                if (ingredient == null) continue;
                Object normalized = this.normalize(ingredient);
                this.addToLists(normalized);
                continue;
            }
            Log.get().error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }

    private <T> void addToLists(T ingredient) {
        IIngredientType ingredientType = JeiUtilitiesPlugin.ingredientRegistry.getIngredientType(ingredient);
        IIngredientListElement element = IngredientListElementFactory.createUnorderedElement((IIngredientRegistry)JeiUtilitiesPlugin.ingredientRegistry, (IIngredientType)ingredientType, ingredient, (IModIdHelper)ForgeModIdHelper.getInstance());
        if (element != null) {
            this.list.add(ingredient);
            this.getIngredientList().add(element);
        }
    }

    private static <T> String getUid(IIngredientListElement<T> element) {
        IIngredientHelper ingredientHelper = element.getIngredientHelper();
        return ingredientHelper.getUniqueId(element.getIngredient());
    }

    private RecipeInfo loadInfoFromJson(String recipeInfoString, Collection<IIngredientType> otherIngredientTypes) {
        IFocus.Mode mode;
        JsonObject jsonObject;
        try {
            jsonObject = new JsonParser().parse(recipeInfoString).getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            JEIUtilities.logger.error("Failed to parse recipe info string {}", (Object)recipeInfoString, (Object)e);
            return null;
        }
        String ingredientUid = jsonObject.get("ingredient").getAsString();
        String resultUid = jsonObject.get("result").getAsString();
        String recipeCategoryUid = jsonObject.get("recipeCategoryUid").getAsString();
        Object ingredientObject = this.loadIngredientFromJson(ingredientUid, otherIngredientTypes);
        Object resultObject = this.loadIngredientFromJson(resultUid, otherIngredientTypes);
        if (ingredientObject == null || resultObject == null) {
            JEIUtilities.logger.error("Failed to load recipe info from json string:\n{}", (Object)recipeInfoString);
            return null;
        }
        boolean isInputMode = jsonObject.get("isInputMode").getAsBoolean();
        IFocus.Mode mode2 = mode = isInputMode ? IFocus.Mode.INPUT : IFocus.Mode.OUTPUT;
        if (jsonObject.has("registryName") && ingredientObject instanceof ItemStack && resultObject instanceof ItemStack) {
            ResourceLocation registryName = new ResourceLocation(jsonObject.get("registryName").getAsString());
            Pair<ICraftingRecipeWrapper, Integer> recipePair = RecipeHelper.getCraftingRecipeWrapperAndIndex(registryName, recipeCategoryUid, resultObject, new Focus(mode, ingredientObject));
            if (recipePair == null) {
                JEIUtilities.logger.error("Failed to find the corresponding recipe, found the invalid recipe record :\n{}", (Object)recipeInfoString);
                return null;
            }
            return new CraftingRecipeInfo((ItemStack)ingredientObject, (ItemStack)resultObject, recipeCategoryUid, (Integer)recipePair.getRight(), isInputMode, (ICraftingRecipeWrapper)recipePair.getLeft(), registryName);
        }
        if (jsonObject.has("inputs")) {
            JsonArray inputsArray = jsonObject.get("inputs").getAsJsonArray();
            Map<IIngredientType, List<String>> recipeUidMap = this.getRecipeUidMap(inputsArray);
            Pair<IRecipeWrapper, Integer> recipePair = RecipeHelper.getRecipeWrapperAndIndex(recipeUidMap, recipeCategoryUid, resultObject, new Focus(mode, ingredientObject));
            if (recipePair == null) {
                JEIUtilities.logger.error("Failed to find the corresponding recipe, found the invalid recipe record :\n{}", (Object)recipeInfoString);
                return null;
            }
            return new RecipeInfo<Object, Object>(ingredientObject, resultObject, recipeCategoryUid, (Integer)recipePair.getRight(), isInputMode, (IRecipeWrapper)recipePair.getLeft());
        }
        return null;
    }

    private Object loadIngredientFromJson(String ingredientString, Collection<IIngredientType> otherIngredientTypes) {
        if (ingredientString.startsWith(MARKER_STACK)) {
            String itemStackAsJson = ingredientString.substring(MARKER_STACK.length());
            try {
                NBTTagCompound itemStackAsNbt = JsonToNBT.func_180713_a((String)itemStackAsJson);
                ItemStack itemStack = new ItemStack(itemStackAsNbt);
                if (!itemStack.func_190926_b()) {
                    return IngredientHelper.getNormalize(itemStack);
                }
                JEIUtilities.logger.warn("Failed to load recipe info ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
            }
            catch (NBTException e) {
                JEIUtilities.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
            }
        } else if (ingredientString.startsWith(MARKER_OTHER)) {
            String uid = ingredientString.substring(MARKER_OTHER.length());
            Object ingredient = this.getUnknownIngredientByUid(otherIngredientTypes, uid);
            if (ingredient != null) {
                return IngredientHelper.getNormalize(ingredient);
            }
        } else {
            JEIUtilities.logger.error("Failed to load unknown recipe info:\n{}", (Object)ingredientString);
        }
        return null;
    }

    private Map<IIngredientType, List<String>> getRecipeUidMap(JsonArray inputsArray) {
        HashMap<IIngredientType, List<String>> recipeUidMap = new HashMap<IIngredientType, List<String>>(inputsArray.size());
        for (JsonElement element : inputsArray) {
            if (!element.isJsonArray()) continue;
            ArrayList<String> inputsUidListInner = new ArrayList<String>();
            for (JsonElement elementInner : element.getAsJsonArray()) {
                if (!elementInner.isJsonPrimitive()) continue;
                inputsUidListInner.add(elementInner.getAsString());
            }
            recipeUidMap.put(IngredientHelper.getIngredientType(inputsUidListInner), inputsUidListInner);
        }
        return recipeUidMap;
    }

    @Nullable
    private Object getUnknownIngredientByUid(Collection<IIngredientType> ingredientTypes, String uid) {
        for (IIngredientType ingredientType : ingredientTypes) {
            Object ingredient = JeiUtilitiesPlugin.ingredientRegistry.getIngredientByUid(ingredientType, uid);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }
}

