/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.common.PacketHandler;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSecurityMode
implements IMessageHandler<SecurityModeMessage, IMessage> {
    public IMessage onMessage(SecurityModeMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            if (message.packetType == SecurityPacketType.BLOCK) {
                UUID owner;
                TileEntity tileEntity = message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                if (tileEntity instanceof ISecurityTile && (owner = ((ISecurityTile)tileEntity).getSecurity().getOwnerUUID()) != null && player.func_110124_au().equals(owner)) {
                    ((ISecurityTile)tileEntity).getSecurity().setMode(message.value);
                    tileEntity.func_70296_d();
                }
            } else {
                ItemStack stack = player.func_184586_b(message.currentHand);
                if (stack.func_77973_b() instanceof ISecurityItem) {
                    ((ISecurityItem)stack.func_77973_b()).setSecurity(stack, message.value);
                }
            }
        }, player);
        return null;
    }

    public static class SecurityModeMessage
    implements IMessage {
        public SecurityPacketType packetType;
        public Coord4D coord4D;
        public EnumHand currentHand;
        public ISecurityTile.SecurityMode value;

        public SecurityModeMessage() {
        }

        public SecurityModeMessage(Coord4D coord, ISecurityTile.SecurityMode control) {
            this.packetType = SecurityPacketType.BLOCK;
            this.coord4D = coord;
            this.value = control;
        }

        public SecurityModeMessage(EnumHand hand, ISecurityTile.SecurityMode control) {
            this.packetType = SecurityPacketType.ITEM;
            this.currentHand = hand;
            this.value = control;
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == SecurityPacketType.BLOCK) {
                this.coord4D.write(dataStream);
            } else {
                dataStream.writeInt(this.currentHand.ordinal());
            }
            dataStream.writeInt(this.value.ordinal());
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = SecurityPacketType.values()[dataStream.readInt()];
            if (this.packetType == SecurityPacketType.BLOCK) {
                this.coord4D = Coord4D.read(dataStream);
            } else {
                this.currentHand = EnumHand.values()[dataStream.readInt()];
            }
            this.value = ISecurityTile.SecurityMode.values()[dataStream.readInt()];
        }
    }

    public static enum SecurityPacketType {
        BLOCK,
        ITEM;

    }
}

