/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.List;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentWeather;
import modulardiversity.jei.ingredients.Weather;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RequirementWeather
extends RequirementEnvironmental<Weather, ResourceToken> {
    public Type weather;

    public RequirementWeather(MachineComponent.IOType actionType, Type weather) {
        super(ComponentType.Registry.getComponent((String)"weather"), actionType);
        this.weather = weather;
    }

    public ComponentRequirement<Weather> deepCopy() {
        return new RequirementWeather(this.getActionType(), this.weather);
    }

    public ComponentRequirement<Weather> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementWeather(this.getActionType(), this.weather);
    }

    public ComponentRequirement.JEIComponent<Weather> provideJEIComponent() {
        return new JEIComponentWeather(this);
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        switch (this.weather) {
            case CLEAR: {
                return "craftcheck.weather.clear";
            }
            case RAIN: {
                return "craftcheck.weather.rain";
            }
            case STORM: {
                return "craftcheck.weather.storm";
            }
            case SNOW: {
                return "craftcheck.weather.snow";
            }
        }
        return null;
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken();
    }

    private boolean isValidWeather(World world, BlockPos pos) {
        switch (this.weather) {
            case CLEAR: {
                return !world.func_72896_J();
            }
            case RAIN: {
                return world.func_72896_J();
            }
            case STORM: {
                return world.func_72911_I();
            }
            case SNOW: {
                return world.func_72896_J() && world.func_175708_f(pos, false);
            }
        }
        return false;
    }

    private boolean setWeather(World world, BlockPos pos) {
        switch (this.weather) {
            case CLEAR: {
                if (world.func_72896_J()) {
                    world.func_72894_k(0.0f);
                    return true;
                }
                return false;
            }
            case RAIN: {
                if (!world.func_72896_J()) {
                    world.func_72894_k(1.0f);
                    return true;
                }
                return false;
            }
            case STORM: {
                if (!world.func_72911_I()) {
                    world.func_147442_i(1.0f);
                    return true;
                }
                return false;
            }
            case SNOW: {
                if (!world.func_175708_f(pos, false)) {
                    return false;
                }
                if (!world.func_72896_J()) {
                    world.func_72894_k(1.0f);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null && this.isValidWeather(tile.func_145831_w(), tile.func_174877_v())) {
            token.setRequirementMet();
        }
        return true;
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null && this.setWeather(tile.func_145831_w(), tile.func_174877_v())) {
            token.setRequirementMet();
        }
        return true;
    }

    public static class ResourceToken
    implements IResourceToken {
        private boolean requirementMet;

        public void setRequirementMet() {
            this.requirementMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMet;
        }
    }

    public static enum Type {
        CLEAR,
        RAIN,
        STORM,
        SNOW;

    }
}

