/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.jei.ingredients;

import modulardiversity.jei.IFakeIngredient;

public class Daylight
implements IFakeIngredient {
    long timeMin;
    long timeMax;
    long timeModulo;
    boolean timeLocal;

    public Daylight(long timeMin, long timeMax, long timeModulo, boolean local) {
        this.timeMin = timeMin;
        this.timeMax = timeMax;
        this.timeModulo = timeModulo;
        this.timeLocal = local;
    }

    public String getClockFrame(int time) {
        int num = (int)Math.floor((time - 6000) / 375);
        if (num < 0) {
            num += 64;
        }
        String numString = Integer.toString(num);
        if (num < 10) {
            numString = "0" + numString;
        }
        return numString;
    }

    public static String getFormattedLocalTime(long time) {
        boolean am = true;
        double cfg = time;
        if ((cfg += 6000.0) > 23999.0) {
            cfg -= 24000.0;
        }
        if (cfg >= 12000.0) {
            am = false;
            cfg -= 12000.0;
        }
        if ((cfg = Math.floor(cfg / 10.0) / 100.0) > 12.0) {
            cfg -= 12.0;
        }
        int cfgi = (int)Math.floor(cfg);
        int cfgj = (int)Math.floor((cfg - (double)cfgi) * 60.0);
        return Integer.toString(cfgi) + (cfgj < 10 ? ":0" : ":") + Integer.toString(cfgj) + (am ? " a.m." : " p.m.");
    }

    public static String getFormattedGlobalTime(long min, long max, long mod) {
        if (max == min) {
            return "exactly " + min + " ticks after every " + mod + " ticks";
        }
        if (max >= Long.MAX_VALUE) {
            return min + " ticks after every " + mod + " ticks";
        }
        if (min <= 0L) {
            return "up to " + max + " ticks after every " + mod + " ticks";
        }
        if (min < max) {
            return "between " + min + " and " + max + " ticks after every " + mod + " ticks";
        }
        return "not between " + min + " and " + max + " ticks after every " + mod + " ticks";
    }

    public static String getFormattedGlobalTime(long min, long max) {
        if (max == min) {
            return "exactly " + min + " ticks after world start";
        }
        if (max >= Long.MAX_VALUE) {
            return min + " ticks after world start";
        }
        if (min <= 0L) {
            return "up to " + max + " ticks after world start";
        }
        if (min < max) {
            return "between " + min + " and " + max + " ticks after world start";
        }
        return "not between " + min + " and " + max + " ticks after world start";
    }

    @Override
    public String getDisplayName() {
        if (this.timeLocal) {
            return "Time Required: Between " + Daylight.getFormattedLocalTime(this.timeMin) + " and " + Daylight.getFormattedLocalTime(this.timeMax);
        }
        if (this.timeModulo >= Long.MAX_VALUE) {
            return "Time Required: " + Daylight.getFormattedGlobalTime(this.timeMin, this.timeMax);
        }
        return "Time Required: " + Daylight.getFormattedGlobalTime(this.timeMin, this.timeMax, this.timeModulo);
    }

    @Override
    public String getUniqueID() {
        return "daylight";
    }
}

