/*
 * Decompiled with CFR 0.152.
 */
package moretweaker;

import com.google.common.collect.BiMap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import epicsquid.gadgetry.core.recipe.AlloyRecipe;
import epicsquid.gadgetry.machines.recipe.DistillingRecipe;
import epicsquid.gadgetry.machines.recipe.GrindingRecipe;
import fossilsarcheology.server.recipe.FAMachineRecipeRegistry;
import fossilsarcheology.server.recipe.RecipeAnalyzer;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.function.Predicate;
import moretweaker.CommonProxy;
import moretweaker.mob_grinding_utils.SpawnEggHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.logging.log4j.Logger;
import therealfarfetchd.quacklib.common.api.autoconf.DefaultFeatures;
import therealfarfetchd.quacklib.common.api.autoconf.FeatureManager;

@Mod(modid="moretweaker", name="MoreTweaker", version="1.0.19", dependencies="required-after:crafttweaker;required-after:mtlib;after:railcraft;after:draconicevolution@[2.3.17,);after:buildcraftcore@[7.99.24,);after:buildcraftsilicon@[7.99.24,);after:enderfuge;after:voidcraft;after:bloodarsenal@[1.12.2-2.1.0-25,);after:erebus@[1.0.20,);after:bedrockcraft@[1.0.1,);after:fossil@[8.0.1,);after:matteroverdrive;after:quacklib;after:infinitycraft;after:thebetweenlands;after:aoa3;after:bewitchment@[0.21.11,);after:hwell", acceptedMinecraftVersions="[1.12.2]")
public class MoreTweaker {
    private static int next_id = 0;
    public static final String MODID = "moretweaker";
    public static final String MODNAME = "MoreTweaker";
    public static final String VERSION = "1.0.19";
    public static final String DEPENDENCIES = "required-after:crafttweaker;required-after:mtlib;after:railcraft;after:draconicevolution@[2.3.17,);after:buildcraftcore@[7.99.24,);after:buildcraftsilicon@[7.99.24,);after:enderfuge;after:voidcraft;after:bloodarsenal@[1.12.2-2.1.0-25,);after:erebus@[1.0.20,);after:bedrockcraft@[1.0.1,);after:fossil@[8.0.1,);after:matteroverdrive;after:quacklib;after:infinitycraft;after:thebetweenlands;after:aoa3;after:bewitchment@[0.21.11,);after:hwell";
    @Mod.Instance
    public static MoreTweaker instance;
    public static Logger logger;
    @SidedProxy(serverSide="moretweaker.CommonProxy", clientSide="moretweaker.ClientProxy")
    public static CommonProxy proxy;
    private static final Queue<IAction> postQueue;
    private static final Map<String, String> runtimeInjectTranslations;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Loading MoreTweaker v1.0.19");
        if (Loader.isModLoaded((String)"quacklib")) {
            CraftTweakerAPI.logInfo((String)"Enabling QuackLib alloy smelter");
            FeatureManager.INSTANCE.depend(DefaultFeatures.INSTANCE.getAlloyFurnace());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (Loader.isModLoaded((String)"mob_grinding_utils")) {
            MinecraftForge.EVENT_BUS.register((Object)SpawnEggHandler.INSTANCE);
        }
        proxy.registerTranslationsInjectHandler();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (IAction action : postQueue) {
            CraftTweakerAPI.apply((IAction)action);
        }
        postQueue.clear();
        if (Loader.isModLoaded((String)"gadgetrycore")) {
            CraftTweakerAPI.logInfo((String)"Cleaning up Gadgetry-Core recipes");
            AlloyRecipe.metals.clear();
            AlloyRecipe.additives1.clear();
            AlloyRecipe.additives2.clear();
            for (AlloyRecipe alloyRecipe : AlloyRecipe.recipes) {
                AlloyRecipe.metals.add(alloyRecipe.inputs.get(0));
                AlloyRecipe.additives1.add(alloyRecipe.inputs.get(1));
                AlloyRecipe.additives2.add(alloyRecipe.inputs.get(2));
            }
        }
        if (Loader.isModLoaded((String)"gadgetrymachines")) {
            CraftTweakerAPI.logInfo((String)"Cleaning up Gadgetry-Machines recipes");
            DistillingRecipe.distillable_items.clear();
            DistillingRecipe.distillable_fluids.clear();
            for (DistillingRecipe distillingRecipe : DistillingRecipe.recipes) {
                DistillingRecipe.distillable_items.add(distillingRecipe.inputs.get(0));
                DistillingRecipe.distillable_fluids.add(distillingRecipe.fluid_in.getFluid());
            }
            GrindingRecipe.grindables.clear();
            for (GrindingRecipe grindingRecipe : GrindingRecipe.recipes) {
                GrindingRecipe.grindables.add(grindingRecipe.inputs.get(0));
            }
        }
        if (Loader.isModLoaded((String)"fossil")) {
            float chance;
            Map.Entry entry;
            float weight;
            RecipeAnalyzer r;
            float factor;
            RecipeAnalyzer recipe;
            CraftTweakerAPI.logInfo((String)"Cleaning up Fossils Weights");
            HashSet<RecipeAnalyzer> newRecipes = new HashSet<RecipeAnalyzer>();
            Iterator itr = FAMachineRecipeRegistry.analyzerRecipes.iterator();
            while (itr.hasNext()) {
                recipe = (RecipeAnalyzer)itr.next();
                if (recipe.getTotalWeight() == 100.0f) continue;
                itr.remove();
                factor = 100.0f / recipe.getTotalWeight();
                r = new RecipeAnalyzer(recipe.getInput());
                weight = 0.0f;
                while (weight <= recipe.getTotalWeight() && (entry = recipe.getDisplayMap().higherEntry(Float.valueOf(weight))) != null) {
                    chance = entry.getKey().floatValue() - weight;
                    weight = entry.getKey().floatValue();
                    r.addOutput((ItemStack)entry.getValue(), chance * factor);
                }
                newRecipes.add(r);
            }
            FAMachineRecipeRegistry.analyzerRecipes.addAll(newRecipes);
            newRecipes = new HashSet();
            itr = FAMachineRecipeRegistry.sifterRecipes.iterator();
            while (itr.hasNext()) {
                recipe = (RecipeAnalyzer)itr.next();
                if (recipe.getTotalWeight() == 100.0f) continue;
                itr.remove();
                factor = 100.0f / recipe.getTotalWeight();
                r = new RecipeAnalyzer(recipe.getInput());
                weight = 0.0f;
                while (weight <= recipe.getTotalWeight() && (entry = recipe.getDisplayMap().higherEntry(Float.valueOf(weight))) != null) {
                    chance = entry.getKey().floatValue() - weight;
                    weight = entry.getKey().floatValue();
                    r.addOutput((ItemStack)entry.getValue(), chance * factor);
                }
                newRecipes.add(r);
            }
            FAMachineRecipeRegistry.sifterRecipes.addAll(newRecipes);
        }
    }

    public static void queuePostInitAction(IAction action) {
        postQueue.add(action);
    }

    public static ResourceLocation newRL() {
        return new ResourceLocation(MODID, "moretweakerrecipe" + next_id++);
    }

    public static <T extends IForgeRegistryEntry<T>> void forgeAdd(Class<T> registerClass, T entry) {
        IForgeRegistry registry = GameRegistry.findRegistry(registerClass);
        if (entry.getRegistryName() == null) {
            entry.setRegistryName(MoreTweaker.newRL());
        }
        registry.register(entry);
    }

    public static <T extends IForgeRegistryEntry<T>> void forgeRemove(Class<T> registerClass, Predicate<T> removePredicate) {
        IForgeRegistry registry = GameRegistry.findRegistry(registerClass);
        if (registry instanceof IForgeRegistryModifiable) {
            HashSet removes = new HashSet();
            for (Map.Entry entry : registry.getEntries()) {
                if (!removePredicate.test(entry.getValue())) continue;
                removes.add(entry.getKey());
            }
            boolean hasReportedError = false;
            BiMap names = null;
            BiMap ids = null;
            for (ResourceLocation entry : removes) {
                try {
                    ((IForgeRegistryModifiable)registry).remove(entry);
                }
                catch (UnsupportedOperationException e) {
                    if (registry instanceof ForgeRegistry) {
                        ForgeRegistry fr = (ForgeRegistry)registry;
                        if (fr.isLocked()) {
                            if (hasReportedError) continue;
                            hasReportedError = true;
                            CraftTweakerAPI.logError((String)"We're too late to remove entries. Report to MoreTweaker author.");
                            continue;
                        }
                        try {
                            IForgeRegistryEntry value;
                            if (names == null || ids == null) {
                                Field namesField = ForgeRegistry.class.getDeclaredField("names");
                                namesField.setAccessible(true);
                                names = (BiMap)namesField.get(fr);
                                Field idsField = ForgeRegistry.class.getDeclaredField("ids");
                                idsField.setAccessible(true);
                                ids = (BiMap)idsField.get(fr);
                            }
                            if ((value = (IForgeRegistryEntry)names.remove((Object)entry)) == null) continue;
                            ids.inverse().remove((Object)value);
                        }
                        catch (ReflectiveOperationException e1) {
                            if (hasReportedError) continue;
                            hasReportedError = true;
                            CraftTweakerAPI.logError((String)("Reflection failed. Report to MoreTweaker author: " + e.getMessage()));
                        }
                        continue;
                    }
                    if (hasReportedError) continue;
                    hasReportedError = true;
                    CraftTweakerAPI.logError((String)"Can't remove recipes from a custom non-modifiable forge registry.");
                }
            }
        } else {
            CraftTweakerAPI.logError((String)"Can't remove recipes from a non-modifiable forge registry.");
        }
    }

    public static void injectTranslation(String key, String value) {
        runtimeInjectTranslations.put(key, value);
    }

    public static Map<String, String> getRuntimeTranslations() {
        return Collections.unmodifiableMap(runtimeInjectTranslations);
    }

    static {
        postQueue = new LinkedList<IAction>();
        runtimeInjectTranslations = new HashMap<String, String>();
    }
}

