/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.jei;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import moretweaker.jei.MoreJeiPlugin;
import moretweaker.jei.buildcraft.BuildCraftJei;
import moretweaker.jei.erebus.ErebusJei;
import moretweaker.jei.infinitycraft.InfinityJei;
import moretweaker.jei.railcraft.RailcraftJei;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

@JEIPlugin
public class MoreJei
implements IModPlugin {
    private static IJeiRuntime runtime = null;
    private static IJeiHelpers helpers = null;
    private static final List<MoreJeiPlugin> plugins = new LinkedList<MoreJeiPlugin>();
    public static final ResourceLocation GUI_VANILLA = new ResourceLocation("jei", "textures/gui/gui_vanilla.png");
    private static final Queue<IAction> runtimeQueue = new LinkedList<IAction>();

    public MoreJei() {
        MoreJei.register("buildcraftsilicon", BuildCraftJei::new);
        MoreJei.register("erebus", ErebusJei::new);
        MoreJei.register("railcraft", RailcraftJei::new);
        MoreJei.register("infinitycraft", InfinityJei::new);
    }

    private static void register(String modid, Supplier<MoreJeiPlugin> plugin) {
        if (Loader.isModLoaded((String)modid)) {
            plugins.add(plugin.get());
        }
    }

    public void register(IModRegistry registry) {
        helpers = registry.getJeiHelpers();
        for (MoreJeiPlugin plugin : plugins) {
            plugin.register(registry);
        }
        registry.addIngredientInfo((Object)new ItemStack(Items.field_151045_i), VanillaTypes.ITEM, new String[]{"Test description", "Fancy"});
        registry.addIngredientInfo((Object)new ItemStack(Items.field_151043_k), VanillaTypes.ITEM, new String[]{"Another description", "WOWERS"});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        helpers = registry.getJeiHelpers();
        for (MoreJeiPlugin plugin : plugins) {
            plugin.register(registry);
        }
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        for (IAction action : runtimeQueue) {
            CraftTweakerAPI.apply((IAction)action);
        }
        runtimeQueue.clear();
    }

    public static void run(Consumer<IJeiRuntime> action) {
        if (runtime != null) {
            action.accept(runtime);
        }
    }

    public static IJeiHelpers getHelpers() {
        if (helpers == null) {
            throw new IllegalStateException("JeiHelpers not yet available.");
        }
        return helpers;
    }

    public static void queueJeiRuntimeAction(IAction action) {
        runtimeQueue.add(action);
    }
}

