/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import com.github.vfyjxf.nee.integration.IToolHelper;
import com.github.vfyjxf.nee.integration.RecipeToolManager;
import com.github.vfyjxf.nee.utils.ItemUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PreferenceIngredient {
    private final ItemStack identifier;
    private final boolean isTool;
    @Nullable
    private final String acceptedType;

    public PreferenceIngredient(ItemStack identifier, boolean isTool, @Nullable String acceptedType) {
        this.identifier = identifier;
        this.isTool = isTool;
        this.acceptedType = acceptedType;
    }

    public ItemStack create(int count) {
        if (this.isTool) {
            IToolHelper helper = RecipeToolManager.INSTANCE.getToolHelper(this.identifier.func_77973_b());
            if (helper != null) {
                ItemStack toolStack = helper.getToolStack(this.identifier);
                toolStack.func_190920_e(1);
                return toolStack;
            }
        } else {
            ItemStack stack = this.identifier.func_77946_l();
            stack.func_190920_e(count);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean matches(ItemStack stack, String recipeType) {
        if (this.acceptedType == null || recipeType == null || this.acceptedType.equals(recipeType)) {
            return ItemUtils.contains(this.identifier, stack);
        }
        return false;
    }

    public ItemStack getIdentifier() {
        return this.identifier;
    }

    public boolean isTool() {
        return this.isTool;
    }

    @Nullable
    public String getAcceptedType() {
        return this.acceptedType;
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("identifier", (NBTBase)this.identifier.func_77955_b(new NBTTagCompound()));
        tag.func_74757_a("isTool", this.isTool);
        if (this.acceptedType != null) {
            tag.func_74778_a("acceptedType", this.acceptedType);
        }
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreferenceIngredient that = (PreferenceIngredient)o;
        return this.isTool == that.isTool && this.identifier.equals(that.identifier) && Objects.equals(this.acceptedType, that.acceptedType);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.isTool, this.acceptedType);
    }
}

