/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.jei.collectors;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class FuelUpgradeRecipe
implements IRecipeWrapper {
    private ItemStack input;
    private ItemStack output;
    private long upgradeEMC;

    public FuelUpgradeRecipe(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.upgradeEMC = EMCHelper.getEmcValue(output) - EMCHelper.getEmcValue(input);
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public long getUpgradeEMC() {
        return this.upgradeEMC;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)this.getInput());
        ingredients.setOutput(ItemStack.class, (Object)this.getOutput());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String emc = Long.toString(this.getUpgradeEMC());
        FontRenderer fontRenderer = minecraft.field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(emc);
        fontRenderer.func_78276_b(emc, recipeWidth / 2 - stringWidth / 2, 5, Color.gray.getRGB());
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 67 && mouseX < 107 && mouseY > 0 && mouseY < 20) {
            return Collections.singletonList("EMC needed to upgrade");
        }
        return Collections.emptyList();
    }
}

