/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ivorius.ivtoolkit.models.Animation;
import ivorius.ivtoolkit.models.Attribute;
import ivorius.ivtoolkit.models.Material;
import ivorius.ivtoolkit.models.Mesh;
import ivorius.ivtoolkit.models.MeshPart;
import ivorius.ivtoolkit.models.Model;
import ivorius.ivtoolkit.models.Node;
import ivorius.ivtoolkit.models.NodeAnimation;
import ivorius.ivtoolkit.models.NodeKeyframe;
import ivorius.ivtoolkit.models.NodePart;
import ivorius.ivtoolkit.models.attributes.BlendingAttribute;
import ivorius.ivtoolkit.models.attributes.ColorAttribute;
import ivorius.ivtoolkit.models.attributes.FloatAttribute;
import ivorius.ivtoolkit.models.attributes.TextureAttribute;
import ivorius.ivtoolkit.models.data.VertexAttribute;
import ivorius.ivtoolkit.models.data.VertexAttributes;
import ivorius.ivtoolkit.models.loaders.ModelLoader;
import ivorius.ivtoolkit.models.loaders.data.ColorDeserializer;
import ivorius.ivtoolkit.models.loaders.data.QuaternionDeserializer;
import ivorius.ivtoolkit.models.loaders.data.Vector2fDeserializer;
import ivorius.ivtoolkit.models.loaders.data.Vector3fDeserializer;
import ivorius.ivtoolkit.models.loaders.g3d.G3DAnimation;
import ivorius.ivtoolkit.models.loaders.g3d.G3DBone;
import ivorius.ivtoolkit.models.loaders.g3d.G3DKeyframe;
import ivorius.ivtoolkit.models.loaders.g3d.G3DMaterial;
import ivorius.ivtoolkit.models.loaders.g3d.G3DMesh;
import ivorius.ivtoolkit.models.loaders.g3d.G3DMeshPart;
import ivorius.ivtoolkit.models.loaders.g3d.G3DModel;
import ivorius.ivtoolkit.models.loaders.g3d.G3DNode;
import ivorius.ivtoolkit.models.loaders.g3d.G3DNodeAnimation;
import ivorius.ivtoolkit.models.loaders.g3d.G3DNodePart;
import ivorius.ivtoolkit.models.loaders.g3d.G3DTexture;
import ivorius.ivtoolkit.models.textures.Texture;
import ivorius.ivtoolkit.models.textures.TextureProvider;
import ivorius.ivtoolkit.models.textures.TextureSub;
import ivorius.ivtoolkit.models.utils.ArrayMap;
import ivorius.ivtoolkit.models.utils.BufferUtils;
import ivorius.ivtoolkit.models.utils.MatrixMathUtils;
import java.awt.Color;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Quaternion;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.ReadableVector4f;
import org.lwjgl.util.vector.Vector2f;
import org.lwjgl.util.vector.Vector3f;

public class G3DModelLoader
implements ModelLoader {
    public static final short VERSION_HI = 0;
    public static final short VERSION_LO = 1;
    private Logger logger;
    private Gson gson;

    public G3DModelLoader(Logger logger) {
        this.logger = logger;
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Color.class, (Object)new ColorDeserializer());
        gsonBuilder.registerTypeAdapter(Quaternion.class, (Object)new QuaternionDeserializer());
        gsonBuilder.registerTypeAdapter(Vector2f.class, (Object)new Vector2fDeserializer());
        gsonBuilder.registerTypeAdapter(Vector3f.class, (Object)new Vector3fDeserializer());
        this.gson = gsonBuilder.create();
    }

    @Override
    public Model createModel(Reader reader, TextureProvider textureProvider) {
        G3DModel g3DModel = (G3DModel)this.gson.fromJson(reader, G3DModel.class);
        return G3DModelLoader.modelFromRawModel(g3DModel, textureProvider, this.logger);
    }

    public static Model modelFromRawModel(G3DModel g3DModel, TextureProvider textureProvider, Logger logger) {
        if (g3DModel.version == null) {
            g3DModel.version = new short[]{0, 1};
        }
        if (g3DModel.version[0] != 0 || g3DModel.version[1] != 1) {
            logger.error("Version number of g3d file unknown");
            return null;
        }
        HashMap<String, Node> nodeMap = new HashMap<String, Node>();
        Model model = new Model();
        G3DModelLoader.loadMeshes(model, Arrays.asList(g3DModel.meshes));
        G3DModelLoader.loadMaterials(model, Arrays.asList(g3DModel.materials), textureProvider, logger);
        G3DModelLoader.loadNodes(model, Arrays.asList(g3DModel.nodes), nodeMap);
        G3DModelLoader.loadAnimations(model, Arrays.asList(g3DModel.animations), nodeMap);
        return model;
    }

    private static void loadMeshes(Model model, Iterable<G3DMesh> meshes) {
        for (G3DMesh g3DMesh : meshes) {
            Mesh mesh = G3DModelLoader.convertMesh(g3DMesh, model.meshParts);
            model.meshes.add(mesh);
            model.disposables.add(mesh);
        }
    }

    public static Mesh convertMesh(G3DMesh g3DMesh, List<MeshPart> meshParts) {
        int numIndices = 0;
        for (G3DMeshPart part : g3DMesh.parts) {
            numIndices += part.indices.length;
        }
        VertexAttributes attributes = new VertexAttributes(G3DModelLoader.parseVertexAttributes(g3DMesh.attributes));
        int numVertices = g3DMesh.vertices.length / (attributes.vertexSize / 4);
        Mesh mesh = new Mesh(true, numVertices, numIndices, attributes);
        BufferUtils.copy(g3DMesh.vertices, mesh.getVerticesBuffer(), g3DMesh.vertices.length, 0);
        int offset = 0;
        mesh.getIndicesBuffer().clear();
        for (G3DMeshPart part : g3DMesh.parts) {
            MeshPart meshPart = new MeshPart();
            meshPart.id = part.id;
            meshPart.primitiveType = G3DModelLoader.parseGLDrawMode(part.type);
            meshPart.indexOffset = offset;
            meshPart.numVertices = part.indices.length;
            meshPart.mesh = mesh;
            mesh.getIndicesBuffer().put(part.indices);
            offset += meshPart.numVertices;
            meshParts.add(meshPart);
        }
        mesh.getIndicesBuffer().position(0);
        return mesh;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadNodes(Model model, List<G3DNode> g3DNodes, Map<String, Node> nodeMap) {
        void var5_9;
        HashMap<String, Material> materials = new HashMap<String, Material>();
        for (Material material : model.materials) {
            materials.put(material.id, material);
        }
        HashMap<String, MeshPart> meshParts = new HashMap<String, MeshPart>();
        for (MeshPart meshPart : model.meshParts) {
            meshParts.put(meshPart.id, meshPart);
        }
        for (G3DNode g3DNode : g3DNodes) {
            model.nodes.add(G3DModelLoader.convertNodeWithoutParts(g3DNode, nodeMap));
        }
        boolean bl = false;
        while (var5_9 < g3DNodes.size()) {
            G3DModelLoader.convertNodeParts(model.nodes.get((int)var5_9), g3DNodes.get((int)var5_9), nodeMap, materials, meshParts);
            ++var5_9;
        }
    }

    public static Node convertNodeWithoutParts(G3DNode g3DNode, Map<String, Node> nodeMap) {
        Node node = new Node();
        node.id = g3DNode.id;
        nodeMap.put(node.id, node);
        if (g3DNode.translation != null) {
            node.translation.set((ReadableVector3f)g3DNode.translation);
        }
        if (g3DNode.rotation != null) {
            node.rotation.set((ReadableVector4f)g3DNode.rotation);
        }
        if (g3DNode.scale != null) {
            node.scale.set((ReadableVector3f)g3DNode.scale);
        }
        if (g3DNode.children != null) {
            for (G3DNode g3dChild : g3DNode.children) {
                Node child = G3DModelLoader.convertNodeWithoutParts(g3dChild, nodeMap);
                node.children.add(child);
                child.parent = node;
            }
        }
        return node;
    }

    public static void convertNodeParts(Node node, G3DNode g3DNode, Map<String, Node> nodes, Map<String, Material> materials, Map<String, MeshPart> meshParts) {
        if (g3DNode.parts != null) {
            for (G3DNodePart g3DNodePart : g3DNode.parts) {
                node.parts.add(G3DModelLoader.convertNodePart(g3DNodePart, nodes, materials, meshParts));
            }
        }
    }

    public static NodePart convertNodePart(G3DNodePart g3DNodePart, Map<String, Node> nodes, Map<String, Material> materials, Map<String, MeshPart> meshParts) {
        NodePart nodePart = new NodePart();
        nodePart.meshPart = meshParts.get(g3DNodePart.meshpartid);
        nodePart.material = materials.get(g3DNodePart.materialid);
        if (nodePart.material == null) {
            nodePart.material = new Material();
        }
        nodePart.bones = new Matrix4f[g3DNodePart.bones.length];
        nodePart.invBoneBindTransforms = new ArrayMap(Node.class, Matrix4f.class);
        for (int i = 0; i < g3DNodePart.bones.length; ++i) {
            G3DBone bone = g3DNodePart.bones[i];
            nodePart.bones[i] = new Matrix4f();
            Matrix4f matrix = new Matrix4f();
            MatrixMathUtils.setTRS(matrix, bone.translation, bone.rotation, bone.scale);
            Matrix4f.invert((Matrix4f)matrix, (Matrix4f)matrix);
            nodePart.invBoneBindTransforms.put(nodes.get(bone.node), matrix, i);
        }
        return nodePart;
    }

    private static void loadMaterials(Model model, List<G3DMaterial> g3DMaterials, TextureProvider textureProvider, Logger logger) {
        for (G3DMaterial g3DMaterial : g3DMaterials) {
            model.materials.add(G3DModelLoader.convertMaterial(g3DMaterial, textureProvider, logger));
        }
    }

    public static Material convertMaterial(G3DMaterial g3DMaterial, TextureProvider textureProvider, Logger logger) {
        Material material = new Material();
        material.id = g3DMaterial.id;
        if (g3DMaterial.ambient != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Ambient, g3DMaterial.ambient));
        }
        if (g3DMaterial.diffuse != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, g3DMaterial.diffuse));
        }
        if (g3DMaterial.specular != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, g3DMaterial.specular));
        }
        if (g3DMaterial.emissive != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, g3DMaterial.emissive));
        }
        if (g3DMaterial.reflection != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Reflection, g3DMaterial.reflection));
        }
        if (g3DMaterial.shininess > 0.0f) {
            material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, g3DMaterial.shininess));
        }
        if (g3DMaterial.opacity != 1.0f) {
            material.set((Attribute)new BlendingAttribute(770, 771, g3DMaterial.opacity));
        }
        if (g3DMaterial.textures != null) {
            block12: for (G3DTexture tex : g3DMaterial.textures) {
                Texture texture = textureProvider.provideTexture(tex.filename);
                if (tex.uvScaling != null && (tex.uvScaling.getX() != 1.0f || tex.uvScaling.getY() != 1.0f) || tex.uvTranslation != null && (tex.uvTranslation.getX() != 0.0f || tex.uvTranslation.getY() != 0.0f)) {
                    Vector2f scale = tex.uvScaling != null ? tex.uvScaling : new Vector2f(1.0f, 1.0f);
                    Vector2f trans = tex.uvTranslation != null ? tex.uvTranslation : new Vector2f(0.0f, 0.0f);
                    texture = new TextureSub(texture, trans.getX(), trans.getY(), trans.getX() + scale.getX(), trans.getY() + scale.getY());
                }
                switch (tex.type) {
                    case "DIFFUSE": {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, texture));
                        continue block12;
                    }
                    case "SPECULAR": {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Specular, texture));
                        continue block12;
                    }
                    case "BUMP": {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Bump, texture));
                        continue block12;
                    }
                    case "NORMAL": {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Normal, texture));
                        continue block12;
                    }
                    default: {
                        if (logger == null) continue block12;
                        logger.warn("Unknown texture type: '" + tex.type + "'");
                    }
                }
            }
        }
        return material;
    }

    private static void loadAnimations(Model model, List<G3DAnimation> animations, Map<String, Node> nodes) {
        for (G3DAnimation animation : animations) {
            model.animations.add(G3DModelLoader.convertAnimation(animation, nodes));
        }
    }

    public static Animation convertAnimation(G3DAnimation g3DAnimation, Map<String, Node> nodes) {
        Animation animation = new Animation();
        animation.id = g3DAnimation.id;
        for (G3DNodeAnimation nodeAnimation : g3DAnimation.bones) {
            animation.nodeAnimations.add(G3DModelLoader.convertNodeAnimation(nodeAnimation, nodes));
        }
        float highestKeytime = 0.0f;
        for (NodeAnimation nodeAnimation : animation.nodeAnimations) {
            for (NodeKeyframe nodeKeyframe : nodeAnimation.keyframes) {
                if (!(nodeKeyframe.keytime > highestKeytime)) continue;
                highestKeytime = nodeKeyframe.keytime;
            }
        }
        animation.duration = highestKeytime;
        return animation;
    }

    public static NodeAnimation convertNodeAnimation(G3DNodeAnimation g3DNodeAnimation, Map<String, Node> nodes) {
        NodeAnimation nodeAnimation = new NodeAnimation();
        nodeAnimation.node = nodes.get(g3DNodeAnimation.boneId);
        for (G3DKeyframe keyframe : g3DNodeAnimation.keyframes) {
            nodeAnimation.addKeyframe(G3DModelLoader.convertKeyframe(keyframe));
        }
        return nodeAnimation;
    }

    public static NodeKeyframe convertKeyframe(G3DKeyframe g3DKeyframe) {
        NodeKeyframe keyframe = new NodeKeyframe();
        keyframe.keytime = g3DKeyframe.keytime;
        keyframe.rotation = g3DKeyframe.rotation;
        keyframe.translation = g3DKeyframe.translation;
        keyframe.scale = g3DKeyframe.scale;
        return keyframe;
    }

    private static int parseGLDrawMode(String type) {
        switch (type) {
            case "TRIANGLES": {
                return 4;
            }
            case "LINES": {
                return 1;
            }
            case "POINTS": {
                return 0;
            }
            case "TRIANGLE_STRIP": {
                return 5;
            }
            case "LINE_STRIP": {
                return 3;
            }
        }
        throw new RuntimeException("Unknown primitive type '" + type + "', should be one of triangle, trianglestrip, line, linestrip, lineloop or point");
    }

    public static VertexAttribute[] parseVertexAttributes(String[] attributes) {
        ArrayList<VertexAttribute> vertexAttributes = new ArrayList<VertexAttribute>();
        int unit = 0;
        int blendWeightCount = 0;
        for (String attribute : attributes) {
            if (attribute.equals("POSITION")) {
                vertexAttributes.add(VertexAttribute.Position());
                continue;
            }
            if (attribute.equals("NORMAL")) {
                vertexAttributes.add(VertexAttribute.Normal());
                continue;
            }
            if (attribute.equals("COLOR")) {
                vertexAttributes.add(VertexAttribute.ColorUnpacked());
                continue;
            }
            if (attribute.equals("COLORPACKED")) {
                vertexAttributes.add(VertexAttribute.ColorPacked());
                continue;
            }
            if (attribute.equals("TANGENT")) {
                vertexAttributes.add(VertexAttribute.Tangent());
                continue;
            }
            if (attribute.equals("BINORMAL")) {
                vertexAttributes.add(VertexAttribute.Binormal());
                continue;
            }
            if (attribute.startsWith("TEXCOORD")) {
                vertexAttributes.add(VertexAttribute.TexCoords(unit++));
                continue;
            }
            if (attribute.startsWith("BLENDWEIGHT")) {
                vertexAttributes.add(VertexAttribute.BoneWeight(blendWeightCount++));
                continue;
            }
            throw new RuntimeException("Unknown vertex attribute '" + attribute + "', should be one of position, normal, uv, tangent or binormal");
        }
        return vertexAttributes.toArray(new VertexAttribute[vertexAttributes.size()]);
    }
}

