/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.commands.structure;

import ivorius.ivtoolkit.util.IvStreams;
import ivorius.reccomplex.RCConfig;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.commands.parameters.RCP;
import ivorius.reccomplex.commands.parameters.expect.RCE;
import ivorius.reccomplex.files.RCFiles;
import ivorius.reccomplex.files.loading.FileSuffixFilter;
import ivorius.reccomplex.shadow.mcopts.commands.CommandExpecting;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.MCP;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.Parameters;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.Expect;
import ivorius.reccomplex.shadow.mcopts.commands.parameters.expect.MCE;
import ivorius.reccomplex.world.gen.feature.WorldGenStructures;
import ivorius.reccomplex.world.gen.feature.structure.Structure;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import org.apache.commons.lang3.tuple.Pair;

public class CommandRetrogen
extends CommandExpecting {
    public static Stream<Pair<Integer, Integer>> existingRegions(File worldDir) {
        File regionsDirectory = RCFiles.getValidatedFolder(new File(worldDir, "region"), false);
        if (regionsDirectory == null) {
            return Stream.empty();
        }
        String[] mcas = regionsDirectory.list(new FileSuffixFilter("mca"));
        if (mcas == null) {
            throw new IllegalStateException();
        }
        return Arrays.stream(mcas).map(s -> s.split("\\.")).filter(p -> ((String[])p).length == 4 && p[0].equals("r")).map(p -> Pair.of((Object)Integer.parseInt(p[1]), (Object)Integer.parseInt(p[2]))).filter(rfc -> rfc.getLeft() != null && rfc.getRight() != null);
    }

    public static Stream<ChunkPos> existingChunks(World world) {
        File worldDirectory = world.func_72860_G().func_75765_b();
        return CommandRetrogen.existingRegions(worldDirectory).map(rfc -> new ChunkPos((Integer)rfc.getLeft() << 5, (Integer)rfc.getRight() << 5)).map(rflc -> Pair.of((Object)RegionFileCache.func_76550_a((File)worldDirectory, (int)rflc.field_77276_a, (int)rflc.field_77275_b), (Object)rflc)).flatMap(r -> IvStreams.flatMapToObj(IntStream.range(0, 32), x -> IntStream.range(0, 32).mapToObj(z -> Pair.of((Object)r.getLeft(), (Object)CommandRetrogen.add((ChunkPos)r.getRight(), x, z))))).filter(p -> ((RegionFile)p.getLeft()).chunkExists(((ChunkPos)p.getRight()).field_77276_a & 0x1F, ((ChunkPos)p.getRight()).field_77275_b & 0x1F)).map(Pair::getRight);
    }

    @Nonnull
    protected static ChunkPos add(ChunkPos pos, int x, int z) {
        return new ChunkPos(x + pos.field_77276_a, z + pos.field_77275_b);
    }

    public static Random getRandom(WorldServer world, ChunkPos pos) {
        return world.func_72843_D(pos.field_77276_a, pos.field_77275_b, -559038737);
    }

    public static long retrogen(WorldServer world, Predicate<Structure> structurePredicate) {
        return CommandRetrogen.existingChunks((World)world).filter(pos -> world.func_72964_e(pos.field_77276_a, pos.field_77275_b).func_177419_t()).filter(pos -> WorldGenStructures.decorate(world, CommandRetrogen.getRandom(world, pos), pos, structurePredicate)).count();
    }

    public String func_71517_b() {
        return RCConfig.commandPrefix + "retro";
    }

    public int func_82362_a() {
        return 2;
    }

    @Override
    public void expect(Expect expect) {
        expect.named("exp", new String[0]).words(RCE::structurePredicate).descriptionU("resource expression: only generate these structures").named("dimension", "d").then(MCE::dimension);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender commandSender, String[] args) throws CommandException {
        Parameters parameters = Parameters.of(args, this.expect()::declare);
        Predicate structurePredicate = parameters.get("exp").to(RCP::structurePredicate).optional().orElse(null);
        WorldServer world = (WorldServer)parameters.get("dimension").to(MCP.dimension(server, commandSender)).require();
        long count = CommandRetrogen.retrogen(world, structurePredicate);
        commandSender.func_145747_a(RecurrentComplex.translations.format("commands.rcretro.count", String.valueOf(count)));
    }
}

