/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.random;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.SimpleLeveledRegistry;
import ivorius.reccomplex.random.Person;
import ivorius.reccomplex.random.Place;
import ivorius.reccomplex.utils.tokenizer.SymbolTokenizer;
import ivorius.reccomplex.utils.tokenizer.TokenReplacer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class Poem {
    private static final int TITLE_TRIES = 50;
    public static SimpleLeveledRegistry<Theme> THEME_REGISTRY = new SimpleLeveledRegistry("poem theme");
    private String title;
    private String text;

    public Poem(String title, String text) {
        this.title = title;
        this.text = text;
    }

    public static Poem randomPoem(Random random, Integer maxTitleLength, Person author) {
        StitchedTheme theme = StitchedTheme.random(author);
        PoemContext poemContext = new PoemContext();
        while (poemContext.add(random, poemContext.names, 0.3f, Person.randomHuman(random, random.nextBoolean()).getFirstName())) {
        }
        while (poemContext.add(random, poemContext.places, 0.3f, Place.randomPlace(random).getFullPlaceType())) {
        }
        String title = Poem.randomTitle(random, poemContext, maxTitleLength, theme);
        String phrase = null;
        try {
            phrase = Poem.evaluate(random, theme.get("text"), poemContext, theme);
        }
        catch (TokenReplacer.OverpoemedException e) {
            RecurrentComplex.logger.error(String.format("Too much text with theme: %s", theme));
            phrase = String.format("ERROR: %s", theme);
        }
        return new Poem(title, phrase);
    }

    @Nonnull
    protected static String randomTitle(Random random, PoemContext poemContext, Integer maxLength, StitchedTheme theme) {
        for (int i = 0; i <= 50; ++i) {
            String title;
            try {
                title = Poem.evaluate(random, theme.get("title"), poemContext, theme).trim();
            }
            catch (TokenReplacer.OverpoemedException e) {
                RecurrentComplex.logger.error(String.format("Too much title with theme: %s", theme));
                return String.format("ERROR: %s", theme);
            }
            if (i == 50) {
                return StringUtils.abbreviate((String)title, (int)maxLength);
            }
            if (maxLength != null && title.length() >= maxLength) continue;
            return title;
        }
        throw new RuntimeException("Shouldn't be here");
    }

    private static String evaluate(Random random, List<List<TokenReplacer.Token>> patterns, PoemContext context, StitchedTheme theme) throws TokenReplacer.OverpoemedException {
        return TokenReplacer.evaluate(random, Poem.getRandomElementFrom(patterns, random), context, theme);
    }

    private static <O> O getRandomElementFrom(List<O> list, Random random) {
        return list.get(random.nextInt(list.size()));
    }

    @Nonnull
    protected static TokenReplacer.ReplaceFactory factory() {
        return new TokenReplacer.ReplaceFactory<PoemContext>(){

            @Override
            @Nonnull
            protected TokenReplacer.Exploder<PoemContext> exploder(String tag, List<String> params) {
                switch (tag) {
                    case "br": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> "\n");
                    }
                    case "place": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> (String)Poem.getRandomElementFrom(context.places, random));
                    }
                    case "name": {
                        return TokenReplacer.Exploder.string((token, theme, context, random) -> (String)Poem.getRandomElementFrom(context.names, random));
                    }
                    case "number": {
                        return TokenReplacer.Exploder.string(this.numEvaluator(Integer.valueOf(TokenReplacer.Theme.parameter(params, 0, "2")), Integer.valueOf(TokenReplacer.Theme.parameter(params, 1, "10")), Integer.valueOf(TokenReplacer.Theme.parameter(params, 2, "1"))));
                    }
                }
                return (token, theme, context, random) -> {
                    List<List<TokenReplacer.Token>> list = theme.get(tag);
                    return list == null || list.isEmpty() ? Collections.singletonList(new TokenReplacer.StringToken(0, 0, "EMPTY")) : (List<TokenReplacer.StringToken>)Poem.getRandomElementFrom(list, random);
                };
            }

            private TokenReplacer.Exploder.StringExploder<PoemContext> numEvaluator(int min, int max, int mul) {
                return (token, theme, context, random) -> String.valueOf((random.nextInt(max - min + 1) + min) * mul);
            }
        };
    }

    public String getTitle() {
        return this.title;
    }

    public String getText() {
        return this.text;
    }

    public static class StitchedTheme {
        protected Map<String, List<List<TokenReplacer.Token>>> converters;
        protected List<String> titles = new ArrayList<String>();

        public static StitchedTheme random(Person author) {
            Random styleRandom = new Random(author.hashCode());
            SymbolTokenizer<TokenReplacer.Token> tokenizer = new SymbolTokenizer<TokenReplacer.Token>(new SymbolTokenizer.SimpleCharacterRules(Character.valueOf('\\'), null, new char[0], null), Poem.factory());
            StitchedTheme stitchedTheme = new StitchedTheme();
            HashMultimap map = HashMultimap.create();
            do {
                Theme theme = (Theme)Poem.getRandomElementFrom(new ArrayList<Theme>(THEME_REGISTRY.allActive()), styleRandom);
                stitchedTheme.titles.add(THEME_REGISTRY.id(theme));
                float acceptance = styleRandom.nextFloat();
                Multimap<String, List<TokenReplacer.Token>> builtTheme = theme.build((Multimap<String, List<TokenReplacer.Token>>)HashMultimap.create(), tokenizer);
                builtTheme.asMap().values().forEach(v -> v.removeIf(p -> styleRandom.nextFloat() < acceptance && v.size() > 1));
                map.putAll(builtTheme);
            } while (styleRandom.nextBoolean());
            stitchedTheme.converters = StitchedTheme.build((Multimap<String, List<TokenReplacer.Token>>)map);
            return stitchedTheme;
        }

        public static Map<String, List<List<TokenReplacer.Token>>> build(Multimap<String, List<TokenReplacer.Token>> build) {
            return build.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, k -> Lists.newArrayList((Iterable)((Iterable)k.getValue()))));
        }

        public List<List<TokenReplacer.Token>> get(String title) {
            return this.converters.get(title);
        }

        public String toString() {
            return String.format("Stitched: %s", this.titles);
        }
    }

    public static class Theme
    extends TokenReplacer.Theme {
        public static Theme fromFile(String fileContents) {
            Theme theme = new Theme();
            theme.read(fileContents);
            return theme;
        }

        @Override
        protected TokenReplacer.Theme getOther(String include) {
            return THEME_REGISTRY.get(include);
        }
    }

    public static class PoemContext {
        public List<String> names = new ArrayList<String>();
        public List<String> places = new ArrayList<String>();

        public boolean add(Random random, List<String> list, float continueChance, String value) {
            list.add(value);
            return random.nextFloat() < continueChance;
        }
    }
}

