/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.algebra;

import ivorius.reccomplex.utils.algebra.Algebra;
import ivorius.reccomplex.utils.algebra.Algebras;
import java.util.function.Function;

public abstract class BoolAlgebra {
    public static final Function<String, Boolean> CONSTANT_EVALUATOR = Boolean::valueOf;

    public static Algebras.Unary<Boolean> not(String symbol) {
        return new Algebras.Unary<Boolean>(5.0f, Algebras.Unary.Notation.PREFIX, symbol){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V> expression) {
                return expression.evaluate(variableEvaluator) == false;
            }
        };
    }

    public static Algebras.Infix<Boolean> and(String symbol) {
        return new Algebras.Infix<Boolean>(4.0f, symbol){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V> left, Algebra.Expression<Boolean, V> right) {
                return left.evaluate(variableEvaluator) != false && right.evaluate(variableEvaluator) != false;
            }
        };
    }

    public static Algebras.Infix<Boolean> or(String symbol) {
        return new Algebras.Infix<Boolean>(4.0f, symbol){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V> left, Algebra.Expression<Boolean, V> right) {
                return left.evaluate(variableEvaluator) != false || right.evaluate(variableEvaluator) != false;
            }
        };
    }

    public static Algebras.Infix<Boolean> equals(String symbol) {
        return new Algebras.Infix<Boolean>(3.0f, symbol){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V> left, Algebra.Expression<Boolean, V> right) {
                return left.evaluate(variableEvaluator) == right.evaluate(variableEvaluator);
            }
        };
    }

    public static Algebras.Infix<Boolean> unEquals(String symbol) {
        return new Algebras.Infix<Boolean>(3.0f, symbol){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V> left, Algebra.Expression<Boolean, V> right) {
                return left.evaluate(variableEvaluator) == right.evaluate(variableEvaluator);
            }
        };
    }

    public static Algebra.Operator<Boolean> conditional(String left, String right) {
        return new Algebra.Operator<Boolean>(2.0f, true, true, new String[]{left, right}){

            @Override
            public <V> Boolean evaluate(Function<V, Boolean> variableEvaluator, Algebra.Expression<Boolean, V>[] expressions) {
                return expressions[0].evaluate(variableEvaluator) != false ? expressions[1].evaluate(variableEvaluator) : expressions[2].evaluate(variableEvaluator);
            }
        };
    }

    public static Algebras.Parentheses<Boolean> parentheses(String left, String right) {
        return new Algebras.Parentheses<Boolean>(1.0f, left, right);
    }
}

